/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.openapi;

import io.apicurio.datamodels.openapi.models.OasSchema;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import org.citrusframework.context.TestContext;
import org.citrusframework.openapi.OpenApiSpecification;
import org.citrusframework.openapi.model.OasModelHelper;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class OpenApiTestDataGenerator {
    public static String createOutboundPayload(OasSchema schema, Map<String, OasSchema> definitions, OpenApiSpecification specification) {
        if (OasModelHelper.isReferenceType(schema)) {
            OasSchema resolved = definitions.get(OasModelHelper.getReferenceName(schema.$ref));
            return OpenApiTestDataGenerator.createOutboundPayload(resolved, definitions, specification);
        }
        StringBuilder payload = new StringBuilder();
        if (OasModelHelper.isObjectType(schema)) {
            payload.append("{");
            if (schema.properties != null) {
                for (Map.Entry entry : schema.properties.entrySet()) {
                    if (!specification.isGenerateOptionalFields() && !OpenApiTestDataGenerator.isRequired(schema, (String)entry.getKey())) continue;
                    payload.append("\"").append((String)entry.getKey()).append("\": ").append(OpenApiTestDataGenerator.createRandomValueExpression((OasSchema)entry.getValue(), definitions, true, specification)).append(",");
                }
            }
            if (payload.toString().endsWith(",")) {
                payload.replace(payload.length() - 1, payload.length(), "");
            }
            payload.append("}");
        } else if (OasModelHelper.isArrayType(schema)) {
            payload.append("[");
            payload.append(OpenApiTestDataGenerator.createRandomValueExpression((OasSchema)schema.items, definitions, true, specification));
            payload.append("]");
        } else {
            payload.append(OpenApiTestDataGenerator.createRandomValueExpression(schema, definitions, true, specification));
        }
        return payload.toString();
    }

    public static String createRandomValueExpression(String name, OasSchema schema, Map<String, OasSchema> definitions, boolean quotes, OpenApiSpecification specification, TestContext context) {
        if (context.getVariables().containsKey(name)) {
            return "${" + name + "}";
        }
        return OpenApiTestDataGenerator.createRandomValueExpression(schema, definitions, quotes, specification);
    }

    public static String createRandomValueExpression(OasSchema schema, Map<String, OasSchema> definitions, boolean quotes, OpenApiSpecification specification) {
        if (OasModelHelper.isReferenceType(schema)) {
            OasSchema resolved = definitions.get(OasModelHelper.getReferenceName(schema.$ref));
            return OpenApiTestDataGenerator.createRandomValueExpression(resolved, definitions, quotes, specification);
        }
        StringBuilder payload = new StringBuilder();
        if (OasModelHelper.isObjectType(schema) || OasModelHelper.isArrayType(schema)) {
            payload.append(OpenApiTestDataGenerator.createOutboundPayload(schema, definitions, specification));
        } else if ("string".equals(schema.type)) {
            if (quotes) {
                payload.append("\"");
            }
            if (schema.format != null && schema.format.equals("date")) {
                payload.append("citrus:currentDate()");
            } else if (schema.format != null && schema.format.equals("date-time")) {
                payload.append("citrus:currentDate('yyyy-MM-dd'T'hh:mm:ss')");
            } else if (StringUtils.hasText((String)schema.pattern)) {
                payload.append("citrus:randomValue(").append(schema.pattern).append(")");
            } else if (!CollectionUtils.isEmpty((Collection)schema.enum_)) {
                payload.append("citrus:randomEnumValue(").append(schema.enum_.stream().map(value -> "'" + value + "'").collect(Collectors.joining(","))).append(")");
            } else if (schema.format != null && schema.format.equals("uuid")) {
                payload.append("citrus:randomUUID()");
            } else {
                payload.append("citrus:randomString(").append(schema.maxLength != null && schema.maxLength.intValue() > 0 ? (Number)schema.maxLength : (Number)(schema.minLength != null && schema.minLength.intValue() > 0 ? (Number)schema.minLength : (Number)10)).append(")");
            }
            if (quotes) {
                payload.append("\"");
            }
        } else if ("integer".equals(schema.type) || "number".equals(schema.type)) {
            payload.append("citrus:randomNumber(8)");
        } else if ("boolean".equals(schema.type)) {
            payload.append("citrus:randomEnumValue('true', 'false')");
        } else if (quotes) {
            payload.append("\"\"");
        }
        return payload.toString();
    }

    public static String createInboundPayload(OasSchema schema, Map<String, OasSchema> definitions, OpenApiSpecification specification) {
        if (OasModelHelper.isReferenceType(schema)) {
            OasSchema resolved = definitions.get(OasModelHelper.getReferenceName(schema.$ref));
            return OpenApiTestDataGenerator.createInboundPayload(resolved, definitions, specification);
        }
        StringBuilder payload = new StringBuilder();
        if (OasModelHelper.isObjectType(schema)) {
            payload.append("{");
            if (schema.properties != null) {
                for (Map.Entry entry : schema.properties.entrySet()) {
                    if (!specification.isValidateOptionalFields() && !OpenApiTestDataGenerator.isRequired(schema, (String)entry.getKey())) continue;
                    payload.append("\"").append((String)entry.getKey()).append("\": ").append(OpenApiTestDataGenerator.createValidationExpression((OasSchema)entry.getValue(), definitions, true, specification)).append(",");
                }
            }
            if (payload.toString().endsWith(",")) {
                payload.replace(payload.length() - 1, payload.length(), "");
            }
            payload.append("}");
        } else if (OasModelHelper.isArrayType(schema)) {
            payload.append("[");
            payload.append(OpenApiTestDataGenerator.createValidationExpression((OasSchema)schema.items, definitions, true, specification));
            payload.append("]");
        } else {
            payload.append(OpenApiTestDataGenerator.createValidationExpression(schema, definitions, false, specification));
        }
        return payload.toString();
    }

    private static boolean isRequired(OasSchema schema, String field) {
        if (schema.required == null) {
            return true;
        }
        return schema.required.contains(field);
    }

    public static String createValidationExpression(String name, OasSchema schema, Map<String, OasSchema> definitions, boolean quotes, OpenApiSpecification specification, TestContext context) {
        if (context.getVariables().containsKey(name)) {
            return "${" + name + "}";
        }
        return OpenApiTestDataGenerator.createValidationExpression(schema, definitions, quotes, specification);
    }

    public static String createValidationExpression(OasSchema schema, Map<String, OasSchema> definitions, boolean quotes, OpenApiSpecification specification) {
        if (OasModelHelper.isReferenceType(schema)) {
            OasSchema resolved = definitions.get(OasModelHelper.getReferenceName(schema.$ref));
            return OpenApiTestDataGenerator.createValidationExpression(resolved, definitions, quotes, specification);
        }
        StringBuilder payload = new StringBuilder();
        if (OasModelHelper.isObjectType(schema)) {
            payload.append("{");
            if (schema.properties != null) {
                for (Map.Entry entry : schema.properties.entrySet()) {
                    if (!specification.isValidateOptionalFields() && !OpenApiTestDataGenerator.isRequired(schema, (String)entry.getKey())) continue;
                    payload.append("\"").append((String)entry.getKey()).append("\": ").append(OpenApiTestDataGenerator.createValidationExpression((OasSchema)entry.getValue(), definitions, quotes, specification)).append(",");
                }
            }
            if (payload.toString().endsWith(",")) {
                payload.replace(payload.length() - 1, payload.length(), "");
            }
            payload.append("}");
        } else {
            if (quotes) {
                payload.append("\"");
            }
            payload.append(OpenApiTestDataGenerator.createValidationExpression(schema));
            if (quotes) {
                payload.append("\"");
            }
        }
        return payload.toString();
    }

    private static String createValidationExpression(OasSchema schema) {
        switch (schema.type) {
            case "string": {
                if (schema.format != null && schema.format.equals("date")) {
                    return "@matchesDatePattern('yyyy-MM-dd')@";
                }
                if (schema.format != null && schema.format.equals("date-time")) {
                    return "@matchesDatePattern('yyyy-MM-dd'T'hh:mm:ss')@";
                }
                if (StringUtils.hasText((String)schema.pattern)) {
                    return String.format("@matches(%s)@", schema.pattern);
                }
                if (!CollectionUtils.isEmpty((Collection)schema.enum_)) {
                    return String.format("@matches(%s)@", String.join((CharSequence)"|", schema.enum_));
                }
                return "@notEmpty()@";
            }
            case "number": 
            case "integer": {
                return "@isNumber()@";
            }
            case "boolean": {
                return "@matches(true|false)@";
            }
        }
        return "@ignore@";
    }

    public static String createRandomValueExpression(String name, OasSchema schema, TestContext context) {
        if (context.getVariables().containsKey(name)) {
            return "${" + name + "}";
        }
        return OpenApiTestDataGenerator.createRandomValueExpression(schema);
    }

    public static String createRandomValueExpression(OasSchema schema) {
        switch (schema.type) {
            case "string": {
                if (schema.format != null && schema.format.equals("date")) {
                    return "\"citrus:currentDate('yyyy-MM-dd')\"";
                }
                if (schema.format != null && schema.format.equals("date-time")) {
                    return "\"citrus:currentDate('yyyy-MM-dd'T'hh:mm:ss')\"";
                }
                if (StringUtils.hasText((String)schema.pattern)) {
                    return "\"citrus:randomValue(" + schema.pattern + ")\"";
                }
                if (!CollectionUtils.isEmpty((Collection)schema.enum_)) {
                    return "\"citrus:randomEnumValue(" + String.join((CharSequence)",", schema.enum_) + ")\"";
                }
                if (schema.format != null && schema.format.equals("uuid")) {
                    return "citrus:randomUUID()";
                }
                return "citrus:randomString(10)";
            }
            case "number": 
            case "integer": {
                return "citrus:randomNumber(8)";
            }
            case "boolean": {
                return "citrus:randomEnumValue('true', 'false')";
            }
        }
        return "";
    }
}

