/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.openapi.actions;

import java.net.URL;
import org.citrusframework.TestAction;
import org.citrusframework.TestActionBuilder;
import org.citrusframework.endpoint.Endpoint;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.http.client.HttpClient;
import org.citrusframework.openapi.OpenApiSpecification;
import org.citrusframework.openapi.actions.OpenApiClientActionBuilder;
import org.citrusframework.openapi.actions.OpenApiServerActionBuilder;
import org.citrusframework.spi.ReferenceResolver;
import org.citrusframework.spi.ReferenceResolverAware;
import org.citrusframework.util.ObjectHelper;

public class OpenApiActionBuilder
implements TestActionBuilder.DelegatingTestActionBuilder<TestAction>,
ReferenceResolverAware {
    private ReferenceResolver referenceResolver;
    private TestActionBuilder<?> delegate;
    private OpenApiSpecification specification;

    public OpenApiActionBuilder() {
    }

    public OpenApiActionBuilder(OpenApiSpecification specification) {
        this.specification = specification;
    }

    public static OpenApiActionBuilder openapi() {
        return new OpenApiActionBuilder();
    }

    public static OpenApiActionBuilder openapi(OpenApiSpecification specification) {
        return new OpenApiActionBuilder(specification);
    }

    public OpenApiActionBuilder specification(OpenApiSpecification specification) {
        this.specification = specification;
        return this;
    }

    public OpenApiActionBuilder specification(URL specUrl) {
        return this.specification(OpenApiSpecification.from(specUrl));
    }

    public OpenApiActionBuilder specification(String specUrl) {
        return this.specification(OpenApiSpecification.from(specUrl));
    }

    public OpenApiClientActionBuilder client() {
        this.assertSpecification();
        return this.client(this.specification.getRequestUrl());
    }

    public OpenApiClientActionBuilder client(HttpClient httpClient) {
        this.assertSpecification();
        if (httpClient.getEndpointConfiguration().getRequestUrl() != null) {
            this.specification.setRequestUrl(httpClient.getEndpointConfiguration().getRequestUrl());
        }
        OpenApiClientActionBuilder clientActionBuilder = new OpenApiClientActionBuilder((Endpoint)httpClient, this.specification).withReferenceResolver(this.referenceResolver);
        this.delegate = clientActionBuilder;
        return clientActionBuilder;
    }

    public OpenApiClientActionBuilder client(String httpClient) {
        this.assertSpecification();
        this.specification.setHttpClient(httpClient);
        OpenApiClientActionBuilder clientActionBuilder = new OpenApiClientActionBuilder(httpClient, this.specification).withReferenceResolver(this.referenceResolver);
        this.delegate = clientActionBuilder;
        return clientActionBuilder;
    }

    public OpenApiServerActionBuilder server(Endpoint endpoint) {
        this.assertSpecification();
        OpenApiServerActionBuilder serverActionBuilder = new OpenApiServerActionBuilder(endpoint, this.specification).withReferenceResolver(this.referenceResolver);
        this.delegate = serverActionBuilder;
        return serverActionBuilder;
    }

    private void assertSpecification() {
        if (this.specification == null) {
            throw new CitrusRuntimeException("Invalid OpenApi specification - please set specification first");
        }
    }

    public OpenApiServerActionBuilder server(String httpServer) {
        this.assertSpecification();
        OpenApiServerActionBuilder serverActionBuilder = new OpenApiServerActionBuilder(httpServer, this.specification).withReferenceResolver(this.referenceResolver);
        this.delegate = serverActionBuilder;
        return serverActionBuilder;
    }

    public OpenApiActionBuilder withReferenceResolver(ReferenceResolver referenceResolver) {
        this.referenceResolver = referenceResolver;
        return this;
    }

    public TestAction build() {
        ObjectHelper.assertNotNull(this.delegate, (String)"Missing delegate action to build");
        return this.delegate.build();
    }

    public TestActionBuilder<?> getDelegate() {
        return this.delegate;
    }

    public void setReferenceResolver(ReferenceResolver referenceResolver) {
        if (referenceResolver == null) {
            this.referenceResolver = referenceResolver;
            if (this.delegate instanceof ReferenceResolverAware) {
                ((ReferenceResolverAware)this.delegate).setReferenceResolver(referenceResolver);
            }
        }
    }
}

