/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.openapi.actions;

import io.apicurio.datamodels.openapi.models.OasDocument;
import io.apicurio.datamodels.openapi.models.OasOperation;
import io.apicurio.datamodels.openapi.models.OasParameter;
import io.apicurio.datamodels.openapi.models.OasPathItem;
import io.apicurio.datamodels.openapi.models.OasSchema;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import org.citrusframework.context.TestContext;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.http.actions.HttpClientRequestActionBuilder;
import org.citrusframework.http.message.HttpMessage;
import org.citrusframework.http.message.HttpMessageBuilder;
import org.citrusframework.message.Message;
import org.citrusframework.message.MessageBuilder;
import org.citrusframework.openapi.OpenApiSpecification;
import org.citrusframework.openapi.OpenApiTestDataGenerator;
import org.citrusframework.openapi.model.OasModelHelper;
import org.springframework.http.HttpMethod;

public class OpenApiClientRequestActionBuilder
extends HttpClientRequestActionBuilder {
    public OpenApiClientRequestActionBuilder(OpenApiSpecification openApiSpec, String operationId) {
        this(new HttpMessage(), openApiSpec, operationId);
    }

    public OpenApiClientRequestActionBuilder(HttpMessage httpMessage, OpenApiSpecification openApiSpec, String operationId) {
        super((MessageBuilder)new OpenApiClientRequestMessageBuilder(httpMessage, openApiSpec, operationId), httpMessage);
    }

    private static class OpenApiClientRequestMessageBuilder
    extends HttpMessageBuilder {
        private final OpenApiSpecification openApiSpec;
        private final String operationId;
        private final HttpMessage httpMessage;

        public OpenApiClientRequestMessageBuilder(HttpMessage httpMessage, OpenApiSpecification openApiSpec, String operationId) {
            super(httpMessage);
            this.openApiSpec = openApiSpec;
            this.operationId = operationId;
            this.httpMessage = httpMessage;
        }

        public Message build(TestContext context, String messageType) {
            OasDocument oasDocument = this.openApiSpec.getOpenApiDoc(context);
            OasOperation operation = null;
            OasPathItem pathItem = null;
            HttpMethod method = null;
            for (OasPathItem path : OasModelHelper.getPathItems(oasDocument.paths)) {
                Optional<Map.Entry> operationEntry = OasModelHelper.getOperationMap(path).entrySet().stream().filter(op -> this.operationId.equals(((OasOperation)op.getValue()).operationId)).findFirst();
                if (!operationEntry.isPresent()) continue;
                method = HttpMethod.valueOf((String)((String)operationEntry.get().getKey()).toUpperCase(Locale.US));
                operation = (OasOperation)operationEntry.get().getValue();
                pathItem = path;
                break;
            }
            if (operation == null) {
                throw new CitrusRuntimeException("Unable to locate operation with id '%s' in OpenAPI specification %s".formatted(this.operationId, this.openApiSpec.getSpecUrl()));
            }
            if (operation.parameters != null) {
                operation.parameters.stream().filter(param -> "header".equals(param.in)).filter(param -> param.required != null && param.required != false || context.getVariables().containsKey(param.getName())).forEach(param -> this.httpMessage.setHeader(param.getName(), (Object)OpenApiTestDataGenerator.createRandomValueExpression(param.getName(), (OasSchema)param.schema, OasModelHelper.getSchemaDefinitions(oasDocument), false, this.openApiSpec, context)));
                operation.parameters.stream().filter(param -> "query".equals(param.in)).filter(param -> param.required != null && param.required != false || context.getVariables().containsKey(param.getName())).forEach(param -> this.httpMessage.queryParam(param.getName(), OpenApiTestDataGenerator.createRandomValueExpression(param.getName(), (OasSchema)param.schema, context)));
            }
            Optional<OasSchema> body = OasModelHelper.getRequestBodySchema(oasDocument, operation);
            body.ifPresent(oasSchema -> this.httpMessage.setPayload((Object)OpenApiTestDataGenerator.createOutboundPayload(oasSchema, OasModelHelper.getSchemaDefinitions(oasDocument), this.openApiSpec)));
            String randomizedPath = pathItem.getPath();
            if (operation.parameters != null) {
                List<OasParameter> pathParams = operation.parameters.stream().filter(p -> "path".equals(p.in)).toList();
                for (OasParameter parameter : pathParams) {
                    Object parameterValue = context.getVariables().containsKey(parameter.getName()) ? "\\${" + parameter.getName() + "}" : OpenApiTestDataGenerator.createRandomValueExpression((OasSchema)parameter.schema);
                    randomizedPath = Pattern.compile("\\{" + parameter.getName() + "}").matcher(randomizedPath).replaceAll((String)parameterValue);
                }
            }
            OasModelHelper.getRequestContentType(operation).ifPresent(contentType -> this.httpMessage.setHeader("Content-Type", contentType));
            this.httpMessage.path(randomizedPath);
            this.httpMessage.method(method);
            return super.build(context, messageType);
        }
    }
}

