/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.openapi.actions;

import org.citrusframework.TestAction;
import org.citrusframework.TestActionBuilder;
import org.citrusframework.endpoint.Endpoint;
import org.citrusframework.openapi.OpenApiSpecification;
import org.citrusframework.openapi.actions.OpenApiServerRequestActionBuilder;
import org.citrusframework.openapi.actions.OpenApiServerResponseActionBuilder;
import org.citrusframework.spi.ReferenceResolver;
import org.citrusframework.spi.ReferenceResolverAware;
import org.citrusframework.util.ObjectHelper;
import org.springframework.http.HttpStatus;

public class OpenApiServerActionBuilder
implements TestActionBuilder.DelegatingTestActionBuilder<TestAction>,
ReferenceResolverAware {
    private final OpenApiSpecification specification;
    private ReferenceResolver referenceResolver;
    private Endpoint httpServer;
    private String httpServerUri;
    private TestActionBuilder<?> delegate;

    public OpenApiServerActionBuilder(Endpoint httpServer, OpenApiSpecification specification) {
        this.httpServer = httpServer;
        this.specification = specification;
    }

    public OpenApiServerActionBuilder(String httpServerUri, OpenApiSpecification specification) {
        this.httpServerUri = httpServerUri;
        this.specification = specification;
    }

    public OpenApiServerRequestActionBuilder receive(String operationId) {
        OpenApiServerRequestActionBuilder builder = new OpenApiServerRequestActionBuilder(this.specification, operationId);
        if (this.httpServer != null) {
            builder.endpoint(this.httpServer);
        } else {
            builder.endpoint(this.httpServerUri);
        }
        builder.name("openapi:receive-request");
        builder.withReferenceResolver(this.referenceResolver);
        this.delegate = builder;
        return builder;
    }

    public OpenApiServerResponseActionBuilder send(String operationId) {
        return this.send(operationId, HttpStatus.OK);
    }

    public OpenApiServerResponseActionBuilder send(String operationId, HttpStatus status) {
        return this.send(operationId, String.valueOf(status.value()));
    }

    public OpenApiServerResponseActionBuilder send(String operationId, String statusCode) {
        OpenApiServerResponseActionBuilder builder = new OpenApiServerResponseActionBuilder(this.specification, operationId, statusCode);
        if (this.httpServer != null) {
            builder.endpoint(this.httpServer);
        } else {
            builder.endpoint(this.httpServerUri);
        }
        builder.name("openapi:send-response");
        builder.withReferenceResolver(this.referenceResolver);
        this.delegate = builder;
        return builder;
    }

    public OpenApiServerActionBuilder withReferenceResolver(ReferenceResolver referenceResolver) {
        this.referenceResolver = referenceResolver;
        return this;
    }

    public TestAction build() {
        ObjectHelper.assertNotNull(this.delegate, (String)"Missing delegate action to build");
        return this.delegate.build();
    }

    public TestActionBuilder<?> getDelegate() {
        return this.delegate;
    }

    public void setReferenceResolver(ReferenceResolver referenceResolver) {
        if (referenceResolver == null) {
            this.referenceResolver = referenceResolver;
            if (this.delegate instanceof ReferenceResolverAware) {
                ((ReferenceResolverAware)this.delegate).setReferenceResolver(referenceResolver);
            }
        }
    }
}

