/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.openapi.xml;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlType;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.citrusframework.TestAction;
import org.citrusframework.TestActionBuilder;
import org.citrusframework.actions.ReceiveMessageAction;
import org.citrusframework.actions.SendMessageAction;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.http.actions.HttpClientRequestActionBuilder;
import org.citrusframework.http.actions.HttpServerResponseActionBuilder;
import org.citrusframework.openapi.actions.OpenApiActionBuilder;
import org.citrusframework.openapi.actions.OpenApiClientActionBuilder;
import org.citrusframework.openapi.actions.OpenApiClientRequestActionBuilder;
import org.citrusframework.openapi.actions.OpenApiClientResponseActionBuilder;
import org.citrusframework.openapi.actions.OpenApiServerActionBuilder;
import org.citrusframework.openapi.actions.OpenApiServerRequestActionBuilder;
import org.citrusframework.openapi.actions.OpenApiServerResponseActionBuilder;
import org.citrusframework.spi.ReferenceResolver;
import org.citrusframework.spi.ReferenceResolverAware;
import org.citrusframework.xml.actions.Message;
import org.citrusframework.xml.actions.Receive;
import org.citrusframework.xml.actions.Send;

@XmlRootElement(name="openapi")
public class OpenApi
implements TestActionBuilder<TestAction>,
ReferenceResolverAware {
    private TestActionBuilder<?> builder;
    private Receive receive;
    private Send send;
    private String description;
    private String actor;
    private ReferenceResolver referenceResolver;

    @XmlElement
    public OpenApi setDescription(String value) {
        this.description = value;
        return this;
    }

    @XmlAttribute(name="actor")
    public OpenApi setActor(String actor) {
        this.actor = actor;
        return this;
    }

    @XmlAttribute(name="specification", required=true)
    public OpenApi setSpecification(String specification) {
        this.builder = new OpenApiActionBuilder().specification(specification);
        return this;
    }

    @XmlAttribute(name="client")
    public OpenApi setHttpClient(String httpClient) {
        this.builder = ((OpenApiActionBuilder)this.builder).client(httpClient);
        return this;
    }

    @XmlAttribute(name="server")
    public OpenApi setHttpServer(String httpServer) {
        this.builder = ((OpenApiActionBuilder)this.builder).server(httpServer);
        return this;
    }

    @XmlElement(name="send-request")
    public OpenApi setSendRequest(ClientRequest request) {
        OpenApiClientRequestActionBuilder requestBuilder = this.asClientBuilder().send(request.getOperation());
        requestBuilder.name("openapi:send-request");
        requestBuilder.description(this.description);
        this.send = new Send((SendMessageAction.SendMessageActionBuilder)requestBuilder){

            protected SendMessageAction doBuild() {
                return null;
            }
        };
        if (request.fork != null) {
            this.send.setFork(request.fork);
        }
        if (request.extract != null) {
            this.send.setExtract(request.extract);
        }
        if (request.uri != null) {
            ((HttpClientRequestActionBuilder.HttpMessageBuilderSupport)requestBuilder.message()).header("citrus_endpoint_uri", (Object)request.uri);
        }
        this.builder = requestBuilder;
        return this;
    }

    @XmlElement(name="receive-response")
    public OpenApi setReceiveResponse(ClientResponse response) {
        OpenApiClientResponseActionBuilder responseBuilder = this.asClientBuilder().receive(response.getOperation(), response.getStatus());
        responseBuilder.name("openapi:receive-response");
        responseBuilder.description(this.description);
        this.receive = new Receive((ReceiveMessageAction.ReceiveMessageActionBuilder)responseBuilder){

            protected ReceiveMessageAction doBuild() {
                return null;
            }
        };
        if (response.timeout != null) {
            this.receive.setTimeout(response.timeout);
        }
        this.receive.setSelect(response.select);
        this.receive.setValidator(response.validator);
        this.receive.setValidators(response.validators);
        this.receive.setHeaderValidator(response.headerValidator);
        this.receive.setHeaderValidators(response.headerValidators);
        if (response.selector != null) {
            this.receive.setSelector(response.selector);
        }
        this.receive.setSelect(response.select);
        response.getValidates().forEach(this.receive.getValidates()::add);
        if (response.extract != null) {
            this.receive.setExtract(response.extract);
        }
        this.builder = responseBuilder;
        return this;
    }

    @XmlElement(name="receive-request")
    public OpenApi setReceiveRequest(ServerRequest request) {
        OpenApiServerRequestActionBuilder requestBuilder = this.asServerBuilder().receive(request.getOperation());
        requestBuilder.name("openapi:receive-request");
        requestBuilder.description(this.description);
        this.receive = new Receive((ReceiveMessageAction.ReceiveMessageActionBuilder)requestBuilder){

            protected ReceiveMessageAction doBuild() {
                return null;
            }
        };
        if (request.selector != null) {
            this.receive.setSelector(request.selector);
        }
        this.receive.setSelect(request.select);
        this.receive.setValidator(request.validator);
        this.receive.setValidators(request.validators);
        this.receive.setHeaderValidator(request.headerValidator);
        this.receive.setHeaderValidators(request.headerValidators);
        if (request.timeout != null) {
            this.receive.setTimeout(request.timeout);
        }
        request.getValidates().forEach(this.receive.getValidates()::add);
        if (request.extract != null) {
            this.receive.setExtract(request.extract);
        }
        this.builder = requestBuilder;
        return this;
    }

    @XmlElement(name="send-response")
    public OpenApi setSendResponse(ServerResponse response) {
        OpenApiServerResponseActionBuilder responseBuilder = this.asServerBuilder().send(response.getOperation(), response.getStatus());
        responseBuilder.name("openapi:send-response");
        responseBuilder.description(this.description);
        this.send = new Send((SendMessageAction.SendMessageActionBuilder)responseBuilder){

            protected SendMessageAction doBuild() {
                return null;
            }
        };
        if (response.extract != null) {
            this.send.setExtract(response.extract);
        }
        ((HttpServerResponseActionBuilder.HttpMessageBuilderSupport)responseBuilder.message()).header("citrus_http_status_code", (Object)response.getStatus());
        this.builder = responseBuilder;
        return this;
    }

    public TestAction build() {
        if (this.builder == null) {
            throw new CitrusRuntimeException("Missing client or server Http action - please provide proper action details");
        }
        if (this.send != null) {
            this.send.setReferenceResolver(this.referenceResolver);
            this.send.setActor(this.actor);
            this.send.build();
        }
        if (this.receive != null) {
            this.receive.setReferenceResolver(this.referenceResolver);
            this.receive.setActor(this.actor);
            this.receive.build();
        }
        return this.builder.build();
    }

    public void setReferenceResolver(ReferenceResolver referenceResolver) {
        this.referenceResolver = referenceResolver;
    }

    private OpenApiClientActionBuilder asClientBuilder() {
        TestActionBuilder<?> testActionBuilder = this.builder;
        if (testActionBuilder instanceof OpenApiClientActionBuilder) {
            OpenApiClientActionBuilder clientBuilder = (OpenApiClientActionBuilder)testActionBuilder;
            return clientBuilder;
        }
        throw new CitrusRuntimeException(String.format("Failed to convert '%s' to openapi client action builder", Optional.ofNullable(this.builder).map(Object::getClass).map(Class::getName).orElse("null")));
    }

    private OpenApiServerActionBuilder asServerBuilder() {
        TestActionBuilder<?> testActionBuilder = this.builder;
        if (testActionBuilder instanceof OpenApiServerActionBuilder) {
            OpenApiServerActionBuilder serverBuilder = (OpenApiServerActionBuilder)testActionBuilder;
            return serverBuilder;
        }
        throw new CitrusRuntimeException(String.format("Failed to convert '%s' to openapi server action builder", Optional.ofNullable(this.builder).map(Object::getClass).map(Class::getName).orElse("null")));
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="", propOrder={})
    public static class ClientRequest {
        @XmlAttribute(name="operation", required=true)
        protected String operation;
        @XmlAttribute(name="uri")
        protected String uri;
        @XmlAttribute(name="fork")
        protected Boolean fork;
        @XmlElement
        protected Message.Extract extract;

        public String getOperation() {
            return this.operation;
        }

        public void setOperation(String operation) {
            this.operation = operation;
        }

        public String getUri() {
            return this.uri;
        }

        public void setUri(String uri) {
            this.uri = uri;
        }

        public Boolean getFork() {
            return this.fork;
        }

        public void setFork(Boolean fork) {
            this.fork = fork;
        }

        public Message.Extract getExtract() {
            return this.extract;
        }

        public void setExtract(Message.Extract extract) {
            this.extract = extract;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="", propOrder={})
    public static class ClientResponse {
        @XmlAttribute
        protected Integer timeout;
        @XmlAttribute
        protected String operation;
        @XmlAttribute
        protected String status = "200";
        @XmlAttribute
        protected String select;
        @XmlAttribute
        protected String validator;
        @XmlAttribute
        protected String validators;
        @XmlAttribute(name="header-validator")
        protected String headerValidator;
        @XmlAttribute(name="header-validators")
        protected String headerValidators;
        @XmlElement
        protected Receive.Selector selector;
        @XmlElement(name="validate")
        protected List<Receive.Validate> validates;
        @XmlElement
        protected Message.Extract extract;

        public Integer getTimeout() {
            return this.timeout;
        }

        public void setTimeout(Integer timeout) {
            this.timeout = timeout;
        }

        public String getOperation() {
            return this.operation;
        }

        public void setOperation(String operation) {
            this.operation = operation;
        }

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public String getSelect() {
            return this.select;
        }

        public void setSelect(String select) {
            this.select = select;
        }

        public Receive.Selector getSelector() {
            return this.selector;
        }

        public void setSelector(Receive.Selector selector) {
            this.selector = selector;
        }

        public String getValidator() {
            return this.validator;
        }

        public void setValidator(String validator) {
            this.validator = validator;
        }

        public String getValidators() {
            return this.validators;
        }

        public void setValidators(String validators) {
            this.validators = validators;
        }

        public String getHeaderValidator() {
            return this.headerValidator;
        }

        public void setHeaderValidator(String headerValidator) {
            this.headerValidator = headerValidator;
        }

        public String getHeaderValidators() {
            return this.headerValidators;
        }

        public void setHeaderValidators(String headerValidators) {
            this.headerValidators = headerValidators;
        }

        public List<Receive.Validate> getValidates() {
            if (this.validates == null) {
                this.validates = new ArrayList<Receive.Validate>();
            }
            return this.validates;
        }

        public Message.Extract getExtract() {
            return this.extract;
        }

        public void setExtract(Message.Extract extract) {
            this.extract = extract;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="", propOrder={})
    public static class ServerRequest {
        @XmlAttribute
        protected Integer timeout;
        @XmlAttribute(name="operation", required=true)
        protected String operation;
        @XmlAttribute
        protected String select;
        @XmlAttribute
        protected String validator;
        @XmlAttribute
        protected String validators;
        @XmlAttribute(name="header-validator")
        protected String headerValidator;
        @XmlAttribute(name="header-validators")
        protected String headerValidators;
        @XmlElement
        protected Receive.Selector selector;
        @XmlElement(name="validate")
        protected List<Receive.Validate> validates;
        @XmlElement
        protected Message.Extract extract;

        public Integer getTimeout() {
            return this.timeout;
        }

        public void setTimeout(Integer timeout) {
            this.timeout = timeout;
        }

        public String getOperation() {
            return this.operation;
        }

        public void setOperation(String operation) {
            this.operation = operation;
        }

        public String getSelect() {
            return this.select;
        }

        public void setSelect(String select) {
            this.select = select;
        }

        public String getValidator() {
            return this.validator;
        }

        public void setValidator(String validator) {
            this.validator = validator;
        }

        public String getValidators() {
            return this.validators;
        }

        public void setValidators(String validators) {
            this.validators = validators;
        }

        public String getHeaderValidator() {
            return this.headerValidator;
        }

        public void setHeaderValidator(String headerValidator) {
            this.headerValidator = headerValidator;
        }

        public String getHeaderValidators() {
            return this.headerValidators;
        }

        public void setHeaderValidators(String headerValidators) {
            this.headerValidators = headerValidators;
        }

        public List<Receive.Validate> getValidates() {
            if (this.validates == null) {
                this.validates = new ArrayList<Receive.Validate>();
            }
            return this.validates;
        }

        public void setValidates(List<Receive.Validate> validates) {
            this.validates = validates;
        }

        public Message.Extract getExtract() {
            return this.extract;
        }

        public void setExtract(Message.Extract extract) {
            this.extract = extract;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    @XmlType(name="", propOrder={})
    public static class ServerResponse {
        @XmlAttribute(name="operation", required=true)
        protected String operation;
        @XmlAttribute
        protected String status = "200";
        @XmlElement
        protected Message.Extract extract;

        public String getOperation() {
            return this.operation;
        }

        public void setOperation(String operation) {
            this.operation = operation;
        }

        public String getStatus() {
            return this.status;
        }

        public void setStatus(String status) {
            this.status = status;
        }

        public Message.Extract getExtract() {
            return this.extract;
        }

        public void setExtract(Message.Extract extract) {
            this.extract = extract;
        }
    }
}

