/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.quarkus;

import io.quarkus.test.common.QuarkusTestResourceLifecycleManager;
import java.util.Collections;
import java.util.Map;
import java.util.function.Predicate;
import org.citrusframework.Citrus;
import org.citrusframework.CitrusInstanceManager;
import org.citrusframework.GherkinTestActionRunner;
import org.citrusframework.TestActionRunner;
import org.citrusframework.TestCaseRunner;
import org.citrusframework.TestCaseRunnerFactory;
import org.citrusframework.annotations.CitrusAnnotations;
import org.citrusframework.annotations.CitrusFramework;
import org.citrusframework.annotations.CitrusResource;
import org.citrusframework.context.TestContext;

public class CitrusTestResource
implements QuarkusTestResourceLifecycleManager {
    private Citrus citrus;
    private TestCaseRunner runner;
    private TestContext context;

    public Map<String, String> start() {
        if (this.citrus == null) {
            this.citrus = CitrusInstanceManager.newInstance();
            this.citrus.beforeSuite("citrus-quarkus", new String[0]);
        }
        return Collections.emptyMap();
    }

    public void stop() {
        if (this.runner != null) {
            this.runner.stop();
        }
        this.citrus.afterSuite("citrus-quarkus", new String[0]);
        this.runner = null;
        this.context = null;
    }

    public void inject(Object testInstance) {
        if (this.runner != null) {
            this.runner.stop();
        }
        this.context = this.citrus.getCitrusContext().createTestContext();
        this.runner = TestCaseRunnerFactory.createRunner((TestContext)this.context);
        this.runner.testClass(testInstance.getClass());
        this.runner.packageName(testInstance.getClass().getPackageName());
        this.runner.name(testInstance.getClass().getSimpleName());
        this.runner.start();
        this.citrus.getCitrusContext().parseConfiguration(testInstance);
        CitrusAnnotations.injectEndpoints((Object)testInstance, (TestContext)this.context);
    }

    public void inject(QuarkusTestResourceLifecycleManager.TestInjector testInjector) {
        testInjector.injectIntoFields((Object)this.citrus, (Predicate)new QuarkusTestResourceLifecycleManager.TestInjector.AnnotatedAndMatchesType(CitrusFramework.class, Citrus.class));
        testInjector.injectIntoFields((Object)this.runner, (Predicate)new QuarkusTestResourceLifecycleManager.TestInjector.AnnotatedAndMatchesType(CitrusResource.class, TestActionRunner.class));
        testInjector.injectIntoFields((Object)this.runner, (Predicate)new QuarkusTestResourceLifecycleManager.TestInjector.AnnotatedAndMatchesType(CitrusResource.class, GherkinTestActionRunner.class));
        testInjector.injectIntoFields((Object)this.runner, (Predicate)new QuarkusTestResourceLifecycleManager.TestInjector.AnnotatedAndMatchesType(CitrusResource.class, TestCaseRunner.class));
        testInjector.injectIntoFields((Object)this.context, (Predicate)new QuarkusTestResourceLifecycleManager.TestInjector.AnnotatedAndMatchesType(CitrusResource.class, TestContext.class));
    }
}

