/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.json;

import com.jayway.jsonpath.DocumentContext;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import com.jayway.jsonpath.ReadContext;
import java.util.Optional;
import net.minidev.json.JSONArray;
import net.minidev.json.JSONObject;
import net.minidev.json.parser.JSONParser;
import net.minidev.json.parser.ParseException;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.util.StringUtils;
import org.citrusframework.validation.json.JsonPathFunctions;

public class JsonPathUtils {
    public static Object evaluate(String payload, String jsonPathExpression) {
        try {
            JSONParser parser = new JSONParser(4032);
            Object receivedJson = parser.parse(payload);
            DocumentContext readerContext = JsonPath.parse((Object)receivedJson);
            return JsonPathUtils.evaluate((ReadContext)readerContext, jsonPathExpression);
        }
        catch (ParseException e) {
            throw new CitrusRuntimeException("Failed to parse JSON text", (Throwable)e);
        }
    }

    public static Object evaluate(ReadContext readerContext, String jsonPathExpression) {
        String expression = jsonPathExpression;
        String jsonPathFunction = null;
        for (String name : JsonPathFunctions.getSupportedFunctions()) {
            if (!expression.endsWith(String.format(".%s()", name))) continue;
            jsonPathFunction = name;
            expression = expression.substring(0, expression.length() - String.format(".%s()", name).length());
        }
        Object jsonPathResult = null;
        PathNotFoundException pathNotFoundException = null;
        try {
            JSONArray values;
            jsonPathResult = JsonPath.isPathDefinite((String)expression) ? readerContext.read(expression, new Predicate[0]) : ((values = (JSONArray)readerContext.read(expression, new Predicate[0])).size() == 1 ? values.get(0) : values);
        }
        catch (PathNotFoundException e) {
            pathNotFoundException = e;
        }
        if (StringUtils.hasText(jsonPathFunction)) {
            jsonPathResult = JsonPathFunctions.evaluate(jsonPathResult, jsonPathFunction);
        }
        if (jsonPathResult == null && pathNotFoundException != null) {
            throw new CitrusRuntimeException(String.format("Failed to evaluate JSON path expression: %s", jsonPathExpression), (Throwable)pathNotFoundException);
        }
        return jsonPathResult;
    }

    public static String evaluateAsString(String payload, String jsonPathExpression) {
        try {
            JSONParser parser = new JSONParser(4032);
            Object receivedJson = parser.parse(payload);
            DocumentContext readerContext = JsonPath.parse((Object)receivedJson);
            return JsonPathUtils.evaluateAsString((ReadContext)readerContext, jsonPathExpression);
        }
        catch (ParseException e) {
            throw new CitrusRuntimeException("Failed to parse JSON text", (Throwable)e);
        }
    }

    public static String evaluateAsString(ReadContext readerContext, String jsonPathExpression) {
        Object jsonPathResult = JsonPathUtils.evaluate(readerContext, jsonPathExpression);
        if (jsonPathResult instanceof JSONArray) {
            return ((JSONArray)jsonPathResult).toJSONString();
        }
        if (jsonPathResult instanceof JSONObject) {
            return ((JSONObject)jsonPathResult).toJSONString();
        }
        return Optional.ofNullable(jsonPathResult).map(Object::toString).orElse("null");
    }
}

