/*
 * Decompiled with CFR 0.152.
 */
package org.citrusframework.json;

import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.citrusframework.common.InitializingPhase;
import org.citrusframework.common.Named;
import org.citrusframework.exceptions.CitrusRuntimeException;
import org.citrusframework.json.schema.SimpleJsonSchema;
import org.citrusframework.spi.ClasspathResourceResolver;
import org.citrusframework.spi.Resource;
import org.citrusframework.spi.Resources;
import org.citrusframework.util.FileUtils;
import org.citrusframework.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonSchemaRepository
implements Named,
InitializingPhase {
    private String name;
    private List<SimpleJsonSchema> schemas = new ArrayList<SimpleJsonSchema>();
    private List<String> locations = new ArrayList<String>();
    private static Logger logger = LoggerFactory.getLogger(JsonSchemaRepository.class);

    public void setName(String name) {
        this.name = name;
    }

    public void initialize() {
        try {
            ClasspathResourceResolver resourceResolver = new ClasspathResourceResolver();
            for (String location : this.locations) {
                Set findings;
                Resource found = Resources.create((String)location);
                if (found.exists()) {
                    this.addSchemas(found);
                    continue;
                }
                if (StringUtils.hasText((String)FileUtils.getFileExtension((String)location))) {
                    String fileNamePattern = FileUtils.getFileName((String)location).replace(".", "\\.").replace("*", ".*");
                    String basePath = FileUtils.getBasePath((String)location);
                    findings = resourceResolver.getResources(basePath, fileNamePattern);
                } else {
                    findings = resourceResolver.getResources(location);
                }
                for (Path resource : findings) {
                    this.addSchemas(Resources.fromClasspath((String)resource.toString()));
                }
            }
        }
        catch (IOException e) {
            throw new CitrusRuntimeException("Failed to initialize Json schema repository", (Throwable)e);
        }
    }

    private void addSchemas(Resource resource) {
        if (resource.getLocation().endsWith(".json")) {
            if (logger.isDebugEnabled()) {
                logger.debug("Loading json schema resource " + resource.getLocation());
            }
            SimpleJsonSchema simpleJsonSchema = new SimpleJsonSchema(resource);
            simpleJsonSchema.initialize();
            this.schemas.add(simpleJsonSchema);
        } else {
            logger.warn("Skipped resource other than json schema for repository (" + resource.getLocation() + ")");
        }
    }

    public String getName() {
        return this.name;
    }

    public List<SimpleJsonSchema> getSchemas() {
        return this.schemas;
    }

    public void setSchemas(List<SimpleJsonSchema> schemas) {
        this.schemas = schemas;
    }

    public static Logger getLog() {
        return logger;
    }

    public static void setLog(Logger logger) {
        JsonSchemaRepository.logger = logger;
    }

    public List<String> getLocations() {
        return this.locations;
    }

    public void setLocations(List<String> locations) {
        this.locations = locations;
    }
}

