/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.ml.chunking;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.fit.util.JCasUtil;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.cleartk.ml.chunking.Chunking_ImplBase;

public class BioChunking<SUB_CHUNK_TYPE extends Annotation, CHUNK_TYPE extends Annotation>
extends Chunking_ImplBase<SUB_CHUNK_TYPE, CHUNK_TYPE> {
    public BioChunking(Class<? extends SUB_CHUNK_TYPE> subChunkClass, Class<? extends CHUNK_TYPE> chunkClass) {
        super(subChunkClass, chunkClass, null);
    }

    public BioChunking(Class<? extends SUB_CHUNK_TYPE> subChunkClass, Class<? extends CHUNK_TYPE> chunkClass, String featureName) {
        super(subChunkClass, chunkClass, featureName);
    }

    @Override
    protected Map<SUB_CHUNK_TYPE, String> getSubChunkToOutcomeMap(JCas jCas, List<SUB_CHUNK_TYPE> chunkComponents, List<CHUNK_TYPE> chunks) {
        Feature feature = this.getFeature(jCas);
        HashMap<Annotation, String> subChunkToOutcome = new HashMap<Annotation, String>();
        for (Annotation chunk : chunks) {
            String suffix = this.getOutcomeSuffix(chunk, feature);
            boolean isBegin = true;
            for (Annotation chunkComponent : JCasUtil.selectCovered((Class)this.subChunkClass, (AnnotationFS)chunk)) {
                if (isBegin) {
                    subChunkToOutcome.put(chunkComponent, "B" + suffix);
                    isBegin = false;
                    continue;
                }
                subChunkToOutcome.put(chunkComponent, "I" + suffix);
            }
        }
        return subChunkToOutcome;
    }

    @Override
    protected boolean isEndOfChunk(char currPrefix, String currLabel, char nextPrefix, String nextLabel) {
        return nextPrefix == 'O' || nextPrefix == 'B' || !nextLabel.equals(currLabel);
    }
}

