/*
 * Decompiled with CFR 0.152.
 */
package org.cleartk.ml.encoder.features;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.cleartk.ml.Feature;
import org.cleartk.ml.encoder.CleartkEncoderException;
import org.cleartk.ml.encoder.features.FeatureEncoder;
import org.cleartk.ml.encoder.features.NameNumber;
import org.cleartk.ml.encoder.features.normalizer.NameNumberNormalizer;
import org.cleartk.ml.encoder.features.normalizer.NoOpNormalizer;
import org.cleartk.ml.feature.FeatureCollection;

public class FeatureCollectionEncoder
implements FeatureEncoder<NameNumber> {
    private static final long serialVersionUID = -7840242678514710238L;
    private String identifier;
    private NameNumberNormalizer normalizer = new NoOpNormalizer();
    private FeatureEncoder<NameNumber> subEncoder = null;

    public FeatureCollectionEncoder(String identifier, FeatureEncoder<NameNumber> subEncoder, NameNumberNormalizer normalizer) {
        this.identifier = identifier;
        this.normalizer = normalizer;
        this.subEncoder = subEncoder;
    }

    public FeatureCollectionEncoder(FeatureEncoder<NameNumber> subEncoder, NameNumberNormalizer normalizer) {
        this(null, subEncoder, normalizer);
    }

    public FeatureCollectionEncoder(String name, FeatureEncoder<NameNumber> subEncoder) {
        this(name, subEncoder, new NoOpNormalizer());
    }

    public FeatureCollectionEncoder(FeatureEncoder<NameNumber> subEncoder) {
        this(null, subEncoder, new NoOpNormalizer());
    }

    @Override
    public List<NameNumber> encode(Feature feature) throws CleartkEncoderException {
        FeatureCollection fc = (FeatureCollection)feature.getValue();
        ArrayList<NameNumber> fves = new ArrayList<NameNumber>();
        if (this.identifier != null && !this.identifier.equals(fc.getIdentifier())) {
            return Collections.emptyList();
        }
        for (Feature f : fc.getFeatures()) {
            Feature f1 = new Feature(Feature.createName(feature.getName(), f.getName()), f.getValue());
            fves.addAll(this.subEncoder.encode(f1));
        }
        this.normalizer.normalize(fves);
        return fves;
    }

    @Override
    public boolean encodes(Feature feature) {
        if (feature.getValue() instanceof FeatureCollection) {
            FeatureCollection f = (FeatureCollection)feature.getValue();
            return this.identifier == null || this.identifier.equals(f.getIdentifier());
        }
        return false;
    }
}

