/*
 * Decompiled with CFR 0.152.
 */
package jcifs.internal.smb1.net;

import jcifs.Configuration;
import jcifs.internal.smb1.net.SmbShareInfo;
import jcifs.internal.smb1.trans.SmbComTransactionResponse;
import jcifs.internal.util.SMBUtil;
import jcifs.smb.FileEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetShareEnumResponse
extends SmbComTransactionResponse {
    private static final Logger log = LoggerFactory.getLogger(NetShareEnumResponse.class);
    private int converter;
    private int totalAvailableEntries;

    public NetShareEnumResponse(Configuration config) {
        super(config);
    }

    @Override
    protected int writeSetupWireFormat(byte[] dst, int dstIndex) {
        return 0;
    }

    @Override
    protected int writeParametersWireFormat(byte[] dst, int dstIndex) {
        return 0;
    }

    @Override
    protected int writeDataWireFormat(byte[] dst, int dstIndex) {
        return 0;
    }

    @Override
    protected int readSetupWireFormat(byte[] buffer, int bufferIndex, int len) {
        return 0;
    }

    @Override
    protected int readParametersWireFormat(byte[] buffer, int bufferIndex, int len) {
        int start = bufferIndex;
        this.setStatus(SMBUtil.readInt2(buffer, bufferIndex));
        this.converter = SMBUtil.readInt2(buffer, bufferIndex += 2);
        this.setNumEntries(SMBUtil.readInt2(buffer, bufferIndex += 2));
        this.totalAvailableEntries = SMBUtil.readInt2(buffer, bufferIndex += 2);
        return (bufferIndex += 2) - start;
    }

    @Override
    protected int readDataWireFormat(byte[] buffer, int bufferIndex, int len) {
        int start = bufferIndex;
        this.setUseUnicode(false);
        FileEntry[] results = new SmbShareInfo[this.getNumEntries()];
        for (int i = 0; i < this.getNumEntries(); ++i) {
            SmbShareInfo e = new SmbShareInfo();
            results[i] = e;
            e.netName = this.readString(buffer, bufferIndex, 13, false);
            e.type = SMBUtil.readInt2(buffer, bufferIndex += 14);
            int off = SMBUtil.readInt4(buffer, bufferIndex += 2);
            bufferIndex += 4;
            off = (off & 0xFFFF) - this.converter;
            off = start + off;
            e.remark = this.readString(buffer, off, 128, false);
            if (!log.isTraceEnabled()) continue;
            log.trace(e.toString());
        }
        this.setResults(results);
        return bufferIndex - start;
    }

    @Override
    public String toString() {
        return new String("NetShareEnumResponse[" + super.toString() + ",status=" + this.getStatus() + ",converter=" + this.converter + ",entriesReturned=" + this.getNumEntries() + ",totalAvailableEntries=" + this.totalAvailableEntries + "]");
    }
}

