/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server;

import java.io.IOException;
import java.text.ParseException;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.cometd.bayeux.Promise;
import org.cometd.bayeux.server.ServerMessage;
import org.cometd.bayeux.server.ServerTransport;
import org.cometd.common.AbstractTransport;
import org.cometd.server.BayeuxServerImpl;
import org.cometd.server.JSONContextServer;
import org.cometd.server.ServerMessageImpl;
import org.cometd.server.ServerSessionImpl;
import org.eclipse.jetty.util.component.Dumpable;

public abstract class AbstractServerTransport
extends AbstractTransport
implements ServerTransport,
Dumpable {
    public static final String TIMEOUT_OPTION = "timeout";
    public static final String INTERVAL_OPTION = "interval";
    public static final String MAX_INTERVAL_OPTION = "maxInterval";
    public static final String MAX_PROCESSING_OPTION = "maxProcessing";
    public static final String MAX_LAZY_TIMEOUT_OPTION = "maxLazyTimeout";
    public static final String META_CONNECT_DELIVERY_OPTION = "metaConnectDeliverOnly";
    public static final String MAX_QUEUE_OPTION = "maxQueue";
    public static final String JSON_CONTEXT_OPTION = "jsonContext";
    public static final String HANDSHAKE_RECONNECT_OPTION = "handshakeReconnect";
    public static final String ALLOW_MESSAGE_DELIVERY_DURING_HANDSHAKE = "allowMessageDeliveryDuringHandshake";
    public static final String MAX_MESSAGE_SIZE_OPTION = "maxMessageSize";
    private static final AtomicLong META_CONNECT_CYCLES = new AtomicLong();
    private final BayeuxServerImpl _bayeux;
    private long _interval = 0L;
    private long _maxInterval = 10000L;
    private long _timeout = 20000L;
    private long _maxLazyTimeout = 5000L;
    private boolean _metaConnectDeliveryOnly = false;
    private JSONContextServer _jsonContext;
    private boolean _handshakeReconnect;
    private boolean _allowHandshakeDelivery;
    private int _maxMessageSize;

    protected AbstractServerTransport(BayeuxServerImpl bayeux, String name) {
        super(name, bayeux.getOptions());
        this._bayeux = bayeux;
    }

    public long newMetaConnectCycle() {
        return META_CONNECT_CYCLES.incrementAndGet();
    }

    public long getInterval() {
        return this._interval;
    }

    public long getMaxInterval() {
        return this._maxInterval;
    }

    public long getMaxLazyTimeout() {
        return this._maxLazyTimeout;
    }

    public long getTimeout() {
        return this._timeout;
    }

    public boolean isMetaConnectDeliveryOnly() {
        return this._metaConnectDeliveryOnly;
    }

    public void setMetaConnectDeliveryOnly(boolean meta) {
        this._metaConnectDeliveryOnly = meta;
    }

    public boolean isHandshakeReconnect() {
        return this._handshakeReconnect;
    }

    public void setHandshakeReconnect(boolean handshakeReconnect) {
        this._handshakeReconnect = handshakeReconnect;
    }

    public boolean isAllowMessageDeliveryDuringHandshake() {
        return this._allowHandshakeDelivery;
    }

    public void setAllowMessageDeliveryDuringHandshake(boolean allow) {
        this._allowHandshakeDelivery = allow;
    }

    public int getMaxMessageSize() {
        return this._maxMessageSize;
    }

    public void setMaxMessageSize(int maxMessageSize) {
        this._maxMessageSize = maxMessageSize;
    }

    public void init() {
        this._interval = this.getOption(INTERVAL_OPTION, this._interval);
        this._maxInterval = this.getOption(MAX_INTERVAL_OPTION, this._maxInterval);
        this._timeout = this.getOption(TIMEOUT_OPTION, this._timeout);
        this._maxLazyTimeout = this.getOption(MAX_LAZY_TIMEOUT_OPTION, this._maxLazyTimeout);
        this._metaConnectDeliveryOnly = this.getOption(META_CONNECT_DELIVERY_OPTION, this._metaConnectDeliveryOnly);
        this._jsonContext = (JSONContextServer)this.getOption(JSON_CONTEXT_OPTION);
        this._handshakeReconnect = this.getOption(HANDSHAKE_RECONNECT_OPTION, false);
        this._allowHandshakeDelivery = this.getOption(ALLOW_MESSAGE_DELIVERY_DURING_HANDSHAKE, false);
        this._maxMessageSize = this.getOption(MAX_MESSAGE_SIZE_OPTION, -1);
    }

    public void destroy() {
    }

    protected JSONContextServer getJSONContextServer() {
        return this._jsonContext;
    }

    public List<ServerMessage.Mutable> parseMessages(String json) throws ParseException {
        return this._jsonContext.parse(json);
    }

    public BayeuxServerImpl getBayeuxServer() {
        return this._bayeux;
    }

    public void setInterval(long interval) {
        this._interval = interval;
    }

    public void setMaxInterval(long maxInterval) {
        this._maxInterval = maxInterval;
    }

    public void setTimeout(long timeout) {
        this._timeout = timeout;
    }

    public void setMaxLazyTimeout(long maxLazyTimeout) {
        this._maxLazyTimeout = maxLazyTimeout;
    }

    protected void sweep() {
    }

    public void processReply(ServerSessionImpl session, ServerMessage.Mutable reply, Promise<ServerMessage.Mutable> promise) {
        this.getBayeuxServer().extendReply(session, session, reply, promise);
    }

    protected String toJSON(ServerMessage msg) {
        return this.toJSON((ServerMessageImpl)((Object)(msg instanceof ServerMessageImpl ? msg : this._bayeux.newMessage(msg))));
    }

    private String toJSON(ServerMessageImpl message) {
        String json = message.getJSON();
        if (json == null) {
            json = this._jsonContext.generate(message);
        }
        return json;
    }

    public boolean allowMessageDeliveryDuringHandshake(ServerSessionImpl session) {
        return session != null && session.isAllowMessageDeliveryDuringHandshake();
    }

    public void scheduleExpiration(ServerSessionImpl session, long metaConnectCycle) {
        if (session != null) {
            session.scheduleExpiration(this.getInterval(), this.getMaxInterval(), metaConnectCycle);
        }
    }

    public void dump(Appendable out, String indent) throws IOException {
        Dumpable.dumpObject((Appendable)out, (Object)((Object)this));
    }

    public String toString() {
        return String.format("%s@%x[%s]", ((Object)((Object)this)).getClass().getSimpleName(), ((Object)((Object)this)).hashCode(), this.getName());
    }

    public static interface Scheduler {
        default public long getMetaConnectCycle() {
            return 0L;
        }

        default public void schedule() {
        }

        default public void cancel() {
        }

        default public void destroy() {
        }

        public static class None
        implements Scheduler {
            private final long metaConnectCycle;

            public None(long metaConnectCycle) {
                this.metaConnectCycle = metaConnectCycle;
            }

            @Override
            public long getMetaConnectCycle() {
                return this.metaConnectCycle;
            }

            public String toString() {
                return String.format("%s@%x[cycle=%d]", this.getClass().getSimpleName(), this.hashCode(), this.getMetaConnectCycle());
            }
        }
    }
}

