/*
 * Decompiled with CFR 0.152.
 */
package org.cometd.server.http.jakarta;

import jakarta.servlet.ServletContext;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.Principal;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.cometd.bayeux.server.BayeuxContext;

class JakartaBayeuxContext
implements BayeuxContext {
    private final HttpServletRequest request;

    JakartaBayeuxContext(HttpServletRequest request) {
        this.request = request;
    }

    public Principal getUserPrincipal() {
        return this.request.getUserPrincipal();
    }

    public boolean isUserInRole(String role) {
        return this.request.isUserInRole(role);
    }

    public SocketAddress getRemoteAddress() {
        return new InetSocketAddress(this.request.getRemoteHost(), this.request.getRemotePort());
    }

    public SocketAddress getLocalAddress() {
        return new InetSocketAddress(this.request.getLocalName(), this.request.getLocalPort());
    }

    public String getHeader(String name) {
        return this.request.getHeader(name);
    }

    public List<String> getHeaderValues(String name) {
        return Collections.list(this.request.getHeaders(name));
    }

    public String getParameter(String name) {
        return this.request.getParameter(name);
    }

    public List<String> getParameterValues(String name) {
        return List.of(this.request.getParameterValues(name));
    }

    public String getCookie(String name) {
        Cookie[] cookies = this.request.getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!cookie.getName().equals(name)) continue;
                return cookie.getValue();
            }
        }
        return null;
    }

    public Object getContextAttribute(String name) {
        return this.getServletContext().getAttribute(name);
    }

    public Object getRequestAttribute(String name) {
        return this.request.getAttribute(name);
    }

    public Object getSessionAttribute(String name) {
        HttpSession session = this.request.getSession(false);
        return session != null ? session.getAttribute(name) : null;
    }

    private ServletContext getServletContext() {
        return this.request.getServletContext();
    }

    public String getContextPath() {
        return this.request.getContextPath();
    }

    public String getURL() {
        StringBuffer url = this.request.getRequestURL();
        String query = this.request.getQueryString();
        if (query != null) {
            url.append("?").append(query);
        }
        return url.toString();
    }

    public List<Locale> getLocales() {
        return Collections.list(this.request.getLocales());
    }

    public String getProtocol() {
        return this.request.getProtocol();
    }

    public boolean isSecure() {
        return this.request.isSecure();
    }
}

