/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.cli.impl.descriptor;

import java.lang.reflect.Type;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import org.crsh.cli.descriptor.CommandDescriptor;
import org.crsh.cli.descriptor.Description;
import org.crsh.cli.descriptor.OptionDescriptor;
import org.crsh.cli.descriptor.ParameterDescriptor;
import org.crsh.cli.impl.ParameterType;
import org.crsh.cli.impl.SyntaxException;
import org.crsh.cli.impl.descriptor.Help;
import org.crsh.cli.impl.descriptor.IntrospectionException;
import org.crsh.cli.impl.invocation.CommandInvoker;
import org.crsh.cli.impl.invocation.InvocationException;
import org.crsh.cli.impl.invocation.InvocationMatch;
import org.crsh.cli.impl.invocation.ParameterMatch;
import org.crsh.cli.type.ValueTypeFactory;

public class HelpDescriptor<T>
extends CommandDescriptor<T> {
    static final OptionDescriptor HELP_OPTION;
    private final HelpDescriptor<T> owner;
    private final CommandDescriptor<T> delegate;
    private final LinkedHashMap<String, HelpDescriptor<T>> subordinates;

    public static <T> HelpDescriptor<T> create(CommandDescriptor<T> descriptor) throws IntrospectionException {
        return new HelpDescriptor<T>(descriptor);
    }

    public HelpDescriptor(CommandDescriptor<T> delegate) throws IntrospectionException {
        this(null, delegate);
    }

    private HelpDescriptor(HelpDescriptor<T> owner, CommandDescriptor<T> delegate) throws IntrospectionException {
        super(delegate.getName(), delegate.getDescription());
        boolean add;
        for (ParameterDescriptor parameter : delegate.getParameters()) {
            this.addParameter(parameter);
        }
        if (owner == null) {
            add = !this.getOptionNames().contains("-h") && !this.getOptionNames().contains("--help");
            for (CommandDescriptor<T> sub : delegate.getSubordinates().values()) {
                if (!sub.getOptionNames().contains("-h") && !this.getOptionNames().contains("--help")) continue;
                add = false;
            }
        } else {
            add = false;
        }
        if (add) {
            this.addParameter(HELP_OPTION);
        }
        LinkedHashMap<String, HelpDescriptor<T>> subordinates = new LinkedHashMap<String, HelpDescriptor<T>>();
        for (CommandDescriptor<T> subordinate : delegate.getSubordinates().values()) {
            subordinates.put(subordinate.getName(), new HelpDescriptor<T>(this, subordinate));
        }
        this.owner = owner;
        this.delegate = delegate;
        this.subordinates = subordinates;
    }

    public CommandDescriptor<T> getDelegate() {
        return this.delegate;
    }

    @Override
    public CommandInvoker<T, ?> getInvoker(InvocationMatch<T> match) {
        boolean help;
        CommandInvoker<T, ?> invoker = this.delegate.getInvoker(match);
        ParameterMatch<OptionDescriptor> helpDesc = null;
        for (InvocationMatch<T> current = match; current != null && helpDesc == null; current = current.owner()) {
            helpDesc = current.getParameter(HELP_OPTION);
        }
        boolean bl = help = helpDesc != null || invoker == null;
        if (help) {
            return new CommandInvoker<T, Help>(match){

                @Override
                public Class<Help> getReturnType() {
                    return Help.class;
                }

                @Override
                public Type getGenericReturnType() {
                    return Help.class;
                }

                @Override
                public Help invoke(T command) throws InvocationException, SyntaxException {
                    return new Help(HelpDescriptor.this);
                }
            };
        }
        return invoker;
    }

    @Override
    public CommandDescriptor<T> getOwner() {
        return this.owner;
    }

    @Override
    public Map<String, ? extends HelpDescriptor<T>> getSubordinates() {
        return this.subordinates;
    }

    static {
        try {
            HELP_OPTION = new OptionDescriptor(ParameterType.create(ValueTypeFactory.DEFAULT, Boolean.class), Arrays.asList("h", "help"), new Description("this help", "Display this help message"), false, false, false, null, null);
        }
        catch (IntrospectionException e) {
            throw new UndeclaredThrowableException(e);
        }
    }
}

