/*
 * Decompiled with CFR 0.152.
 */
package org.crsh.telnet.term;

import java.util.Iterator;
import org.crsh.plugin.PluginContext;
import org.crsh.telnet.term.spi.TermIOHandler;

public abstract class TermLifeCycle {
    private final PluginContext context;

    protected TermLifeCycle(PluginContext context) {
        if (context == null) {
            throw new NullPointerException();
        }
        this.context = context;
    }

    public final void init() {
        try {
            this.doInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public final void destroy() {
        this.doDestroy();
    }

    public final TermIOHandler getHandler() {
        Iterator handlers = this.context.getPlugins(TermIOHandler.class).iterator();
        if (handlers.hasNext()) {
            return (TermIOHandler)handlers.next();
        }
        return null;
    }

    public final PluginContext getContext() {
        return this.context;
    }

    protected abstract void doInit() throws Exception;

    protected abstract void doDestroy();
}

