/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.maven;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.dependency.analyzer.ProjectDependencyAnalysis;
import org.cyclonedx.maven.CycloneDxMojo;
import org.cyclonedx.model.Component;
import org.cyclonedx.model.Dependency;

@Mojo(name="makeAggregateBom", defaultPhase=LifecyclePhase.PACKAGE, threadSafe=true, aggregator=true, requiresOnline=true, requiresDependencyCollection=ResolutionScope.TEST, requiresDependencyResolution=ResolutionScope.TEST)
public class CycloneDxAggregateMojo
extends CycloneDxMojo {
    @Parameter(property="reactorProjects", readonly=true, required=true)
    private List<MavenProject> reactorProjects;
    @Parameter(property="outputReactorProjects", defaultValue="true", required=false)
    private Boolean outputReactorProjects;
    @Parameter(property="excludeArtifactId", required=false)
    protected String[] excludeArtifactId;
    @Parameter(property="excludeGroupId", required=false)
    protected String[] excludeGroupId;
    @Parameter(property="excludeTestProject", defaultValue="false", required=false)
    protected Boolean excludeTestProject;

    protected boolean shouldExclude(MavenProject mavenProject) {
        boolean shouldExclude = false;
        if (this.excludeArtifactId != null && this.excludeArtifactId.length > 0) {
            shouldExclude = Arrays.asList(this.excludeArtifactId).contains(mavenProject.getArtifactId());
        }
        if (!shouldExclude && this.excludeGroupId != null && this.excludeGroupId.length > 0) {
            shouldExclude = Arrays.asList(this.excludeGroupId).contains(mavenProject.getGroupId());
        }
        if (this.excludeTestProject.booleanValue() && mavenProject.getArtifactId().contains("test")) {
            shouldExclude = true;
        }
        return shouldExclude;
    }

    @Override
    protected void logAdditionalParameters() {
        this.getLog().info((CharSequence)("outputReactorProjects  : " + this.outputReactorProjects));
    }

    @Override
    protected String extractComponentsAndDependencies(Set<Component> components, Set<Dependency> dependencies) throws MojoExecutionException {
        if (!this.getProject().isExecutionRoot()) {
            if (this.outputReactorProjects.booleanValue()) {
                return super.extractComponentsAndDependencies(components, dependencies);
            }
            this.getLog().info((CharSequence)"Skipping CycloneDX on non-execution root");
            return null;
        }
        this.getLog().info((CharSequence)(this.reactorProjects.size() <= 1 ? "CycloneDX: Resolving Dependencies" : "CycloneDX: Resolving Aggregated Dependencies"));
        LinkedHashSet<String> componentRefs = new LinkedHashSet<String>();
        List<ProjectDependencyAnalysis> projectsDependencyAnalysis = this.prepareMavenDependencyAnalysis();
        Component bomComponent = this.convert(this.getProject().getArtifact());
        componentRefs.add(bomComponent.getBomRef());
        for (MavenProject mavenProject : this.reactorProjects) {
            if (this.shouldExclude(mavenProject)) {
                this.getLog().info((CharSequence)("Excluding " + mavenProject.getArtifactId()));
                continue;
            }
            Component projectBomComponent = this.convert(mavenProject.getArtifact());
            if (!mavenProject.isExecutionRoot() && !componentRefs.contains(projectBomComponent.getBomRef())) {
                components.add(projectBomComponent);
            }
            componentRefs.add(projectBomComponent.getBomRef());
            for (Artifact artifact : mavenProject.getArtifacts()) {
                Component component = this.convert(artifact);
                if (!componentRefs.add(component.getBomRef())) continue;
                component.setScope(this.inferComponentScope(artifact, projectsDependencyAnalysis));
                components.add(component);
            }
            dependencies.addAll(this.extractBOMDependencies(mavenProject));
        }
        this.addMavenProjectsAsParentDependencies(this.reactorProjects, dependencies);
        return "makeAggregateBom";
    }

    private void addMavenProjectsAsParentDependencies(List<MavenProject> reactorProjects, Set<Dependency> dependencies) {
        HashMap dependenciesByRef = new HashMap();
        dependencies.forEach(d -> dependenciesByRef.put(d.getRef(), d));
        for (MavenProject project : reactorProjects) {
            String parentRef;
            Dependency parentDependency;
            if (!project.hasParent() || (parentDependency = (Dependency)dependenciesByRef.get(parentRef = this.generatePackageUrl(project.getParentArtifact()))) == null) continue;
            Dependency child = new Dependency(this.generatePackageUrl(project.getArtifact()));
            parentDependency.addDependency(child);
        }
    }

    private List<ProjectDependencyAnalysis> prepareMavenDependencyAnalysis() throws MojoExecutionException {
        ArrayList<ProjectDependencyAnalysis> dependencyAnalysisMap = new ArrayList<ProjectDependencyAnalysis>();
        for (MavenProject mavenProject : this.reactorProjects) {
            ProjectDependencyAnalysis dependencyAnalysis;
            if (this.shouldExclude(mavenProject) || (dependencyAnalysis = this.doProjectDependencyAnalysis(mavenProject)) == null) continue;
            dependencyAnalysisMap.add(dependencyAnalysis);
        }
        return dependencyAnalysisMap;
    }

    private Component.Scope inferComponentScope(Artifact artifact, List<ProjectDependencyAnalysis> projectsDependencyAnalysis) {
        Component.Scope componentScope = null;
        for (ProjectDependencyAnalysis dependencyAnalysis : projectsDependencyAnalysis) {
            Component.Scope currentProjectScope = this.inferComponentScope(artifact, dependencyAnalysis);
            if (Component.Scope.REQUIRED.equals((Object)currentProjectScope)) {
                return Component.Scope.REQUIRED;
            }
            if (componentScope != null || currentProjectScope == null) continue;
            componentScope = currentProjectScope;
        }
        return componentScope;
    }
}

