/*
 * Decompiled with CFR 0.152.
 */
package org.cyclonedx.maven;

import com.github.packageurl.MalformedPackageURLException;
import com.github.packageurl.PackageURL;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Properties;
import java.util.TreeMap;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.License;
import org.apache.maven.model.MailingList;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingResult;
import org.apache.maven.repository.RepositorySystem;
import org.cyclonedx.CycloneDxSchema;
import org.cyclonedx.maven.ModelConverter;
import org.cyclonedx.model.Component;
import org.cyclonedx.model.ExternalReference;
import org.cyclonedx.model.LicenseChoice;
import org.cyclonedx.model.Metadata;
import org.cyclonedx.model.Tool;
import org.cyclonedx.util.BomUtils;
import org.cyclonedx.util.LicenseResolver;
import org.eclipse.aether.artifact.Artifact;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Named
public class DefaultModelConverter
implements ModelConverter {
    private final Logger logger = LoggerFactory.getLogger(DefaultModelConverter.class);
    @Inject
    private MavenSession session;
    @Inject
    private RepositorySystem repositorySystem;
    @Inject
    private ProjectBuilder mavenProjectBuilder;

    @Override
    public String generatePackageUrl(org.apache.maven.artifact.Artifact artifact) {
        return this.generatePackageUrl(artifact, true);
    }

    @Override
    public String generateVersionlessPackageUrl(org.apache.maven.artifact.Artifact artifact) {
        return this.generatePackageUrl(artifact, false);
    }

    private String generatePackageUrl(org.apache.maven.artifact.Artifact artifact, boolean includeVersion) {
        TreeMap<String, String> qualifiers = null;
        if (artifact.getType() != null || artifact.getClassifier() != null) {
            qualifiers = new TreeMap<String, String>();
            if (artifact.getType() != null) {
                qualifiers.put("type", artifact.getType());
            }
            if (artifact.getClassifier() != null) {
                qualifiers.put("classifier", artifact.getClassifier());
            }
        }
        String version = includeVersion ? artifact.getBaseVersion() : null;
        return this.generatePackageUrl(artifact.getGroupId(), artifact.getArtifactId(), version, qualifiers, null);
    }

    @Override
    public String generatePackageUrl(Artifact artifact) {
        return this.generatePackageUrl(artifact, true, true);
    }

    @Override
    public String generateVersionlessPackageUrl(Artifact artifact) {
        return this.generatePackageUrl(artifact, false, true);
    }

    @Override
    public String generateClassifierlessPackageUrl(Artifact artifact) {
        return this.generatePackageUrl(artifact, true, false);
    }

    private boolean isEmpty(String value) {
        return value == null || value.length() == 0;
    }

    private String generatePackageUrl(Artifact artifact, boolean includeVersion, boolean includeClassifier) {
        TreeMap<String, String> qualifiers = null;
        String type = (String)artifact.getProperties().get("type");
        String classifier = artifact.getClassifier();
        if (!this.isEmpty(type) || includeClassifier && !this.isEmpty(classifier)) {
            qualifiers = new TreeMap<String, String>();
            if (!this.isEmpty(type)) {
                qualifiers.put("type", type);
            }
            if (includeClassifier && !this.isEmpty(classifier)) {
                qualifiers.put("classifier", classifier);
            }
        }
        String version = includeVersion ? artifact.getBaseVersion() : null;
        return this.generatePackageUrl(artifact.getGroupId(), artifact.getArtifactId(), version, qualifiers, null);
    }

    private String generatePackageUrl(String groupId, String artifactId, String version, TreeMap<String, String> qualifiers, String subpath) {
        try {
            return new PackageURL("maven", groupId, artifactId, version, qualifiers, subpath).canonicalize();
        }
        catch (MalformedPackageURLException e) {
            this.logger.warn("An unexpected issue occurred attempting to create a PackageURL for " + groupId + ":" + artifactId + ":" + version, (Throwable)e);
            return null;
        }
    }

    @Override
    public Component convert(org.apache.maven.artifact.Artifact artifact, CycloneDxSchema.Version schemaVersion, boolean includeLicenseText) {
        Component component = new Component();
        component.setGroup(artifact.getGroupId());
        component.setName(artifact.getArtifactId());
        component.setVersion(artifact.getBaseVersion());
        component.setType(Component.Type.LIBRARY);
        try {
            this.logger.debug("CycloneDX: Calculating Hashes");
            component.setHashes(BomUtils.calculateHashes((File)artifact.getFile(), (CycloneDxSchema.Version)schemaVersion));
        }
        catch (IOException e) {
            this.logger.error("Error encountered calculating hashes", (Throwable)e);
        }
        if (CycloneDxSchema.Version.VERSION_10 == schemaVersion) {
            component.setModified(Boolean.valueOf(this.isModified(artifact)));
        }
        component.setPurl(this.generatePackageUrl(artifact));
        if (CycloneDxSchema.Version.VERSION_10 != schemaVersion) {
            component.setBomRef(component.getPurl());
        }
        if (this.isDescribedArtifact(artifact)) {
            try {
                MavenProject project = this.getEffectiveMavenProject(artifact);
                if (project != null) {
                    this.extractComponentMetadata(project, component, schemaVersion, includeLicenseText);
                }
            }
            catch (ProjectBuildingException e) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.warn("Unable to create Maven project for " + artifact.getId() + " from repository.", (Throwable)e);
                }
                this.logger.warn("Unable to create Maven project for " + artifact.getId() + " from repository.");
            }
        }
        return component;
    }

    private boolean isModified(org.apache.maven.artifact.Artifact artifact) {
        return false;
    }

    private boolean isDescribedArtifact(org.apache.maven.artifact.Artifact artifact) {
        return artifact.getType().equalsIgnoreCase("jar");
    }

    private void extractComponentMetadata(MavenProject project, Component component, CycloneDxSchema.Version schemaVersion, boolean includeLicenseText) {
        if (component.getPublisher() == null && project.getOrganization() != null) {
            component.setPublisher(project.getOrganization().getName());
        }
        if (component.getDescription() == null) {
            component.setDescription(project.getDescription());
        }
        if ((component.getLicenseChoice() == null || component.getLicenseChoice().getLicenses() == null || component.getLicenseChoice().getLicenses().isEmpty()) && project.getLicenses() != null) {
            component.setLicenseChoice(this.resolveMavenLicenses(project.getLicenses(), schemaVersion, includeLicenseText));
        }
        if (CycloneDxSchema.Version.VERSION_10 != schemaVersion) {
            if (project.getUrl() != null && !this.doesComponentHaveExternalReference(component, ExternalReference.Type.WEBSITE)) {
                this.addExternalReference(ExternalReference.Type.WEBSITE, project.getUrl(), component);
            }
            if (project.getCiManagement() != null && project.getCiManagement().getUrl() != null && !this.doesComponentHaveExternalReference(component, ExternalReference.Type.BUILD_SYSTEM)) {
                this.addExternalReference(ExternalReference.Type.BUILD_SYSTEM, project.getCiManagement().getUrl(), component);
            }
            if (project.getDistributionManagement() != null && project.getDistributionManagement().getDownloadUrl() != null && !this.doesComponentHaveExternalReference(component, ExternalReference.Type.DISTRIBUTION)) {
                this.addExternalReference(ExternalReference.Type.DISTRIBUTION, project.getDistributionManagement().getDownloadUrl(), component);
            }
            if (project.getDistributionManagement() != null && project.getDistributionManagement().getRepository() != null && !this.doesComponentHaveExternalReference(component, ExternalReference.Type.DISTRIBUTION)) {
                this.addExternalReference(ExternalReference.Type.DISTRIBUTION, project.getDistributionManagement().getRepository().getUrl(), component);
            }
            if (project.getIssueManagement() != null && project.getIssueManagement().getUrl() != null && !this.doesComponentHaveExternalReference(component, ExternalReference.Type.ISSUE_TRACKER)) {
                this.addExternalReference(ExternalReference.Type.ISSUE_TRACKER, project.getIssueManagement().getUrl(), component);
            }
            if (project.getMailingLists() != null && project.getMailingLists().size() > 0) {
                for (MailingList list : project.getMailingLists()) {
                    if (list.getArchive() != null) {
                        if (this.doesComponentHaveExternalReference(component, ExternalReference.Type.MAILING_LIST)) continue;
                        this.addExternalReference(ExternalReference.Type.MAILING_LIST, list.getArchive(), component);
                        continue;
                    }
                    if (list.getSubscribe() == null || this.doesComponentHaveExternalReference(component, ExternalReference.Type.MAILING_LIST)) continue;
                    this.addExternalReference(ExternalReference.Type.MAILING_LIST, list.getSubscribe(), component);
                }
            }
            if (project.getScm() != null && project.getScm().getUrl() != null && !this.doesComponentHaveExternalReference(component, ExternalReference.Type.VCS)) {
                this.addExternalReference(ExternalReference.Type.VCS, project.getScm().getUrl(), component);
            }
        }
    }

    private MavenProject getEffectiveMavenProject(org.apache.maven.artifact.Artifact artifact) throws ProjectBuildingException {
        org.apache.maven.artifact.Artifact pomArtifact = this.repositorySystem.createProjectArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion());
        ProjectBuildingResult build = this.mavenProjectBuilder.build(pomArtifact, this.session.getProjectBuildingRequest().setValidationLevel(0).setProcessPlugins(false));
        return build.getProject();
    }

    private void addExternalReference(ExternalReference.Type referenceType, String url, Component component) {
        try {
            URI uri = new URI(url.trim());
            ExternalReference ref = new ExternalReference();
            ref.setType(referenceType);
            ref.setUrl(uri.toString());
            component.addExternalReference(ref);
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
    }

    private boolean doesComponentHaveExternalReference(Component component, ExternalReference.Type type) {
        if (component.getExternalReferences() != null && !component.getExternalReferences().isEmpty()) {
            for (ExternalReference ref : component.getExternalReferences()) {
                if (type != ref.getType()) continue;
                return true;
            }
        }
        return false;
    }

    private LicenseChoice resolveMavenLicenses(List<License> projectLicenses, CycloneDxSchema.Version schemaVersion, boolean includeLicenseText) {
        LicenseChoice licenseChoice = new LicenseChoice();
        for (License artifactLicense : projectLicenses) {
            boolean resolved = false;
            if (artifactLicense.getName() != null) {
                LicenseChoice resolvedByName = LicenseResolver.resolve((String)artifactLicense.getName(), (boolean)includeLicenseText);
                resolved = this.resolveLicenseInfo(licenseChoice, resolvedByName, schemaVersion);
            }
            if (artifactLicense.getUrl() != null && !resolved) {
                LicenseChoice resolvedByUrl = LicenseResolver.resolve((String)artifactLicense.getUrl(), (boolean)includeLicenseText);
                resolved = this.resolveLicenseInfo(licenseChoice, resolvedByUrl, schemaVersion);
            }
            if (artifactLicense.getName() == null || resolved) continue;
            org.cyclonedx.model.License license = new org.cyclonedx.model.License();
            license.setName(artifactLicense.getName().trim());
            if (StringUtils.isNotBlank((CharSequence)artifactLicense.getUrl())) {
                try {
                    URI uri = new URI(artifactLicense.getUrl().trim());
                    license.setUrl(uri.toString());
                }
                catch (URISyntaxException uRISyntaxException) {
                    // empty catch block
                }
            }
            licenseChoice.addLicense(license);
        }
        return licenseChoice;
    }

    private boolean resolveLicenseInfo(LicenseChoice licenseChoice, LicenseChoice licenseChoiceToResolve, CycloneDxSchema.Version schemaVersion) {
        if (licenseChoiceToResolve != null) {
            if (licenseChoiceToResolve.getLicenses() != null && !licenseChoiceToResolve.getLicenses().isEmpty()) {
                licenseChoice.addLicense((org.cyclonedx.model.License)licenseChoiceToResolve.getLicenses().get(0));
                return true;
            }
            if (licenseChoiceToResolve.getExpression() != null && CycloneDxSchema.Version.VERSION_10 != schemaVersion) {
                licenseChoice.setExpression(licenseChoiceToResolve.getExpression());
                return true;
            }
        }
        return false;
    }

    @Override
    public Metadata convert(MavenProject project, String analysis, String projectType, CycloneDxSchema.Version schemaVersion, boolean includeLicenseText) {
        Tool tool = new Tool();
        Properties properties = this.readPluginProperties();
        tool.setVendor(properties.getProperty("vendor"));
        tool.setName(properties.getProperty("name") + ' ' + analysis);
        tool.setVersion(properties.getProperty("version"));
        DefaultArtifact self = new DefaultArtifact(properties.getProperty("groupId"), properties.getProperty("artifactId"), properties.getProperty("version"), "compile", "jar", null, (ArtifactHandler)new DefaultArtifactHandler());
        org.apache.maven.artifact.Artifact resolved = this.session.getLocalRepository().find((org.apache.maven.artifact.Artifact)self);
        if (resolved != null) {
            try {
                resolved.setFile(new File(resolved.getFile() + ".jar"));
                tool.setHashes(BomUtils.calculateHashes((File)resolved.getFile(), (CycloneDxSchema.Version)schemaVersion));
            }
            catch (IOException e) {
                this.logger.warn("Unable to calculate hashes of self", (Throwable)e);
            }
        }
        Component component = new Component();
        component.setGroup(project.getGroupId());
        component.setName(project.getArtifactId());
        component.setVersion(project.getVersion());
        component.setType(this.resolveProjectType(projectType));
        component.setPurl(this.generatePackageUrl(project.getArtifact()));
        component.setBomRef(component.getPurl());
        this.extractComponentMetadata(project, component, schemaVersion, includeLicenseText);
        Metadata metadata = new Metadata();
        metadata.addTool(tool);
        metadata.setComponent(component);
        return metadata;
    }

    private Properties readPluginProperties() {
        Properties props = new Properties();
        try {
            props.load(this.getClass().getClassLoader().getResourceAsStream("plugin.properties"));
        }
        catch (IOException | NullPointerException e) {
            this.logger.warn("Unable to load plugin.properties", (Throwable)e);
        }
        return props;
    }

    private Component.Type resolveProjectType(String projectType) {
        for (Component.Type type : Component.Type.values()) {
            if (!type.getTypeName().equalsIgnoreCase(projectType)) continue;
            return type;
        }
        this.logger.warn("Invalid project type. Defaulting to 'library'");
        this.logger.warn("Valid types are:");
        for (Component.Type type : Component.Type.values()) {
            this.logger.warn("  " + type.getTypeName());
        }
        return Component.Type.LIBRARY;
    }
}

