/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.records.reader.impl.csv;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.datavec.api.records.SequenceRecord;
import org.datavec.api.records.metadata.RecordMetaData;
import org.datavec.api.records.metadata.RecordMetaDataURI;
import org.datavec.api.records.reader.SequenceRecordReader;
import org.datavec.api.records.reader.impl.FileRecordReader;
import org.datavec.api.writable.Text;
import org.datavec.api.writable.Writable;

public class CSVSequenceRecordReader
extends FileRecordReader
implements SequenceRecordReader {
    private int skipNumLines = 0;
    private String delimiter = ",";

    public CSVSequenceRecordReader() {
        this(0, ",");
    }

    public CSVSequenceRecordReader(int skipNumLines) {
        this(skipNumLines, ",");
    }

    public CSVSequenceRecordReader(int skipNumLines, String delimiter) {
        this.skipNumLines = skipNumLines;
        this.delimiter = delimiter;
    }

    @Override
    public List<List<Writable>> sequenceRecord(URI uri, DataInputStream dataInputStream) throws IOException {
        this.invokeListeners(uri);
        return this.loadAndClose(dataInputStream);
    }

    @Override
    public List<List<Writable>> sequenceRecord() {
        return this.nextSequence().getSequenceRecord();
    }

    @Override
    public SequenceRecord nextSequence() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No next element");
        }
        URI next = (URI)this.locationsIterator.next();
        this.invokeListeners(next);
        List<List<Writable>> out = this.loadAndClose((InputStream)this.streamCreatorFn.apply((Object)next));
        return new org.datavec.api.records.impl.SequenceRecord(out, new RecordMetaDataURI(next));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<List<Writable>> loadAndClose(InputStream inputStream) {
        List<List<Writable>> list;
        block6: {
            LineIterator lineIter = null;
            try {
                lineIter = IOUtils.lineIterator((Reader)new BufferedReader(new InputStreamReader(inputStream)));
                list = this.load((Iterator<String>)lineIter);
                if (lineIter == null) break block6;
            }
            catch (Throwable throwable) {
                if (lineIter != null) {
                    lineIter.close();
                }
                IOUtils.closeQuietly((InputStream)inputStream);
                throw throwable;
            }
            lineIter.close();
        }
        IOUtils.closeQuietly((InputStream)inputStream);
        return list;
    }

    private List<List<Writable>> load(Iterator<String> lineIter) {
        if (this.skipNumLines > 0) {
            int count = 0;
            while (count++ < this.skipNumLines && lineIter.hasNext()) {
                lineIter.next();
            }
        }
        ArrayList<List<Writable>> out = new ArrayList<List<Writable>>();
        while (lineIter.hasNext()) {
            String line = lineIter.next();
            String[] split = line.split(this.delimiter);
            ArrayList<Text> list = new ArrayList<Text>();
            for (String s : split) {
                list.add(new Text(s));
            }
            out.add(list);
        }
        return out;
    }

    @Override
    public SequenceRecord loadSequenceFromMetaData(RecordMetaData recordMetaData) throws IOException {
        return this.loadSequenceFromMetaData(Collections.singletonList(recordMetaData)).get(0);
    }

    @Override
    public List<SequenceRecord> loadSequenceFromMetaData(List<RecordMetaData> recordMetaDatas) throws IOException {
        ArrayList<SequenceRecord> out = new ArrayList<SequenceRecord>();
        for (RecordMetaData meta : recordMetaDatas) {
            File next = new File(meta.getURI());
            List<List<Writable>> sequence = this.loadAndClose(new FileInputStream(next));
            out.add(new org.datavec.api.records.impl.SequenceRecord(sequence, meta));
        }
        return out;
    }
}

