/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.sequence.trim;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.datavec.api.transform.Transform;
import org.datavec.api.transform.schema.Schema;
import org.datavec.api.writable.Writable;
import org.nd4j.shade.jackson.annotation.JsonIgnoreProperties;
import org.nd4j.shade.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(value={"schema"})
public class SequenceTrimTransform
implements Transform {
    private int numStepsToTrim;
    private boolean trimFromStart;
    private Schema schema;

    public SequenceTrimTransform(@JsonProperty(value="numStepsToTrim") int numStepsToTrim, @JsonProperty(value="trimFromStart") boolean trimFromStart) {
        this.numStepsToTrim = numStepsToTrim;
        this.trimFromStart = trimFromStart;
    }

    @Override
    public Schema transform(Schema inputSchema) {
        return inputSchema;
    }

    @Override
    public void setInputSchema(Schema inputSchema) {
        this.schema = inputSchema;
    }

    @Override
    public Schema getInputSchema() {
        return this.schema;
    }

    @Override
    public String outputColumnName() {
        return null;
    }

    @Override
    public String[] outputColumnNames() {
        return this.schema.getColumnNames().toArray(new String[this.schema.numColumns()]);
    }

    @Override
    public String[] columnNames() {
        return this.outputColumnNames();
    }

    @Override
    public String columnName() {
        return this.outputColumnName();
    }

    @Override
    public List<Writable> map(List<Writable> writables) {
        throw new UnsupportedOperationException("SequenceTrimTransform cannot be applied to non-sequence values");
    }

    @Override
    public List<List<Writable>> mapSequence(List<List<Writable>> sequence) {
        int start = 0;
        int end = sequence.size();
        if (this.trimFromStart) {
            start += this.numStepsToTrim;
        } else {
            end -= this.numStepsToTrim;
        }
        if (end < start) {
            return Collections.emptyList();
        }
        ArrayList<List<Writable>> out = new ArrayList<List<Writable>>(end - start);
        for (int i = start; i < end; ++i) {
            out.add(sequence.get(i));
        }
        return out;
    }

    @Override
    public Object map(Object input) {
        throw new UnsupportedOperationException("SequenceTrimTransform cannot be applied to non-sequence values");
    }

    @Override
    public Object mapSequence(Object sequence) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SequenceTrimTransform)) {
            return false;
        }
        SequenceTrimTransform other = (SequenceTrimTransform)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getNumStepsToTrim() != other.getNumStepsToTrim()) {
            return false;
        }
        return this.isTrimFromStart() == other.isTrimFromStart();
    }

    protected boolean canEqual(Object other) {
        return other instanceof SequenceTrimTransform;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getNumStepsToTrim();
        result = result * 59 + (this.isTrimFromStart() ? 79 : 97);
        return result;
    }

    public int getNumStepsToTrim() {
        return this.numStepsToTrim;
    }

    public boolean isTrimFromStart() {
        return this.trimFromStart;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public void setNumStepsToTrim(int numStepsToTrim) {
        this.numStepsToTrim = numStepsToTrim;
    }

    public void setTrimFromStart(boolean trimFromStart) {
        this.trimFromStart = trimFromStart;
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    public String toString() {
        return "SequenceTrimTransform(numStepsToTrim=" + this.getNumStepsToTrim() + ", trimFromStart=" + this.isTrimFromStart() + ", schema=" + this.getSchema() + ")";
    }
}

