/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.transform;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.datavec.api.transform.ColumnOp;
import org.datavec.api.transform.metadata.ColumnMetaData;
import org.datavec.api.transform.schema.Schema;
import org.datavec.api.transform.transform.BaseTransform;
import org.datavec.api.writable.Writable;
import org.nd4j.shade.jackson.annotation.JsonIgnoreProperties;

@JsonIgnoreProperties(value={"inputSchema", "columnNumber"})
public abstract class BaseColumnTransform
extends BaseTransform
implements ColumnOp {
    protected String columnName;
    protected int columnNumber = -1;
    private static final long serialVersionUID = 0L;

    public BaseColumnTransform(String columnName) {
        this.columnName = columnName;
    }

    @Override
    public void setInputSchema(Schema inputSchema) {
        this.inputSchema = inputSchema;
        this.columnNumber = inputSchema.getIndexOfColumn(this.columnName);
    }

    @Override
    public Schema transform(Schema schema) {
        if (this.columnNumber == -1) {
            throw new IllegalStateException("columnNumber == -1 -> setInputSchema not called?");
        }
        List<ColumnMetaData> oldMeta = schema.getColumnMetaData();
        ArrayList<ColumnMetaData> newMeta = new ArrayList<ColumnMetaData>(oldMeta.size());
        Iterator<ColumnMetaData> typesIter = oldMeta.iterator();
        int i = 0;
        while (typesIter.hasNext()) {
            ColumnMetaData t = typesIter.next();
            if (i++ == this.columnNumber) {
                newMeta.add(this.getNewColumnMetaData(t.getName(), t));
                continue;
            }
            newMeta.add(t);
        }
        return schema.newSchema(newMeta);
    }

    public abstract ColumnMetaData getNewColumnMetaData(String var1, ColumnMetaData var2);

    @Override
    public List<Writable> map(List<Writable> writables) {
        if (writables.size() != this.inputSchema.numColumns()) {
            throw new IllegalStateException("Cannot execute transform: input writables list length (" + writables.size() + ") does not match expected number of elements (schema: " + this.inputSchema.numColumns() + "). Transform = " + this.toString());
        }
        int n = writables.size();
        ArrayList<Writable> out = new ArrayList<Writable>(n);
        int i = 0;
        for (Writable w : writables) {
            if (i++ == this.columnNumber) {
                Writable newW = this.map(w);
                out.add(newW);
                continue;
            }
            out.add(w);
        }
        return out;
    }

    @Override
    public String outputColumnName() {
        return this.outputColumnNames()[0];
    }

    @Override
    public String[] outputColumnNames() {
        return new String[]{this.columnName};
    }

    @Override
    public String[] columnNames() {
        return new String[]{this.columnName};
    }

    @Override
    public String columnName() {
        return this.columnNames()[0];
    }

    public abstract Writable map(Writable var1);

    @Override
    public abstract String toString();

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseColumnTransform o2 = (BaseColumnTransform)o;
        return this.columnName.equals(o2.columnName);
    }

    @Override
    public Object mapSequence(Object sequence) {
        List list = (List)sequence;
        ArrayList<Object> ret = new ArrayList<Object>();
        for (Object o : list) {
            ret.add(this.map(o));
        }
        return ret;
    }

    @Override
    public int hashCode() {
        return this.columnName.hashCode();
    }

    public String getColumnName() {
        return this.columnName;
    }

    public int getColumnNumber() {
        return this.columnNumber;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public void setColumnNumber(int columnNumber) {
        this.columnNumber = columnNumber;
    }

    public BaseColumnTransform() {
    }
}

