/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.transform.longtransform;

import org.datavec.api.transform.MathOp;
import org.datavec.api.transform.metadata.ColumnMetaData;
import org.datavec.api.transform.metadata.LongMetaData;
import org.datavec.api.transform.transform.BaseColumnTransform;
import org.datavec.api.writable.LongWritable;
import org.datavec.api.writable.Writable;
import org.nd4j.shade.jackson.annotation.JsonProperty;

public class LongMathOpTransform
extends BaseColumnTransform {
    private final MathOp mathOp;
    private final long scalar;

    public LongMathOpTransform(@JsonProperty(value="columnName") String columnName, @JsonProperty(value="mathOp") MathOp mathOp, @JsonProperty(value="scalar") long scalar) {
        super(columnName);
        this.mathOp = mathOp;
        this.scalar = scalar;
    }

    @Override
    public ColumnMetaData getNewColumnMetaData(String newName, ColumnMetaData oldColumnType) {
        if (!(oldColumnType instanceof LongMetaData)) {
            throw new IllegalStateException("Column is not an Long column");
        }
        LongMetaData meta = (LongMetaData)oldColumnType;
        Long minValue = meta.getMinAllowedValue();
        Long maxValue = meta.getMaxAllowedValue();
        if (minValue != null) {
            minValue = this.doOp(minValue);
        }
        if (maxValue != null) {
            maxValue = this.doOp(maxValue);
        }
        if (minValue != null && maxValue != null && minValue > maxValue) {
            Long temp = minValue;
            minValue = maxValue;
            maxValue = temp;
        }
        return new LongMetaData(newName, minValue, maxValue);
    }

    private long doOp(long input) {
        switch (this.mathOp) {
            case Add: {
                return input + this.scalar;
            }
            case Subtract: {
                return input - this.scalar;
            }
            case Multiply: {
                return input * this.scalar;
            }
            case Divide: {
                return input / this.scalar;
            }
            case Modulus: {
                return input % this.scalar;
            }
            case ReverseSubtract: {
                return this.scalar - input;
            }
            case ReverseDivide: {
                return this.scalar / input;
            }
            case ScalarMin: {
                return Math.min(input, this.scalar);
            }
            case ScalarMax: {
                return Math.max(input, this.scalar);
            }
        }
        throw new IllegalStateException("Unknown or not implemented math op: " + this.mathOp);
    }

    @Override
    public Writable map(Writable columnWritable) {
        return new LongWritable(this.doOp(columnWritable.toLong()));
    }

    @Override
    public String toString() {
        return "LongMathOpTransform(mathOp=" + this.mathOp + ",scalar=" + this.scalar + ")";
    }

    @Override
    public Object map(Object input) {
        Number n = (Number)input;
        return this.doOp(n.longValue());
    }

    public MathOp getMathOp() {
        return this.mathOp;
    }

    public long getScalar() {
        return this.scalar;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LongMathOpTransform)) {
            return false;
        }
        LongMathOpTransform other = (LongMathOpTransform)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getScalar() != other.getScalar()) {
            return false;
        }
        MathOp this$mathOp = this.getMathOp();
        MathOp other$mathOp = other.getMathOp();
        return !(this$mathOp == null ? other$mathOp != null : !((Object)((Object)this$mathOp)).equals((Object)other$mathOp));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof LongMathOpTransform;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $scalar = this.getScalar();
        result = result * 59 + (int)($scalar >>> 32 ^ $scalar);
        MathOp $mathOp = this.getMathOp();
        result = result * 59 + ($mathOp == null ? 43 : ((Object)((Object)$mathOp)).hashCode());
        return result;
    }
}

