/*
 * Decompiled with CFR 0.152.
 */
package org.datavec.api.transform.transform.string;

import org.datavec.api.transform.metadata.ColumnMetaData;
import org.datavec.api.transform.metadata.StringMetaData;
import org.datavec.api.transform.transform.BaseColumnTransform;
import org.datavec.api.writable.Text;
import org.datavec.api.writable.Writable;
import org.nd4j.shade.jackson.annotation.JsonIgnoreProperties;
import org.nd4j.shade.jackson.annotation.JsonProperty;

@JsonIgnoreProperties(value={"inputSchema", "columnNumber"})
public class AppendStringColumnTransform
extends BaseColumnTransform {
    private String toAppend;

    public AppendStringColumnTransform(@JsonProperty(value="columnName") String columnName, @JsonProperty(value="toAppend") String toAppend) {
        super(columnName);
        this.toAppend = toAppend;
    }

    @Override
    public ColumnMetaData getNewColumnMetaData(String newName, ColumnMetaData oldColumnType) {
        return new StringMetaData(newName);
    }

    @Override
    public Writable map(Writable columnWritable) {
        return new Text(columnWritable + this.toAppend);
    }

    @Override
    public String toString() {
        return "AppendStringColumnTransform(append=\"" + this.toAppend + "\")";
    }

    @Override
    public Object map(Object input) {
        return input.toString() + this.toAppend;
    }

    public String getToAppend() {
        return this.toAppend;
    }

    public void setToAppend(String toAppend) {
        this.toAppend = toAppend;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AppendStringColumnTransform)) {
            return false;
        }
        AppendStringColumnTransform other = (AppendStringColumnTransform)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$toAppend = this.getToAppend();
        String other$toAppend = other.getToAppend();
        return !(this$toAppend == null ? other$toAppend != null : !this$toAppend.equals(other$toAppend));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AppendStringColumnTransform;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $toAppend = this.getToAppend();
        result = result * 59 + ($toAppend == null ? 43 : $toAppend.hashCode());
        return result;
    }
}

