/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.mvstore;

import java.io.File;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import org.dizitart.no2.mvstore.MVStoreConfig;
import org.dizitart.no2.mvstore.MVStoreModule;
import org.dizitart.no2.store.events.StoreEventListener;
import org.h2.mvstore.FileStore;

public class MVStoreModuleBuilder {
    private String filePath;
    private int autoCommitBufferSize = 1024;
    private char[] encryptionKey;
    private boolean readOnly;
    private boolean compress;
    private boolean compressHigh;
    private boolean autoCommit = true;
    private boolean recoveryMode = false;
    private int cacheSize = 16;
    private int cacheConcurrency = 16;
    private int pageSplitSize = 16;
    private FileStore<?> fileStore;
    private MVStoreConfig dbConfig = new MVStoreConfig();
    private final Set<StoreEventListener> eventListeners = new HashSet<StoreEventListener>();

    MVStoreModuleBuilder() {
    }

    public MVStoreModuleBuilder filePath(File file) {
        if (file != null) {
            this.filePath = file.getPath();
        }
        return this;
    }

    public MVStoreModuleBuilder filePath(String path) {
        this.filePath = path;
        return this;
    }

    public MVStoreModuleBuilder addStoreEventListener(StoreEventListener listener) {
        this.eventListeners.add(listener);
        return this;
    }

    public MVStoreModule build() {
        MVStoreModule module = new MVStoreModule(this.filePath());
        this.dbConfig.filePath(this.filePath());
        this.dbConfig.autoCommitBufferSize(this.autoCommitBufferSize());
        this.dbConfig.encryptionKey(this.encryptionKey());
        this.dbConfig.isReadOnly(this.readOnly());
        this.dbConfig.compress(this.compress());
        this.dbConfig.compressHigh(this.compressHigh());
        this.dbConfig.autoCommit(this.autoCommit());
        this.dbConfig.recoveryMode(this.recoveryMode());
        this.dbConfig.cacheSize(this.cacheSize());
        this.dbConfig.cacheConcurrency(this.cacheConcurrency());
        this.dbConfig.pageSplitSize(this.pageSplitSize());
        this.dbConfig.fileStore(this.fileStore());
        this.dbConfig.eventListeners(this.eventListeners());
        module.setStoreConfig(this.dbConfig);
        return module;
    }

    @Generated
    public String filePath() {
        return this.filePath;
    }

    @Generated
    public int autoCommitBufferSize() {
        return this.autoCommitBufferSize;
    }

    @Generated
    public char[] encryptionKey() {
        return this.encryptionKey;
    }

    @Generated
    public boolean readOnly() {
        return this.readOnly;
    }

    @Generated
    public boolean compress() {
        return this.compress;
    }

    @Generated
    public boolean compressHigh() {
        return this.compressHigh;
    }

    @Generated
    public boolean autoCommit() {
        return this.autoCommit;
    }

    @Generated
    public boolean recoveryMode() {
        return this.recoveryMode;
    }

    @Generated
    public int cacheSize() {
        return this.cacheSize;
    }

    @Generated
    public int cacheConcurrency() {
        return this.cacheConcurrency;
    }

    @Generated
    public int pageSplitSize() {
        return this.pageSplitSize;
    }

    @Generated
    public FileStore<?> fileStore() {
        return this.fileStore;
    }

    @Generated
    public MVStoreConfig dbConfig() {
        return this.dbConfig;
    }

    @Generated
    public Set<StoreEventListener> eventListeners() {
        return this.eventListeners;
    }

    @Generated
    public MVStoreModuleBuilder autoCommitBufferSize(int autoCommitBufferSize) {
        this.autoCommitBufferSize = autoCommitBufferSize;
        return this;
    }

    @Generated
    public MVStoreModuleBuilder encryptionKey(char[] encryptionKey) {
        this.encryptionKey = encryptionKey;
        return this;
    }

    @Generated
    public MVStoreModuleBuilder readOnly(boolean readOnly) {
        this.readOnly = readOnly;
        return this;
    }

    @Generated
    public MVStoreModuleBuilder compress(boolean compress) {
        this.compress = compress;
        return this;
    }

    @Generated
    public MVStoreModuleBuilder compressHigh(boolean compressHigh) {
        this.compressHigh = compressHigh;
        return this;
    }

    @Generated
    public MVStoreModuleBuilder autoCommit(boolean autoCommit) {
        this.autoCommit = autoCommit;
        return this;
    }

    @Generated
    public MVStoreModuleBuilder recoveryMode(boolean recoveryMode) {
        this.recoveryMode = recoveryMode;
        return this;
    }

    @Generated
    public MVStoreModuleBuilder cacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
        return this;
    }

    @Generated
    public MVStoreModuleBuilder cacheConcurrency(int cacheConcurrency) {
        this.cacheConcurrency = cacheConcurrency;
        return this;
    }

    @Generated
    public MVStoreModuleBuilder pageSplitSize(int pageSplitSize) {
        this.pageSplitSize = pageSplitSize;
        return this;
    }

    @Generated
    public MVStoreModuleBuilder fileStore(FileStore<?> fileStore) {
        this.fileStore = fileStore;
        return this;
    }

    @Generated
    public MVStoreModuleBuilder dbConfig(MVStoreConfig dbConfig) {
        this.dbConfig = dbConfig;
        return this;
    }
}

