/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.mvstore;

import java.util.Iterator;
import org.dizitart.no2.collection.NitriteId;
import org.dizitart.no2.common.RecordStream;
import org.dizitart.no2.index.BoundingBox;
import org.dizitart.no2.mvstore.MVSpatialKey;
import org.dizitart.no2.store.NitriteRTree;
import org.dizitart.no2.store.NitriteStore;
import org.h2.mvstore.MVStore;
import org.h2.mvstore.rtree.MVRTreeMap;
import org.h2.mvstore.rtree.Spatial;

class NitriteMVRTreeMap<Key extends BoundingBox, Value>
implements NitriteRTree<Key, Value> {
    private final MVRTreeMap<Key> mvMap;
    private final NitriteStore<?> nitriteStore;
    private final MVStore mvStore;

    NitriteMVRTreeMap(MVRTreeMap<Key> mvMap, NitriteStore<?> nitriteStore) {
        this.mvMap = mvMap;
        this.nitriteStore = nitriteStore;
        this.mvStore = mvMap.getStore();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Key key, NitriteId nitriteId) {
        if (nitriteId != null && nitriteId.getIdValue() != null) {
            MVSpatialKey spatialKey = this.getKey(key, Long.parseLong(nitriteId.getIdValue()));
            MVStore.TxCounter txCounter = this.mvStore.registerVersionUsage();
            try {
                this.mvMap.add((Spatial)spatialKey, key);
            }
            finally {
                this.mvStore.deregisterVersionUsage(txCounter);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Key key, NitriteId nitriteId) {
        if (nitriteId != null && nitriteId.getIdValue() != null) {
            MVSpatialKey spatialKey = this.getKey(key, Long.parseLong(nitriteId.getIdValue()));
            MVStore.TxCounter txCounter = this.mvStore.registerVersionUsage();
            try {
                this.mvMap.remove((Object)spatialKey);
            }
            finally {
                this.mvStore.deregisterVersionUsage(txCounter);
            }
        }
    }

    public RecordStream<NitriteId> findIntersectingKeys(Key key) {
        MVSpatialKey spatialKey = this.getKey(key, 0L);
        MVRTreeMap.RTreeCursor treeCursor = this.mvMap.findIntersectingKeys((Spatial)spatialKey);
        return this.getRecordStream(treeCursor);
    }

    public RecordStream<NitriteId> findContainedKeys(Key key) {
        MVSpatialKey spatialKey = this.getKey(key, 0L);
        MVRTreeMap.RTreeCursor treeCursor = this.mvMap.findContainedKeys((Spatial)spatialKey);
        return this.getRecordStream(treeCursor);
    }

    public long size() {
        return this.mvMap.sizeAsLong();
    }

    private MVSpatialKey getKey(Key key, long id) {
        if (key == null || key.equals((Object)BoundingBox.EMPTY)) {
            return new MVSpatialKey(id, new float[0]);
        }
        return new MVSpatialKey(id, key.getMinX(), key.getMaxX(), key.getMinY(), key.getMaxY());
    }

    private RecordStream<NitriteId> getRecordStream(final MVRTreeMap.RTreeCursor<Key> treeCursor) {
        return RecordStream.fromIterable(() -> new Iterator<NitriteId>(){

            @Override
            public boolean hasNext() {
                return treeCursor.hasNext();
            }

            @Override
            public NitriteId next() {
                MVSpatialKey next = (MVSpatialKey)treeCursor.next();
                return NitriteId.createId((String)Long.toString(next.getId()));
            }
        });
    }

    public void close() {
        this.nitriteStore.closeRTree(this.mvMap.getName());
    }

    public void clear() {
        this.mvMap.clear();
    }

    public void drop() {
        this.mvMap.clear();
        this.nitriteStore.closeRTree(this.mvMap.getName());
        this.nitriteStore.removeRTree(this.mvMap.getName());
    }
}

