/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.mvstore.compat.v1.mvstore;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import org.dizitart.no2.mvstore.compat.v1.mvstore.Chunk;
import org.dizitart.no2.mvstore.compat.v1.mvstore.Cursor;
import org.dizitart.no2.mvstore.compat.v1.mvstore.DataUtils;
import org.dizitart.no2.mvstore.compat.v1.mvstore.FileStore;
import org.dizitart.no2.mvstore.compat.v1.mvstore.MVMap;
import org.dizitart.no2.mvstore.compat.v1.mvstore.Page;
import org.dizitart.no2.mvstore.compat.v1.mvstore.RootReference;
import org.dizitart.no2.mvstore.compat.v1.mvstore.WriteBuffer;
import org.dizitart.no2.mvstore.compat.v1.mvstore.cache.CacheLongKeyLIRS;
import org.dizitart.no2.mvstore.compat.v1.mvstore.compress.CompressDeflate;
import org.dizitart.no2.mvstore.compat.v1.mvstore.compress.CompressLZF;
import org.dizitart.no2.mvstore.compat.v1.mvstore.compress.Compressor;
import org.h2.util.MathUtils;
import org.h2.util.Utils;

public class MVStore
implements AutoCloseable {
    private static final String HDR_H = "H";
    private static final String HDR_BLOCK_SIZE = "blockSize";
    private static final String HDR_FORMAT = "format";
    private static final String HDR_CREATED = "created";
    private static final String HDR_FORMAT_READ = "formatRead";
    private static final String HDR_CHUNK = "chunk";
    private static final String HDR_BLOCK = "block";
    private static final String HDR_VERSION = "version";
    private static final String HDR_CLEAN = "clean";
    private static final String HDR_FLETCHER = "fletcher";
    static final int BLOCK_SIZE = 4096;
    private static final int FORMAT_WRITE = 1;
    private static final int FORMAT_READ = 1;
    private static final int STATE_OPEN = 0;
    private static final int STATE_STOPPING = 1;
    private static final int STATE_CLOSING = 2;
    private static final int STATE_CLOSED = 3;
    private final ReentrantLock storeLock = new ReentrantLock(true);
    private final AtomicReference<BackgroundWriterThread> backgroundWriterThread = new AtomicReference();
    private volatile boolean reuseSpace = true;
    private volatile int state;
    private final FileStore fileStore;
    private final boolean fileStoreIsProvided;
    private final int pageSplitSize;
    private final int keysPerPage;
    private final CacheLongKeyLIRS<Page> cache;
    private Chunk lastChunk;
    private final ConcurrentHashMap<Integer, Chunk> chunks = new ConcurrentHashMap();
    private final Queue<RemovedPageInfo> removedPages = new PriorityBlockingQueue<RemovedPageInfo>();
    private final Deque<Chunk> deadChunks = new ArrayDeque<Chunk>();
    private long updateCounter = 0L;
    private long updateAttemptCounter = 0L;
    private final MVMap<String, String> meta;
    private final ConcurrentHashMap<Integer, MVMap<?, ?>> maps = new ConcurrentHashMap();
    private final HashMap<String, Object> storeHeader = new HashMap();
    private WriteBuffer writeBuffer;
    private final AtomicInteger lastMapId = new AtomicInteger();
    private int versionsToKeep = 5;
    private final int compressionLevel;
    private Compressor compressorFast;
    private Compressor compressorHigh;
    private final boolean recoveryMode;
    private final Thread.UncaughtExceptionHandler backgroundExceptionHandler;
    private volatile long currentVersion;
    private volatile long lastStoredVersion = -1L;
    private final AtomicLong oldestVersionToKeep = new AtomicLong();
    private final Deque<TxCounter> versions = new LinkedList<TxCounter>();
    private volatile TxCounter currentTxCounter = new TxCounter(this.currentVersion);
    private int unsavedMemory;
    private final int autoCommitMemory;
    private volatile boolean saveNeeded;
    private long creationTime;
    private int retentionTime;
    private long lastCommitTime;
    private volatile long currentStoreVersion = -1L;
    private volatile boolean metaChanged;
    private int autoCommitDelay;
    private final int autoCompactFillRate;
    private long autoCompactLastFileOpCount;
    private volatile IllegalStateException panicException;
    private long lastTimeAbsolute;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MVStore(Map<String, Object> config) {
        this.recoveryMode = config.containsKey("recoveryMode");
        this.compressionLevel = DataUtils.getConfigParam(config, "compress", 0);
        String fileName = (String)config.get("fileName");
        FileStore fileStore = (FileStore)config.get("fileStore");
        boolean bl = this.fileStoreIsProvided = fileStore != null;
        if (fileStore == null && fileName != null) {
            fileStore = new FileStore();
        }
        this.fileStore = fileStore;
        int pgSplitSize = 48;
        CacheLongKeyLIRS.Config cc = null;
        if (this.fileStore != null) {
            int mb = DataUtils.getConfigParam(config, "cacheSize", 16);
            if (mb > 0) {
                cc = new CacheLongKeyLIRS.Config();
                cc.maxMemory = (long)mb * 1024L * 1024L;
                Object o = config.get("cacheConcurrency");
                if (o != null) {
                    cc.segmentCount = (Integer)o;
                }
            }
            pgSplitSize = 16384;
        }
        this.cache = cc != null ? new CacheLongKeyLIRS(cc) : null;
        pgSplitSize = DataUtils.getConfigParam(config, "pageSplitSize", pgSplitSize);
        if (this.cache != null && (long)pgSplitSize > this.cache.getMaxItemSize()) {
            pgSplitSize = (int)this.cache.getMaxItemSize();
        }
        this.pageSplitSize = pgSplitSize;
        this.keysPerPage = DataUtils.getConfigParam(config, "keysPerPage", 48);
        this.backgroundExceptionHandler = (Thread.UncaughtExceptionHandler)config.get("backgroundExceptionHandler");
        this.meta = new MVMap(this);
        if (this.fileStore != null) {
            block18: {
                this.retentionTime = this.fileStore.getDefaultRetentionTime();
                int kb = Math.max(1, Math.min(19, Utils.scaleForAvailableMemory((int)64))) * 1024;
                kb = DataUtils.getConfigParam(config, "autoCommitBufferSize", kb);
                this.autoCommitMemory = kb * 1024;
                this.autoCompactFillRate = DataUtils.getConfigParam(config, "autoCompactFillRate", 90);
                char[] encryptionKey = (char[])config.get("encryptionKey");
                try {
                    if (!this.fileStoreIsProvided) {
                        boolean readOnly = config.containsKey("readOnly");
                        this.fileStore.open(fileName, readOnly, encryptionKey);
                    }
                    if (this.fileStore.size() == 0L) {
                        this.lastCommitTime = this.creationTime = this.getTimeAbsolute();
                        this.storeHeader.put(HDR_H, 2);
                        this.storeHeader.put(HDR_BLOCK_SIZE, 4096);
                        this.storeHeader.put(HDR_FORMAT, 1);
                        this.storeHeader.put(HDR_CREATED, this.creationTime);
                        this.writeStoreHeader();
                        break block18;
                    }
                    this.storeLock.lock();
                    try {
                        this.readStoreHeader();
                    }
                    finally {
                        this.storeLock.unlock();
                    }
                }
                catch (IllegalStateException e) {
                    this.panic(e);
                }
                finally {
                    if (encryptionKey != null) {
                        Arrays.fill(encryptionKey, '\u0000');
                    }
                }
            }
            this.lastCommitTime = this.getTimeSinceCreation();
            this.scrubMetaMap();
            int delay = DataUtils.getConfigParam(config, "autoCommitDelay", 1000);
            this.setAutoCommitDelay(delay);
        } else {
            this.autoCommitMemory = 0;
            this.autoCompactFillRate = 0;
        }
    }

    private void scrubMetaMap() {
        String mapName;
        String key2;
        HashSet<String> keysToRemove = new HashSet<String>();
        Iterator<String> it = this.meta.keyIterator("name.");
        while (it.hasNext() && (key2 = it.next()).startsWith("name.")) {
            int mapId;
            String realMapName;
            mapName = key2.substring("name.".length());
            if (mapName.equals(realMapName = this.getMapName(mapId = DataUtils.parseHexInt(this.meta.get(key2))))) continue;
            keysToRemove.add(key2);
        }
        it = this.meta.keyIterator("root.");
        while (it.hasNext() && (key2 = it.next()).startsWith("root.")) {
            String mapIdStr = key2.substring(key2.lastIndexOf(46) + 1);
            if (this.meta.containsKey("map." + mapIdStr)) continue;
            this.meta.remove(key2);
            this.markMetaChanged();
            keysToRemove.add(key2);
        }
        for (String key2 : keysToRemove) {
            this.meta.remove(key2);
            this.markMetaChanged();
        }
        it = this.meta.keyIterator("map.");
        while (it.hasNext() && (key2 = it.next()).startsWith("map.")) {
            mapName = DataUtils.getMapName(this.meta.get(key2));
            String mapIdStr = key2.substring("map.".length());
            int mapId = DataUtils.parseHexInt(mapIdStr);
            if (mapId > this.lastMapId.get()) {
                this.lastMapId.set(mapId);
            }
            if (mapIdStr.equals(this.meta.get("name." + mapName))) continue;
            this.meta.put("name." + mapName, mapIdStr);
            this.markMetaChanged();
        }
    }

    private void panic(IllegalStateException e) {
        if (this.isOpen()) {
            this.handleException(e);
            this.panicException = e;
            this.closeImmediately();
        }
        throw e;
    }

    public IllegalStateException getPanicException() {
        return this.panicException;
    }

    public static MVStore open(String fileName) {
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("fileName", fileName);
        return new MVStore(config);
    }

    public <K, V> MVMap<K, V> openMap(String name) {
        return this.openMap(name, new MVMap.Builder());
    }

    public <M extends MVMap<K, V>, K, V> M openMap(String name, MVMap.MapBuilder<M, K, V> builder) {
        Object map;
        int id = this.getMapId(name);
        if (id >= 0) {
            map = this.openMap(id, builder);
            assert (builder.getKeyType() == null || ((MVMap)map).getKeyType().getClass().equals(builder.getKeyType().getClass()));
            assert (builder.getValueType() == null || ((MVMap)map).getValueType().getClass().equals(builder.getValueType().getClass()));
        } else {
            HashMap<String, Object> c = new HashMap<String, Object>();
            id = this.lastMapId.incrementAndGet();
            assert (this.getMap(id) == null);
            c.put("id", id);
            c.put("createVersion", this.currentVersion);
            map = builder.create(this, c);
            String x = Integer.toHexString(id);
            this.meta.put(MVMap.getMapKey(id), ((MVMap)map).asString(name));
            this.meta.put("name." + name, x);
            ((MVMap)map).setRootPos(0L, this.lastStoredVersion);
            this.markMetaChanged();
            MVMap<?, ?> existingMap = this.maps.putIfAbsent(id, (MVMap<?, ?>)map);
            if (existingMap != null) {
                map = existingMap;
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <M extends MVMap<K, V>, K, V> M openMap(int id, MVMap.MapBuilder<M, K, V> builder) {
        this.storeLock.lock();
        try {
            MVMap<K, V> map = this.getMap(id);
            if (map == null) {
                String configAsString = this.meta.get(MVMap.getMapKey(id));
                HashMap<String, Object> config = configAsString != null ? new HashMap<String, String>(DataUtils.parseMap(configAsString)) : new HashMap<String, Integer>();
                config.put("id", id);
                map = builder.create(this, config);
                long root = MVStore.getRootPos(this.meta, id);
                map.setRootPos(root, this.lastStoredVersion);
                this.maps.put(id, map);
            }
            MVMap<K, V> mVMap = map;
            return (M)mVMap;
        }
        finally {
            this.storeLock.unlock();
        }
    }

    public <K, V> MVMap<K, V> getMap(int id) {
        this.checkOpen();
        MVMap<?, ?> map = this.maps.get(id);
        return map;
    }

    public Set<String> getMapNames() {
        String x;
        HashSet<String> set = new HashSet<String>();
        this.checkOpen();
        Iterator<String> it = this.meta.keyIterator("name.");
        while (it.hasNext() && (x = it.next()).startsWith("name.")) {
            String mapName = x.substring("name.".length());
            set.add(mapName);
        }
        return set;
    }

    public MVMap<String, String> getMetaMap() {
        this.checkOpen();
        return this.meta;
    }

    private MVMap<String, String> getMetaMap(long version) {
        Chunk c = this.getChunkForVersion(version);
        DataUtils.checkArgument(c != null, "Unknown version {0}", version);
        long block = c.block;
        c = this.readChunkHeader(block);
        MVMap<String, String> oldMeta = this.meta.openReadOnly(c.metaRootPos, version);
        return oldMeta;
    }

    private Chunk getChunkForVersion(long version) {
        Chunk newest = null;
        for (Chunk c : this.chunks.values()) {
            if (c.version > version || newest != null && c.id <= newest.id) continue;
            newest = c;
        }
        return newest;
    }

    public boolean hasMap(String name) {
        return this.meta.containsKey("name." + name);
    }

    public boolean hasData(String name) {
        return this.hasMap(name) && MVStore.getRootPos(this.meta, this.getMapId(name)) != 0L;
    }

    private void markMetaChanged() {
        this.metaChanged = true;
    }

    private void readStoreHeader() {
        Chunk tailChunk;
        Chunk newest = null;
        boolean assumeCleanShutdown = true;
        boolean validStoreHeader = false;
        ByteBuffer fileHeaderBlocks = this.fileStore.readFully(0L, 8192);
        byte[] buff = new byte[4096];
        for (int i = 0; i <= 4096; i += 4096) {
            fileHeaderBlocks.get(buff);
            try {
                HashMap<String, String> m = DataUtils.parseChecksummedMap(buff);
                if (m == null) {
                    assumeCleanShutdown = false;
                    continue;
                }
                long version = DataUtils.readHexLong(m, HDR_VERSION, 0L);
                boolean bl = assumeCleanShutdown = assumeCleanShutdown && (newest == null || version == newest.version);
                if (newest != null && version <= newest.version) continue;
                validStoreHeader = true;
                this.storeHeader.putAll(m);
                this.creationTime = DataUtils.readHexLong(m, HDR_CREATED, 0L);
                int chunkId = DataUtils.readHexInt(m, HDR_CHUNK, 0);
                long block = DataUtils.readHexLong(m, HDR_BLOCK, 0L);
                Chunk test = this.readChunkHeaderAndFooter(block, chunkId);
                if (test == null) continue;
                newest = test;
                continue;
            }
            catch (Exception ignore) {
                assumeCleanShutdown = false;
            }
        }
        if (!validStoreHeader) {
            throw DataUtils.newIllegalStateException(6, "Store header is corrupt: {0}", this.fileStore);
        }
        int blockSize = DataUtils.readHexInt(this.storeHeader, HDR_BLOCK_SIZE, 4096);
        if (blockSize != 4096) {
            throw DataUtils.newIllegalStateException(5, "Block size {0} is currently not supported", blockSize);
        }
        long format = DataUtils.readHexLong(this.storeHeader, HDR_FORMAT, 1L);
        if (format > 1L && !this.fileStore.isReadOnly()) {
            throw DataUtils.newIllegalStateException(5, "The write format {0} is larger than the supported format {1}, and the file was not opened in read-only mode", format, 1);
        }
        if ((format = DataUtils.readHexLong(this.storeHeader, HDR_FORMAT_READ, format)) > 1L) {
            throw DataUtils.newIllegalStateException(5, "The read format {0} is larger than the supported format {1}", format, 1);
        }
        assumeCleanShutdown = assumeCleanShutdown && newest != null && DataUtils.readHexInt(this.storeHeader, HDR_CLEAN, 0) != 0 && !this.recoveryMode;
        this.lastStoredVersion = -1L;
        this.chunks.clear();
        long now = System.currentTimeMillis();
        int year = 1970 + (int)(now / 31557600000L);
        if (year < 2014) {
            this.creationTime = now - (long)this.fileStore.getDefaultRetentionTime();
        } else if (now < this.creationTime) {
            this.creationTime = now;
            this.storeHeader.put(HDR_CREATED, this.creationTime);
        }
        long fileSize = this.fileStore.size();
        long blocksInStore = fileSize / 4096L;
        Comparator<Chunk> chunkComparator = new Comparator<Chunk>(){

            @Override
            public int compare(Chunk one, Chunk two) {
                int result = Long.compare(two.version, one.version);
                if (result == 0) {
                    result = Long.compare(one.block, two.block);
                }
                return result;
            }
        };
        if (!assumeCleanShutdown && (tailChunk = this.discoverChunk(blocksInStore)) != null) {
            blocksInStore = tailChunk.block;
            if (newest == null || tailChunk.version > newest.version) {
                newest = tailChunk;
            }
        }
        HashMap<Long, Chunk> validChunksByLocation = new HashMap<Long, Chunk>();
        if (newest != null) {
            while (true) {
                Chunk test;
                validChunksByLocation.put(newest.block, newest);
                if (newest.next == 0L || newest.next >= blocksInStore || (test = this.readChunkHeaderAndFooter(newest.next, newest.id + 1)) == null || test.version <= newest.version) break;
                assumeCleanShutdown = false;
                newest = test;
            }
        }
        if (assumeCleanShutdown) {
            this.setLastChunk(newest);
            PriorityQueue<Chunk> chunksToVerify = new PriorityQueue<Chunk>(20, Collections.reverseOrder(chunkComparator));
            try {
                Chunk c;
                Cursor<String, String> cursor = this.meta.cursor("chunk.");
                while (cursor.hasNext() && cursor.next().startsWith("chunk.")) {
                    c = Chunk.fromString(cursor.getValue());
                    assert (c.version <= this.currentVersion);
                    this.chunks.putIfAbsent(c.id, c);
                    chunksToVerify.offer(c);
                    if (chunksToVerify.size() != 20) continue;
                    chunksToVerify.poll();
                }
                while (assumeCleanShutdown && (c = (Chunk)chunksToVerify.poll()) != null) {
                    assumeCleanShutdown = this.readChunkHeaderAndFooter(c.block, c.id) != null;
                }
            }
            catch (IllegalStateException ignored) {
                assumeCleanShutdown = false;
            }
        }
        if (!assumeCleanShutdown) {
            boolean quickRecovery = false;
            if (!this.recoveryMode) {
                Chunk[] lastChunkCandidates = validChunksByLocation.values().toArray(new Chunk[0]);
                Arrays.sort(lastChunkCandidates, chunkComparator);
                HashMap<Integer, Chunk> validChunksById = new HashMap<Integer, Chunk>();
                for (Chunk chunk : lastChunkCandidates) {
                    validChunksById.put(chunk.id, chunk);
                }
                quickRecovery = this.findLastChunkWithCompleteValidChunkSet(lastChunkCandidates, validChunksByLocation, validChunksById, false);
            }
            if (!quickRecovery) {
                Chunk tailChunk2;
                long block = blocksInStore;
                while ((tailChunk2 = this.discoverChunk(block)) != null) {
                    block = tailChunk2.block;
                    validChunksByLocation.put(block, tailChunk2);
                }
                Chunk[] lastChunkCandidates = validChunksByLocation.values().toArray(new Chunk[0]);
                Arrays.sort(lastChunkCandidates, chunkComparator);
                HashMap<Integer, Chunk> validChunksById = new HashMap<Integer, Chunk>();
                for (Chunk chunk : lastChunkCandidates) {
                    validChunksById.put(chunk.id, chunk);
                }
                this.findLastChunkWithCompleteValidChunkSet(lastChunkCandidates, validChunksByLocation, validChunksById, true);
            }
        }
        this.fileStore.clear();
        for (Chunk c : this.chunks.values()) {
            if (c.isSaved()) {
                long start = c.block * 4096L;
                int length = c.len * 4096;
                this.fileStore.markUsed(start, length);
            }
            if (c.isLive()) continue;
            this.deadChunks.offer(c);
        }
        assert (this.validateFileLength("on open"));
        this.setWriteVersion(this.currentVersion);
        if (this.lastStoredVersion == -1L) {
            this.lastStoredVersion = this.currentVersion - 1L;
        }
    }

    private boolean findLastChunkWithCompleteValidChunkSet(Chunk[] lastChunkCandidates, Map<Long, Chunk> validChunksByLocation, Map<Integer, Chunk> validChunksById, boolean afterFullScan) {
        for (Chunk chunk : lastChunkCandidates) {
            boolean verified = true;
            try {
                this.setLastChunk(chunk);
                Cursor<String, String> cursor = this.meta.cursor("chunk.");
                while (cursor.hasNext() && cursor.next().startsWith("chunk.")) {
                    Chunk c = Chunk.fromString(cursor.getValue());
                    assert (c.version <= this.currentVersion);
                    Chunk test = this.chunks.putIfAbsent(c.id, c);
                    if (test != null) {
                        c = test;
                    }
                    assert (this.chunks.get(c.id) == c);
                    test = validChunksByLocation.get(c.block);
                    if (test != null && test.id == c.id) continue;
                    test = validChunksById.get(c.id);
                    if (test != null) {
                        c.block = test.block;
                        continue;
                    }
                    if (!c.isLive()) {
                        c.block = Long.MAX_VALUE;
                        c.len = Integer.MAX_VALUE;
                        if (c.unused == 0L) {
                            c.unused = this.creationTime;
                        }
                        if (c.unusedAtVersion != 0L) continue;
                        c.unusedAtVersion = -1L;
                        continue;
                    }
                    if (!afterFullScan && this.readChunkHeaderAndFooter(c.block, c.id) != null) continue;
                    verified = false;
                    break;
                }
            }
            catch (Exception ignored) {
                verified = false;
            }
            if (!verified) continue;
            return true;
        }
        return false;
    }

    private void setLastChunk(Chunk last) {
        this.chunks.clear();
        this.lastChunk = last;
        if (last == null) {
            this.lastMapId.set(0);
            this.currentVersion = 0L;
            this.lastStoredVersion = -1L;
            this.meta.setRootPos(0L, -1L);
        } else {
            this.lastMapId.set(last.mapId);
            this.currentVersion = last.version;
            this.chunks.put(last.id, last);
            this.lastStoredVersion = this.currentVersion - 1L;
            this.meta.setRootPos(last.metaRootPos, this.lastStoredVersion);
        }
    }

    private Chunk discoverChunk(long block) {
        long candidateLocation = Long.MAX_VALUE;
        Chunk candidate = null;
        while (block != candidateLocation) {
            if (block == 2L) {
                return null;
            }
            Chunk test = this.readChunkFooter(block);
            if (test != null) {
                candidateLocation = Long.MAX_VALUE;
                test = this.readChunkHeaderOptionally(test.block, test.id);
                if (test != null) {
                    candidate = test;
                    candidateLocation = test.block;
                }
            }
            if (--block <= candidateLocation || this.readChunkHeaderOptionally(block) == null) continue;
            candidateLocation = Long.MAX_VALUE;
        }
        return candidate;
    }

    private Chunk readChunkHeaderAndFooter(long block, int expectedId) {
        Chunk footer;
        Chunk header = this.readChunkHeaderOptionally(block, expectedId);
        if (header != null && ((footer = this.readChunkFooter(block + (long)header.len)) == null || footer.id != expectedId || footer.block != header.block)) {
            return null;
        }
        return header;
    }

    private Chunk readChunkFooter(long block) {
        try {
            long pos = block * 4096L - 128L;
            if (pos < 0L) {
                return null;
            }
            ByteBuffer lastBlock = this.fileStore.readFully(pos, 128);
            byte[] buff = new byte[128];
            lastBlock.get(buff);
            HashMap<String, String> m = DataUtils.parseChecksummedMap(buff);
            if (m != null) {
                int chunk = DataUtils.readHexInt(m, HDR_CHUNK, 0);
                Chunk c = new Chunk(chunk);
                c.version = DataUtils.readHexLong(m, HDR_VERSION, 0L);
                c.block = DataUtils.readHexLong(m, HDR_BLOCK, 0L);
                return c;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private void writeStoreHeader() {
        StringBuilder buff = new StringBuilder(112);
        if (this.lastChunk != null) {
            this.storeHeader.put(HDR_BLOCK, this.lastChunk.block);
            this.storeHeader.put(HDR_CHUNK, this.lastChunk.id);
            this.storeHeader.put(HDR_VERSION, this.lastChunk.version);
        }
        DataUtils.appendMap(buff, this.storeHeader);
        byte[] bytes = buff.toString().getBytes(StandardCharsets.ISO_8859_1);
        int checksum = DataUtils.getFletcher32(bytes, 0, bytes.length);
        DataUtils.appendMap(buff, HDR_FLETCHER, checksum);
        buff.append('\n');
        bytes = buff.toString().getBytes(StandardCharsets.ISO_8859_1);
        ByteBuffer header = ByteBuffer.allocate(8192);
        header.put(bytes);
        header.position(4096);
        header.put(bytes);
        header.rewind();
        this.write(0L, header);
    }

    private void write(long pos, ByteBuffer buffer) {
        try {
            this.fileStore.writeFully(pos, buffer);
        }
        catch (IllegalStateException e) {
            this.panic(e);
        }
    }

    @Override
    public void close() {
        this.closeStore(true, 0L);
    }

    public void close(long allowedCompactionTime) {
        this.closeStore(true, allowedCompactionTime);
    }

    public void closeImmediately() {
        try {
            this.closeStore(false, 0L);
        }
        catch (Throwable e) {
            this.handleException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeStore(boolean normalShutdown, long allowedCompactionTime) {
        while (!this.isClosed()) {
            this.stopBackgroundThread(normalShutdown);
            this.storeLock.lock();
            try {
                if (this.state != 0) continue;
                this.state = 1;
                try {
                    try {
                        if (normalShutdown && this.fileStore != null && !this.fileStore.isReadOnly()) {
                            for (MVMap<?, ?> map : this.maps.values()) {
                                if (!map.isClosed()) continue;
                                this.deregisterMapRoot(map.getId());
                            }
                            this.setRetentionTime(0);
                            this.commit();
                            if (allowedCompactionTime > 0L) {
                                this.compactFile(allowedCompactionTime);
                            } else if (allowedCompactionTime < 0L) {
                                this.doMaintenance(this.autoCompactFillRate);
                            }
                            this.shrinkFileIfPossible(0);
                            this.storeHeader.put(HDR_CLEAN, 1);
                            this.writeStoreHeader();
                            this.sync();
                            assert (this.validateFileLength("on close"));
                        }
                        this.state = 2;
                        this.clearCaches();
                        for (MVMap<?, ?> m : new ArrayList(this.maps.values())) {
                            m.close();
                        }
                        this.chunks.clear();
                        this.maps.clear();
                    }
                    finally {
                        if (this.fileStore == null || this.fileStoreIsProvided) continue;
                        this.fileStore.close();
                    }
                }
                finally {
                    this.state = 3;
                }
            }
            finally {
                this.storeLock.unlock();
            }
        }
    }

    private ByteBuffer readBufferForPage(long pos, int expectedMapId) {
        return this.getChunk(pos).readBufferForPage(this.fileStore, pos, expectedMapId);
    }

    private Chunk getChunk(long pos) {
        int chunkId = DataUtils.getPageChunkId(pos);
        Chunk c = this.chunks.get(chunkId);
        if (c == null) {
            this.checkOpen();
            String s = this.meta.get(Chunk.getMetaKey(chunkId));
            if (s == null) {
                throw DataUtils.newIllegalStateException(9, "Chunk {0} not found", chunkId);
            }
            c = Chunk.fromString(s);
            if (!c.isSaved()) {
                throw DataUtils.newIllegalStateException(6, "Chunk {0} is invalid", chunkId);
            }
            this.chunks.put(c.id, c);
        }
        return c;
    }

    private void setWriteVersion(long version) {
        Iterator<MVMap<?, ?>> iter = this.maps.values().iterator();
        while (iter.hasNext()) {
            MVMap<?, ?> map = iter.next();
            assert (map != this.meta);
            if (map.setWriteVersion(version) != null) continue;
            iter.remove();
        }
        this.meta.setWriteVersion(version);
        this.onVersionChange(version);
    }

    public long tryCommit() {
        if ((!this.storeLock.isHeldByCurrentThread() || this.currentStoreVersion < 0L) && this.storeLock.tryLock()) {
            try {
                this.store();
            }
            finally {
                this.storeLock.unlock();
            }
        }
        return this.currentVersion;
    }

    public long commit() {
        if (!this.storeLock.isHeldByCurrentThread() || this.currentStoreVersion < 0L) {
            this.storeLock.lock();
            try {
                this.store();
            }
            finally {
                this.storeLock.unlock();
            }
        }
        return this.currentVersion;
    }

    private void store() {
        this.store(0L, this.reuseSpace ? 0L : this.getAfterLastBlock());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void store(long reservedLow, long reservedHigh) {
        assert (this.storeLock.isHeldByCurrentThread());
        if (this.isOpenOrStopping() && this.hasUnsavedChanges()) {
            this.dropUnusedChunks();
            try {
                this.currentStoreVersion = this.currentVersion;
                if (this.fileStore == null) {
                    this.lastStoredVersion = this.currentVersion++;
                    this.setWriteVersion(this.currentVersion);
                    this.metaChanged = false;
                } else {
                    if (this.fileStore.isReadOnly()) {
                        throw DataUtils.newIllegalStateException(2, "This store is read-only", new Object[0]);
                    }
                    try {
                        this.storeNow(reservedLow, reservedHigh);
                    }
                    catch (IllegalStateException e) {
                        this.panic(e);
                    }
                    catch (Throwable e) {
                        this.panic(DataUtils.newIllegalStateException(3, "{0}", e.toString(), e));
                    }
                }
            }
            finally {
                this.currentStoreVersion = -1L;
            }
        }
    }

    private void storeNow(long reservedLow, long reservedHigh) {
        boolean storeAtEndOfFile;
        Chunk old;
        int lastChunkId;
        long time = this.getTimeSinceCreation();
        int currentUnsavedPageCount = this.unsavedMemory;
        long storeVersion = this.currentStoreVersion;
        long version = ++this.currentVersion;
        this.lastCommitTime = time;
        if (this.lastChunk == null) {
            lastChunkId = 0;
        } else {
            lastChunkId = this.lastChunk.id;
            this.meta.put(Chunk.getMetaKey(lastChunkId), this.lastChunk.asString());
            this.markMetaChanged();
            time = Math.max(this.lastChunk.time, time);
        }
        int newChunkId = lastChunkId;
        while ((old = this.chunks.get(newChunkId = newChunkId + 1 & 0x3FFFFFF)) != null) {
            if (old.isSaved()) continue;
            IllegalStateException e = DataUtils.newIllegalStateException(3, "Last block {0} not stored, possibly due to out-of-memory", old);
            this.panic(e);
        }
        Chunk c = new Chunk(newChunkId);
        c.pageCount = 0;
        c.pageCountLive = 0;
        c.maxLen = 0L;
        c.maxLenLive = 0L;
        c.metaRootPos = Long.MAX_VALUE;
        c.block = Long.MAX_VALUE;
        c.len = Integer.MAX_VALUE;
        c.time = time;
        c.version = version;
        c.next = Long.MAX_VALUE;
        this.chunks.put(c.id, c);
        ArrayList<Page> changed = new ArrayList<Page>();
        Iterator<MVMap<?, ?>> iter = this.maps.values().iterator();
        while (iter.hasNext()) {
            MVMap<?, ?> map = iter.next();
            RootReference rootReference = map.setWriteVersion(version);
            if (rootReference == null) {
                iter.remove();
                continue;
            }
            if (map.getCreateVersion() > storeVersion || map.isVolatile() || !map.hasChangesSince(this.lastStoredVersion)) continue;
            assert (rootReference.version <= version) : rootReference.version + " > " + version;
            Page rootPage = rootReference.root;
            if (rootPage.isSaved() && !rootPage.isLeaf()) continue;
            changed.add(rootPage);
        }
        WriteBuffer buff = this.getWriteBuffer();
        c.writeChunkHeader(buff, 0);
        int headerLength = buff.position() + 44;
        buff.position(headerLength);
        for (Page p : changed) {
            String key = MVMap.getMapRootKey(p.getMapId());
            if (p.getTotalCount() == 0L) {
                this.meta.remove(key);
                continue;
            }
            p.writeUnsavedRecursive(c, buff);
            long root = p.getPos();
            this.meta.put(key, Long.toHexString(root));
        }
        this.acceptChunkOccupancyChanges(time, version);
        RootReference metaRootReference = this.meta.setWriteVersion(version);
        assert (metaRootReference != null);
        assert (metaRootReference.version == version) : metaRootReference.version + " != " + version;
        this.metaChanged = false;
        this.acceptChunkOccupancyChanges(time, version);
        this.onVersionChange(version);
        Page metaRoot = metaRootReference.root;
        metaRoot.writeUnsavedRecursive(c, buff);
        c.mapId = this.lastMapId.get();
        int chunkLength = buff.position();
        int length = MathUtils.roundUpInt((int)(chunkLength + 128), (int)4096);
        buff.limit(length);
        long filePos = this.fileStore.allocate(length, reservedLow, reservedHigh);
        c.block = filePos / 4096L;
        c.len = length / 4096;
        assert (this.validateFileLength(c.asString()));
        c.metaRootPos = metaRoot.getPos();
        c.next = reservedLow > 0L || reservedHigh == reservedLow ? this.fileStore.predictAllocation(c.len, 0L, 0L) : 0L;
        assert (c.pageCountLive == c.pageCount) : c;
        buff.position(0);
        c.writeChunkHeader(buff, headerLength);
        buff.position(buff.limit() - 128);
        buff.put(c.getFooterBytes());
        buff.position(0);
        this.write(filePos, buff.getBuffer());
        this.releaseWriteBuffer(buff);
        boolean writeStoreHeader = false;
        boolean bl = storeAtEndOfFile = filePos + (long)length >= this.fileStore.size();
        if (!storeAtEndOfFile) {
            if (this.lastChunk == null) {
                writeStoreHeader = true;
            } else if (this.lastChunk.next != c.block) {
                writeStoreHeader = true;
            } else {
                long headerVersion = DataUtils.readHexLong(this.storeHeader, HDR_VERSION, 0L);
                if (this.lastChunk.version - headerVersion > 20L) {
                    writeStoreHeader = true;
                } else {
                    int chunkId = DataUtils.readHexInt(this.storeHeader, HDR_CHUNK, 0);
                    while (true) {
                        Chunk old2;
                        if ((old2 = this.chunks.get(chunkId)) == null) {
                            writeStoreHeader = true;
                            break;
                        }
                        if (chunkId == this.lastChunk.id) break;
                        ++chunkId;
                    }
                }
            }
        }
        if (this.storeHeader.remove(HDR_CLEAN) != null) {
            writeStoreHeader = true;
        }
        this.lastChunk = c;
        if (writeStoreHeader) {
            this.writeStoreHeader();
        }
        if (!storeAtEndOfFile) {
            this.shrinkFileIfPossible(1);
        }
        for (Page p : changed) {
            p.writeEnd();
        }
        metaRoot.writeEnd();
        this.saveNeeded = false;
        this.unsavedMemory = Math.max(0, this.unsavedMemory - currentUnsavedPageCount);
        this.lastStoredVersion = storeVersion;
    }

    private WriteBuffer getWriteBuffer() {
        WriteBuffer buff;
        if (this.writeBuffer != null) {
            buff = this.writeBuffer;
            buff.clear();
        } else {
            buff = new WriteBuffer();
        }
        return buff;
    }

    private void releaseWriteBuffer(WriteBuffer buff) {
        if (buff.capacity() <= 0x400000) {
            this.writeBuffer = buff;
        }
    }

    private static boolean canOverwriteChunk(Chunk c, long oldestVersionToKeep) {
        return !c.isLive() && c.unusedAtVersion < oldestVersionToKeep;
    }

    private boolean isSeasonedChunk(Chunk chunk, long time) {
        return this.retentionTime < 0 || chunk.time + (long)this.retentionTime <= time;
    }

    private long getTimeSinceCreation() {
        return Math.max(0L, this.getTimeAbsolute() - this.creationTime);
    }

    private long getTimeAbsolute() {
        long now = System.currentTimeMillis();
        if (this.lastTimeAbsolute != 0L && now < this.lastTimeAbsolute) {
            now = this.lastTimeAbsolute;
        } else {
            this.lastTimeAbsolute = now;
        }
        return now;
    }

    private void acceptChunkOccupancyChanges(long time, long version) {
        HashSet<Chunk> modifiedChunks = new HashSet<Chunk>();
        while (true) {
            RemovedPageInfo rpi;
            if ((rpi = this.removedPages.peek()) != null && rpi.version < version) {
                rpi = this.removedPages.poll();
                assert (rpi != null);
                assert (rpi.version < version) : rpi + " < " + version;
                int chunkId = rpi.getPageChunkId();
                Chunk chunk = this.chunks.get(chunkId);
                assert (chunk != null);
                modifiedChunks.add(chunk);
                if (!chunk.accountForRemovedPage(rpi.getPageLength(), rpi.isPinned(), time, rpi.version)) continue;
                this.deadChunks.offer(chunk);
                continue;
            }
            if (modifiedChunks.isEmpty()) {
                return;
            }
            for (Chunk chunk : modifiedChunks) {
                int chunkId = chunk.id;
                this.meta.put(Chunk.getMetaKey(chunkId), chunk.asString());
            }
            this.markMetaChanged();
            modifiedChunks.clear();
        }
    }

    private void shrinkFileIfPossible(int minPercent) {
        long fileSize;
        if (this.fileStore.isReadOnly()) {
            return;
        }
        long end = this.getFileLengthInUse();
        if (end >= (fileSize = this.fileStore.size())) {
            return;
        }
        if (minPercent > 0 && fileSize - end < 4096L) {
            return;
        }
        int savedPercent = (int)(100L - end * 100L / fileSize);
        if (savedPercent < minPercent) {
            return;
        }
        if (this.isOpenOrStopping()) {
            this.sync();
        }
        this.fileStore.truncate(end);
    }

    private long getFileLengthInUse() {
        long result = this.fileStore.getFileLengthInUse();
        assert (result == this.measureFileLengthInUse()) : result + " != " + this.measureFileLengthInUse();
        return result;
    }

    private long getAfterLastBlock() {
        return this.fileStore.getAfterLastBlock();
    }

    private long measureFileLengthInUse() {
        long size = 2L;
        for (Chunk c : this.chunks.values()) {
            if (!c.isSaved()) continue;
            size = Math.max(size, c.block + (long)c.len);
        }
        return size * 4096L;
    }

    public boolean hasUnsavedChanges() {
        if (this.metaChanged) {
            return true;
        }
        for (MVMap<?, ?> m : this.maps.values()) {
            if (m.isClosed() || !m.hasChangesSince(this.lastStoredVersion)) continue;
            return true;
        }
        return false;
    }

    private Chunk readChunkHeader(long block) {
        long p = block * 4096L;
        ByteBuffer buff = this.fileStore.readFully(p, 1024);
        return Chunk.readChunkHeader(buff, p);
    }

    private Chunk readChunkHeaderOptionally(long block) {
        try {
            Chunk chunk = this.readChunkHeader(block);
            return chunk.block != block ? null : chunk;
        }
        catch (Exception ignore) {
            return null;
        }
    }

    private Chunk readChunkHeaderOptionally(long block, int expectedId) {
        Chunk chunk = this.readChunkHeaderOptionally(block);
        return chunk == null || chunk.id != expectedId ? null : chunk;
    }

    public void compactMoveChunks() {
        this.compactMoveChunks(100, Long.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void compactMoveChunks(int targetFillRate, long moveSize) {
        block7: {
            this.storeLock.lock();
            try {
                this.checkOpen();
                if (this.lastChunk == null || !this.reuseSpace) break block7;
                int oldRetentionTime = this.retentionTime;
                boolean oldReuse = this.reuseSpace;
                try {
                    this.retentionTime = -1;
                    if (this.getFillRate() <= targetFillRate) {
                        this.compactMoveChunks(moveSize);
                    }
                }
                finally {
                    this.reuseSpace = oldReuse;
                    this.retentionTime = oldRetentionTime;
                }
            }
            finally {
                this.storeLock.unlock();
            }
        }
    }

    private boolean compactMoveChunks(long moveSize) {
        this.dropUnusedChunks();
        long start = this.fileStore.getFirstFree() / 4096L;
        Iterable<Chunk> chunksToMove = this.findChunksToMove(start, moveSize);
        if (chunksToMove == null) {
            return false;
        }
        this.compactMoveChunks(chunksToMove);
        return true;
    }

    private Iterable<Chunk> findChunksToMove(long startBlock, long moveSize) {
        long maxBlocksToMove = moveSize / 4096L;
        ArrayList<Chunk> result = null;
        if (maxBlocksToMove > 0L) {
            PriorityQueue<Chunk> queue = new PriorityQueue<Chunk>(this.chunks.size() / 2 + 1, new Comparator<Chunk>(){

                @Override
                public int compare(Chunk o1, Chunk o2) {
                    int res = Integer.compare(o2.collectPriority, o1.collectPriority);
                    if (res != 0) {
                        return res;
                    }
                    return Long.signum(o2.block - o1.block);
                }
            });
            long size = 0L;
            for (Chunk chunk : this.chunks.values()) {
                Chunk removed;
                if (!chunk.isSaved() || chunk.block <= startBlock) continue;
                chunk.collectPriority = this.getMovePriority(chunk);
                queue.offer(chunk);
                size += (long)chunk.len;
                while (size > maxBlocksToMove && (removed = queue.poll()) != null) {
                    size -= (long)removed.len;
                }
            }
            if (!queue.isEmpty()) {
                ArrayList<Chunk> list = new ArrayList<Chunk>(queue);
                Collections.sort(list, Chunk.PositionComparator.INSTANCE);
                result = list;
            }
        }
        return result;
    }

    private int getMovePriority(Chunk chunk) {
        return this.fileStore.getMovePriority((int)chunk.block);
    }

    private void compactMoveChunks(Iterable<Chunk> move) {
        assert (this.storeLock.isHeldByCurrentThread());
        if (move != null) {
            assert (this.lastChunk != null);
            this.writeStoreHeader();
            this.sync();
            Iterator<Chunk> iterator = move.iterator();
            assert (iterator.hasNext());
            long leftmostBlock = iterator.next().block;
            long originalBlockCount = this.getAfterLastBlock();
            for (Chunk chunk : move) {
                this.moveChunk(chunk, leftmostBlock, originalBlockCount);
            }
            this.store(leftmostBlock, originalBlockCount);
            this.sync();
            Chunk chunkToMove = this.lastChunk;
            long postEvacuationBlockCount = this.getAfterLastBlock();
            boolean chunkToMoveIsAlreadyInside = chunkToMove.block < leftmostBlock;
            boolean movedToEOF = !chunkToMoveIsAlreadyInside;
            for (Chunk c : move) {
                if (c.block < originalBlockCount || !this.moveChunk(c, originalBlockCount, postEvacuationBlockCount)) continue;
                assert (c.block < originalBlockCount);
                movedToEOF = true;
            }
            assert (postEvacuationBlockCount >= this.getAfterLastBlock());
            if (movedToEOF) {
                boolean moved = this.moveChunkInside(chunkToMove, originalBlockCount);
                this.store(originalBlockCount, postEvacuationBlockCount);
                this.sync();
                long lastBoundary = moved || chunkToMoveIsAlreadyInside ? postEvacuationBlockCount : chunkToMove.block;
                boolean bl = moved = !moved && this.moveChunkInside(chunkToMove, lastBoundary);
                if (this.moveChunkInside(this.lastChunk, lastBoundary) || moved) {
                    this.store(lastBoundary, -1L);
                }
            }
            this.shrinkFileIfPossible(0);
            this.sync();
        }
    }

    private boolean moveChunkInside(Chunk chunkToMove, long boundary) {
        boolean res;
        boolean bl = res = chunkToMove.block >= boundary && this.fileStore.predictAllocation(chunkToMove.len, boundary, -1L) < boundary && this.moveChunk(chunkToMove, boundary, -1L);
        assert (!res || chunkToMove.block + (long)chunkToMove.len <= boundary);
        return res;
    }

    private boolean moveChunk(Chunk chunk, long reservedAreaLow, long reservedAreaHigh) {
        if (!this.chunks.containsKey(chunk.id)) {
            return false;
        }
        WriteBuffer buff = this.getWriteBuffer();
        long start = chunk.block * 4096L;
        int length = chunk.len * 4096;
        buff.limit(length);
        ByteBuffer readBuff = this.fileStore.readFully(start, length);
        Chunk chunkFromFile = Chunk.readChunkHeader(readBuff, start);
        int chunkHeaderLen = readBuff.position();
        buff.position(chunkHeaderLen);
        buff.put(readBuff);
        long pos = this.fileStore.allocate(length, reservedAreaLow, reservedAreaHigh);
        long block = pos / 4096L;
        assert (reservedAreaHigh > 0L || block <= chunk.block) : block + " " + chunk;
        buff.position(0);
        chunkFromFile.block = block;
        chunkFromFile.next = 0L;
        chunkFromFile.writeChunkHeader(buff, chunkHeaderLen);
        buff.position(length - 128);
        buff.put(chunkFromFile.getFooterBytes());
        buff.position(0);
        this.write(pos, buff.getBuffer());
        this.releaseWriteBuffer(buff);
        this.fileStore.free(start, length);
        chunk.block = block;
        chunk.next = 0L;
        this.meta.put(Chunk.getMetaKey(chunk.id), chunk.asString());
        this.markMetaChanged();
        return true;
    }

    public void sync() {
        this.checkOpen();
        FileStore f = this.fileStore;
        if (f != null) {
            f.sync();
        }
    }

    public void compactFile(long maxCompactTime) {
        this.setRetentionTime(0);
        long start = System.nanoTime();
        while (this.compact(95, 0x1000000)) {
            this.sync();
            this.compactMoveChunks(95, 0x1000000L);
            long time = System.nanoTime() - start;
            if (time <= TimeUnit.MILLISECONDS.toNanos(maxCompactTime)) continue;
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean compact(int targetFillRate, int write) {
        block7: {
            if (this.reuseSpace && this.lastChunk != null) {
                this.checkOpen();
                if (targetFillRate > 0 && this.getChunksFillRate() < targetFillRate) {
                    if (!this.storeLock.tryLock(10L, TimeUnit.MILLISECONDS)) break block7;
                    try {
                        boolean bl = this.rewriteChunks(write);
                        this.storeLock.unlock();
                        return bl;
                    }
                    catch (Throwable throwable) {
                        try {
                            this.storeLock.unlock();
                            throw throwable;
                        }
                        catch (InterruptedException e) {
                            throw new RuntimeException(e);
                        }
                    }
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean rewriteChunks(int writeLimit) {
        TxCounter txCounter = this.registerVersionUsage();
        try {
            Iterable<Chunk> old = this.findOldChunks(writeLimit);
            if (old != null) {
                HashSet<Integer> idSet = MVStore.createIdSet(old);
                boolean bl = !idSet.isEmpty() && this.compactRewrite(idSet) > 0;
                return bl;
            }
        }
        finally {
            this.deregisterVersionUsage(txCounter);
        }
        return false;
    }

    public int getChunksFillRate() {
        long maxLengthSum = 1L;
        long maxLengthLiveSum = 1L;
        for (Chunk c : this.chunks.values()) {
            assert (c.maxLen >= 0L);
            maxLengthSum += c.maxLen;
            maxLengthLiveSum += c.maxLenLive;
        }
        int fillRate = (int)(100L * maxLengthLiveSum / maxLengthSum);
        return fillRate;
    }

    private int getProjectedFillRate() {
        int vacatedBlocks = 0;
        long maxLengthSum = 1L;
        long maxLengthLiveSum = 1L;
        long time = this.getTimeSinceCreation();
        for (Chunk c : this.chunks.values()) {
            assert (c.maxLen >= 0L);
            if (!this.isRewritable(c, time)) continue;
            assert (c.maxLenLive >= c.maxLenLive);
            vacatedBlocks += c.len;
            maxLengthSum += c.maxLen;
            maxLengthLiveSum += c.maxLenLive;
        }
        int additionalBlocks = (int)((long)vacatedBlocks * maxLengthLiveSum / maxLengthSum);
        int fillRate = this.fileStore.getProjectedFillRate(vacatedBlocks - additionalBlocks);
        return fillRate;
    }

    public int getFillRate() {
        return this.fileStore.getFillRate();
    }

    private Iterable<Chunk> findOldChunks(int writeLimit) {
        assert (this.lastChunk != null);
        long time = this.getTimeSinceCreation();
        PriorityQueue<Chunk> queue = new PriorityQueue<Chunk>(this.chunks.size() / 4 + 1, new Comparator<Chunk>(){

            @Override
            public int compare(Chunk o1, Chunk o2) {
                int comp = Integer.compare(o2.collectPriority, o1.collectPriority);
                if (comp == 0) {
                    comp = Long.compare(o2.maxLenLive, o2.maxLenLive);
                }
                return comp;
            }
        });
        long totalSize = 0L;
        long latestVersion = this.lastChunk.version + 1L;
        for (Chunk chunk : this.chunks.values()) {
            Chunk removed;
            if (!this.isRewritable(chunk, time)) continue;
            long age = latestVersion - chunk.version;
            chunk.collectPriority = (int)((long)(chunk.getFillRate() * 1000) / age);
            totalSize += chunk.maxLenLive;
            queue.offer(chunk);
            while (totalSize > (long)writeLimit && (removed = queue.poll()) != null) {
                totalSize -= removed.maxLenLive;
            }
        }
        return queue.isEmpty() ? null : queue;
    }

    private boolean isRewritable(Chunk chunk, long time) {
        return chunk.isRewritable() && this.isSeasonedChunk(chunk, time);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int compactRewrite(Set<Integer> set) {
        assert (this.storeLock.isHeldByCurrentThread());
        this.writeStoreHeader();
        this.sync();
        int rewrittenPageCount = 0;
        this.storeLock.unlock();
        try {
            for (MVMap<?, ?> map : this.maps.values()) {
                if (map.isClosed() || map.isSingleWriter()) continue;
                try {
                    rewrittenPageCount += map.rewrite(set);
                }
                catch (IllegalStateException ex) {
                    if (map.isClosed()) continue;
                    throw ex;
                }
            }
            int rewriteMetaCount = this.meta.rewrite(set);
            if (rewriteMetaCount > 0) {
                this.markMetaChanged();
                rewrittenPageCount += rewriteMetaCount;
            }
        }
        finally {
            this.storeLock.lock();
        }
        this.commit();
        assert (this.validateRewrite(set));
        return rewrittenPageCount;
    }

    private boolean validateRewrite(Set<Integer> set) {
        for (Integer chunkId : set) {
            Chunk chunk = this.chunks.get(chunkId);
            if (chunk == null || !chunk.isLive()) continue;
            int pageCountLive = chunk.pageCountLive;
            Object[] removedPageInfos = this.removedPages.toArray(new RemovedPageInfo[0]);
            for (RemovedPageInfo removedPageInfo : removedPageInfos) {
                if (removedPageInfo.getPageChunkId() != chunk.id) continue;
                --pageCountLive;
            }
            if (pageCountLive == 0) continue;
            for (String mapName : this.getMapNames()) {
                int mapId;
                if (mapName.startsWith("undoLog") || !this.hasData(mapName) || this.maps.containsKey(mapId = this.getMapId(mapName))) continue;
                return true;
            }
            assert (pageCountLive != 0) : chunk + " " + Arrays.toString(removedPageInfos);
        }
        return true;
    }

    private static HashSet<Integer> createIdSet(Iterable<Chunk> toCompact) {
        HashSet<Integer> set = new HashSet<Integer>();
        for (Chunk c : toCompact) {
            set.add(c.id);
        }
        return set;
    }

    Page readPage(MVMap<?, ?> map, long pos) {
        try {
            Page p;
            if (!DataUtils.isPageSaved(pos)) {
                throw DataUtils.newIllegalStateException(6, "Position 0", new Object[0]);
            }
            Page page = p = this.cache == null ? null : this.cache.get(pos);
            if (p == null) {
                ByteBuffer buff = this.readBufferForPage(pos, map.getId());
                try {
                    p = Page.read(buff, pos, map);
                }
                catch (Exception e) {
                    throw DataUtils.newIllegalStateException(6, "Unable to read the page at position {0}", pos, e);
                }
                this.cachePage(p);
            }
            return p;
        }
        catch (IllegalStateException e) {
            if (this.recoveryMode) {
                return map.createEmptyLeaf();
            }
            throw e;
        }
    }

    void accountForRemovedPage(long pos, long version, boolean pinned) {
        assert (DataUtils.isPageSaved(pos));
        RemovedPageInfo rpi = new RemovedPageInfo(pos, pinned, version);
        this.removedPages.add(rpi);
    }

    Compressor getCompressorFast() {
        if (this.compressorFast == null) {
            this.compressorFast = new CompressLZF();
        }
        return this.compressorFast;
    }

    Compressor getCompressorHigh() {
        if (this.compressorHigh == null) {
            this.compressorHigh = new CompressDeflate();
        }
        return this.compressorHigh;
    }

    int getCompressionLevel() {
        return this.compressionLevel;
    }

    public int getPageSplitSize() {
        return this.pageSplitSize;
    }

    public int getKeysPerPage() {
        return this.keysPerPage;
    }

    public long getMaxPageSize() {
        return this.cache == null ? Long.MAX_VALUE : this.cache.getMaxItemSize() >> 4;
    }

    public boolean getReuseSpace() {
        return this.reuseSpace;
    }

    public void setReuseSpace(boolean reuseSpace) {
        this.reuseSpace = reuseSpace;
    }

    public int getRetentionTime() {
        return this.retentionTime;
    }

    public void setRetentionTime(int ms) {
        this.retentionTime = ms;
    }

    public void setVersionsToKeep(int count) {
        this.versionsToKeep = count;
    }

    public long getVersionsToKeep() {
        return this.versionsToKeep;
    }

    long getOldestVersionToKeep() {
        long storeVersion;
        long v = this.oldestVersionToKeep.get();
        v = Math.max(v - (long)this.versionsToKeep, -1L);
        if (this.fileStore != null && (storeVersion = this.lastStoredVersion) != -1L && storeVersion < v) {
            v = storeVersion;
        }
        return v;
    }

    private void setOldestVersionToKeep(long oldestVersionToKeep) {
        long current;
        boolean success;
        while (!(success = oldestVersionToKeep <= (current = this.oldestVersionToKeep.get()) || this.oldestVersionToKeep.compareAndSet(current, oldestVersionToKeep))) {
        }
    }

    private boolean isKnownVersion(long version) {
        if (version > this.currentVersion || version < 0L) {
            return false;
        }
        if (version == this.currentVersion || this.chunks.isEmpty()) {
            return true;
        }
        Chunk c = this.getChunkForVersion(version);
        if (c == null) {
            return false;
        }
        MVMap<String, String> oldMeta = this.getMetaMap(version);
        try {
            String chunkKey;
            Iterator<String> it = oldMeta.keyIterator("chunk.");
            while (it.hasNext() && (chunkKey = it.next()).startsWith("chunk.")) {
                if (this.meta.containsKey(chunkKey)) continue;
                String s = oldMeta.get(chunkKey);
                Chunk c2 = Chunk.fromString(s);
                Chunk test = this.readChunkHeaderAndFooter(c2.block, c2.id);
                if (test != null) continue;
                return false;
            }
        }
        catch (IllegalStateException e) {
            return false;
        }
        return true;
    }

    public void registerUnsavedMemory(int memory) {
        this.unsavedMemory += memory;
        int newValue = this.unsavedMemory;
        if (newValue > this.autoCommitMemory && this.autoCommitMemory > 0) {
            this.saveNeeded = true;
        }
    }

    boolean isSaveNeeded() {
        return this.saveNeeded;
    }

    void beforeWrite(MVMap<?, ?> map) {
        if (this.saveNeeded && this.fileStore != null && this.isOpenOrStopping() && (this.storeLock.isHeldByCurrentThread() || !map.getRoot().isLockedByCurrentThread()) && map != this.meta) {
            this.saveNeeded = false;
            if (this.unsavedMemory > this.autoCommitMemory && this.autoCommitMemory > 0) {
                if (3 * this.unsavedMemory > 4 * this.autoCommitMemory && !map.isSingleWriter()) {
                    this.commit();
                } else {
                    this.tryCommit();
                }
            }
        }
    }

    public int getStoreVersion() {
        this.checkOpen();
        String x = this.meta.get("setting.storeVersion");
        return x == null ? 0 : DataUtils.parseHexInt(x);
    }

    public void setStoreVersion(int version) {
        this.storeLock.lock();
        try {
            this.checkOpen();
            this.markMetaChanged();
            this.meta.put("setting.storeVersion", Integer.toHexString(version));
        }
        finally {
            this.storeLock.unlock();
        }
    }

    public void rollback() {
        this.rollbackTo(this.currentVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollbackTo(long version) {
        this.storeLock.lock();
        try {
            TxCounter txCounter;
            this.checkOpen();
            if (version == 0L) {
                this.meta.setInitialRoot(this.meta.createEmptyLeaf(), -1L);
                this.deadChunks.clear();
                this.removedPages.clear();
                this.chunks.clear();
                this.clearCaches();
                if (this.fileStore != null) {
                    this.fileStore.clear();
                }
                this.lastChunk = null;
                this.versions.clear();
                this.currentVersion = version;
                this.setWriteVersion(version);
                this.metaChanged = false;
                this.lastStoredVersion = -1L;
                for (MVMap<?, ?> m : this.maps.values()) {
                    m.close();
                }
                return;
            }
            DataUtils.checkArgument(this.isKnownVersion(version), "Unknown version {0}", version);
            while ((txCounter = this.versions.peekLast()) != null && txCounter.version >= version) {
                this.versions.removeLast();
            }
            this.currentTxCounter = new TxCounter(version);
            this.meta.rollbackTo(version);
            this.metaChanged = false;
            ArrayList<Integer> remove = new ArrayList<Integer>();
            Chunk keep = null;
            for (Chunk chunk : this.chunks.values()) {
                if (chunk.version > version) {
                    remove.add(chunk.id);
                    continue;
                }
                if (keep != null && keep.version >= chunk.version) continue;
                keep = chunk;
            }
            if (!remove.isEmpty()) {
                Collections.sort(remove, Collections.reverseOrder());
                Iterator<Object> iterator = remove.iterator();
                while (iterator.hasNext()) {
                    int n = (Integer)((Object)iterator.next());
                    Chunk c = this.chunks.remove(n);
                    if (c == null) continue;
                    long start = c.block * 4096L;
                    int length = c.len * 4096;
                    this.freeFileSpace(start, length);
                    WriteBuffer buff = this.getWriteBuffer();
                    buff.limit(length);
                    Arrays.fill(buff.getBuffer().array(), (byte)0);
                    this.write(start, buff.getBuffer());
                    this.releaseWriteBuffer(buff);
                    this.sync();
                }
                this.lastChunk = keep;
                this.writeStoreHeader();
                this.readStoreHeader();
            }
            this.deadChunks.clear();
            this.removedPages.clear();
            this.clearCaches();
            this.currentVersion = version;
            if (this.lastStoredVersion == -1L) {
                this.lastStoredVersion = this.currentVersion - 1L;
            }
            for (MVMap mVMap : new ArrayList(this.maps.values())) {
                int id = mVMap.getId();
                if (mVMap.getCreateVersion() >= version) {
                    mVMap.close();
                    this.maps.remove(id);
                    continue;
                }
                if (mVMap.rollbackRoot(version)) continue;
                mVMap.setRootPos(MVStore.getRootPos(this.meta, id), version);
            }
        }
        finally {
            this.storeLock.unlock();
        }
    }

    private void clearCaches() {
        if (this.cache != null) {
            this.cache.clear();
        }
    }

    private static long getRootPos(MVMap<String, String> map, int mapId) {
        String root = map.get(MVMap.getMapRootKey(mapId));
        return root == null ? 0L : DataUtils.parseHexLong(root);
    }

    public long getCurrentVersion() {
        return this.currentVersion;
    }

    public FileStore getFileStore() {
        return this.fileStore;
    }

    public Map<String, Object> getStoreHeader() {
        return this.storeHeader;
    }

    private void checkOpen() {
        if (!this.isOpenOrStopping()) {
            throw DataUtils.newIllegalStateException(4, "This store is closed", this.panicException);
        }
    }

    public void renameMap(MVMap<?, ?> map, String newName) {
        this.checkOpen();
        DataUtils.checkArgument(map != this.meta, "Renaming the meta map is not allowed", new Object[0]);
        int id = map.getId();
        String oldName = this.getMapName(id);
        if (oldName != null && !oldName.equals(newName)) {
            String idHexStr = Integer.toHexString(id);
            String existingIdHexStr = this.meta.putIfAbsent("name." + newName, idHexStr);
            DataUtils.checkArgument(existingIdHexStr == null || existingIdHexStr.equals(idHexStr), "A map named {0} already exists", newName);
            this.meta.put(MVMap.getMapKey(id), map.asString(newName));
            this.meta.remove("name." + oldName);
            this.markMetaChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMap(MVMap<?, ?> map) {
        this.storeLock.lock();
        try {
            this.checkOpen();
            DataUtils.checkArgument(map != this.meta, "Removing the meta map is not allowed", new Object[0]);
            RootReference rootReference = map.clearIt();
            map.close();
            this.updateCounter += rootReference.updateCounter;
            this.updateAttemptCounter += rootReference.updateAttemptCounter;
            int id = map.getId();
            String name = this.getMapName(id);
            if (this.meta.remove(MVMap.getMapKey(id)) != null) {
                this.markMetaChanged();
            }
            if (this.meta.remove("name." + name) != null) {
                this.markMetaChanged();
            }
        }
        finally {
            this.storeLock.unlock();
        }
    }

    void deregisterMapRoot(int mapId) {
        if (this.meta.remove(MVMap.getMapRootKey(mapId)) != null) {
            this.markMetaChanged();
        }
    }

    public void removeMap(String name) {
        int id = this.getMapId(name);
        if (id > 0) {
            MVMap map = this.getMap(id);
            if (map == null) {
                map = this.openMap(name);
            }
            this.removeMap(map);
        }
    }

    public String getMapName(int id) {
        this.checkOpen();
        String m = this.meta.get(MVMap.getMapKey(id));
        return m == null ? null : DataUtils.getMapName(m);
    }

    private int getMapId(String name) {
        String m = this.meta.get("name." + name);
        return m == null ? -1 : DataUtils.parseHexInt(m);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeInBackground() {
        block21: {
            try {
                if (!this.isOpenOrStopping() || this.isReadOnly()) {
                    return;
                }
                long time = this.getTimeSinceCreation();
                if (time > this.lastCommitTime + (long)this.autoCommitDelay) {
                    this.tryCommit();
                    if (this.autoCompactFillRate < 0) {
                        this.compact(-this.getTargetFillRate(), this.autoCommitMemory);
                    }
                }
                if (this.isIdle()) {
                    this.doMaintenance(this.autoCompactFillRate);
                } else if (this.fileStore.isFragmented()) {
                    if (this.storeLock.tryLock(10L, TimeUnit.MILLISECONDS)) {
                        try {
                            this.compactMoveChunks(this.autoCommitMemory * 4);
                        }
                        finally {
                            this.storeLock.unlock();
                        }
                    }
                } else if (this.lastChunk != null) {
                    int projectedFillRate;
                    int targetFillRate = this.getTargetFillRate();
                    if (this.getFillRate() > targetFillRate && (projectedFillRate = this.getProjectedFillRate()) < targetFillRate && this.storeLock.tryLock(10L, TimeUnit.MILLISECONDS)) {
                        try {
                            int writeLimit = this.autoCommitMemory * targetFillRate / Math.max(projectedFillRate, 1);
                            if (this.rewriteChunks(writeLimit)) {
                                this.dropUnusedChunks();
                            }
                        }
                        finally {
                            this.storeLock.unlock();
                        }
                    }
                }
                this.autoCompactLastFileOpCount = this.fileStore.getWriteCount() + this.fileStore.getReadCount();
            }
            catch (InterruptedException time) {
            }
            catch (Throwable e) {
                this.handleException(e);
                if (this.backgroundExceptionHandler != null) break block21;
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doMaintenance(int targetFillRate) {
        if (this.autoCompactFillRate > 0 && this.lastChunk != null && this.reuseSpace) {
            try {
                int lastProjectedFillRate = -1;
                for (int cnt = 0; cnt < 5; ++cnt) {
                    int fillRate;
                    int projectedFillRate = fillRate = this.getFillRate();
                    if (fillRate > targetFillRate && ((projectedFillRate = this.getProjectedFillRate()) > targetFillRate || projectedFillRate <= lastProjectedFillRate)) break;
                    lastProjectedFillRate = projectedFillRate;
                    if (!this.storeLock.tryLock(10L, TimeUnit.MILLISECONDS)) break;
                    try {
                        int writeLimit = this.autoCommitMemory * targetFillRate / Math.max(projectedFillRate, 1);
                        if ((projectedFillRate >= fillRate || this.rewriteChunks(writeLimit) && this.dropUnusedChunks() != 0 || cnt <= 0) && this.compactMoveChunks(writeLimit)) continue;
                        break;
                    }
                    finally {
                        this.storeLock.unlock();
                    }
                }
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private int getTargetFillRate() {
        int targetRate = this.autoCompactFillRate;
        if (!this.isIdle()) {
            targetRate /= 3;
        }
        return targetRate;
    }

    private boolean isIdle() {
        return this.autoCompactLastFileOpCount == this.fileStore.getWriteCount() + this.fileStore.getReadCount();
    }

    private void handleException(Throwable ex) {
        block3: {
            if (this.backgroundExceptionHandler != null) {
                try {
                    this.backgroundExceptionHandler.uncaughtException(Thread.currentThread(), ex);
                }
                catch (Throwable ignore) {
                    if (ex == ignore) break block3;
                    ex.addSuppressed(ignore);
                }
            }
        }
    }

    public void setCacheSize(int mb) {
        long bytes = (long)mb * 1024L * 1024L;
        if (this.cache != null) {
            this.cache.setMaxMemory(bytes);
            this.cache.clear();
        }
    }

    private boolean isOpen() {
        return this.state == 0;
    }

    public boolean isClosed() {
        if (this.isOpen()) {
            return false;
        }
        this.storeLock.lock();
        try {
            assert (this.state == 3);
            boolean bl = true;
            return bl;
        }
        finally {
            this.storeLock.unlock();
        }
    }

    private boolean isOpenOrStopping() {
        return this.state <= 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopBackgroundThread(boolean waitForIt) {
        BackgroundWriterThread t;
        while ((t = this.backgroundWriterThread.get()) != null) {
            if (!this.backgroundWriterThread.compareAndSet(t, null)) continue;
            if (t == Thread.currentThread()) break;
            Object object = t.sync;
            synchronized (object) {
                t.sync.notifyAll();
            }
            if (!waitForIt) break;
            try {
                t.join();
            }
            catch (Exception exception) {}
            break;
        }
    }

    public void setAutoCommitDelay(int millis) {
        int sleep;
        BackgroundWriterThread t;
        if (this.autoCommitDelay == millis) {
            return;
        }
        this.autoCommitDelay = millis;
        if (this.fileStore == null || this.fileStore.isReadOnly()) {
            return;
        }
        this.stopBackgroundThread(true);
        if (millis > 0 && this.isOpen() && this.backgroundWriterThread.compareAndSet(null, t = new BackgroundWriterThread(this, sleep = Math.max(1, millis / 10), this.fileStore.toString()))) {
            t.start();
        }
    }

    public boolean isBackgroundThread() {
        return Thread.currentThread() == this.backgroundWriterThread.get();
    }

    public int getAutoCommitDelay() {
        return this.autoCommitDelay;
    }

    public int getAutoCommitMemory() {
        return this.autoCommitMemory;
    }

    public int getUnsavedMemory() {
        return this.unsavedMemory;
    }

    void cachePage(Page page) {
        if (this.cache != null) {
            this.cache.put(page.getPos(), page, page.getMemory());
        }
    }

    public int getCacheSizeUsed() {
        if (this.cache == null) {
            return 0;
        }
        return (int)(this.cache.getUsedMemory() >> 20);
    }

    public int getCacheSize() {
        if (this.cache == null) {
            return 0;
        }
        return (int)(this.cache.getMaxMemory() >> 20);
    }

    public CacheLongKeyLIRS<Page> getCache() {
        return this.cache;
    }

    public boolean isReadOnly() {
        return this.fileStore != null && this.fileStore.isReadOnly();
    }

    public int getCacheHitRatio() {
        if (this.cache == null) {
            return 0;
        }
        long hits = this.cache.getHits();
        return (int)(100L * hits / (hits + this.cache.getMisses() + 1L));
    }

    public double getUpdateFailureRatio() {
        long updateCounter = this.updateCounter;
        long updateAttemptCounter = this.updateAttemptCounter;
        RootReference rootReference = this.meta.getRoot();
        updateCounter += rootReference.updateCounter;
        updateAttemptCounter += rootReference.updateAttemptCounter;
        for (MVMap<?, ?> map : this.maps.values()) {
            RootReference root = map.getRoot();
            updateCounter += root.updateCounter;
            updateAttemptCounter += root.updateAttemptCounter;
        }
        return updateAttemptCounter == 0L ? 0.0 : 1.0 - (double)updateCounter / (double)updateAttemptCounter;
    }

    public TxCounter registerVersionUsage() {
        TxCounter txCounter;
        while ((txCounter = this.currentTxCounter).incrementAndGet() <= 0) {
            assert (txCounter != this.currentTxCounter) : txCounter;
            txCounter.decrementAndGet();
        }
        return txCounter;
    }

    public void deregisterVersionUsage(TxCounter txCounter) {
        if (txCounter != null && txCounter.decrementAndGet() <= 0) {
            if (this.storeLock.isHeldByCurrentThread()) {
                this.dropUnusedVersions();
            } else if (this.storeLock.tryLock()) {
                try {
                    this.dropUnusedVersions();
                }
                finally {
                    this.storeLock.unlock();
                }
            }
        }
    }

    private void onVersionChange(long version) {
        TxCounter txCounter = this.currentTxCounter;
        assert (txCounter.get() >= 0);
        this.versions.add(txCounter);
        this.currentTxCounter = new TxCounter(version);
        txCounter.decrementAndGet();
        this.dropUnusedVersions();
    }

    private void dropUnusedVersions() {
        TxCounter txCounter;
        assert (this.storeLock.isHeldByCurrentThread());
        while ((txCounter = this.versions.peek()) != null && txCounter.get() < 0) {
            this.versions.poll();
        }
        this.setOldestVersionToKeep((txCounter != null ? txCounter : this.currentTxCounter).version);
    }

    private int dropUnusedChunks() {
        assert (this.storeLock.isHeldByCurrentThread());
        int count = 0;
        if (!this.deadChunks.isEmpty()) {
            Chunk chunk;
            long oldestVersionToKeep = this.getOldestVersionToKeep();
            long time = this.getTimeSinceCreation();
            while ((chunk = this.deadChunks.poll()) != null && (this.isSeasonedChunk(chunk, time) && MVStore.canOverwriteChunk(chunk, oldestVersionToKeep) || !this.deadChunks.offerFirst(chunk))) {
                if (this.chunks.remove(chunk.id) == null) continue;
                if (this.meta.remove(Chunk.getMetaKey(chunk.id)) != null) {
                    this.markMetaChanged();
                }
                if (chunk.isSaved()) {
                    this.freeChunkSpace(chunk);
                }
                ++count;
            }
        }
        return count;
    }

    private void freeChunkSpace(Chunk chunk) {
        long start = chunk.block * 4096L;
        int length = chunk.len * 4096;
        this.freeFileSpace(start, length);
    }

    private void freeFileSpace(long start, int length) {
        this.fileStore.free(start, length);
        assert (this.validateFileLength(start + ":" + length));
    }

    private boolean validateFileLength(String msg) {
        assert (this.fileStore.getFileLengthInUse() == this.measureFileLengthInUse()) : this.fileStore.getFileLengthInUse() + " != " + this.measureFileLengthInUse() + " " + msg;
        return true;
    }

    public static final class Builder {
        private final HashMap<String, Object> config;

        private Builder(HashMap<String, Object> config) {
            this.config = config;
        }

        public Builder() {
            this.config = new HashMap();
        }

        private Builder set(String key, Object value) {
            this.config.put(key, value);
            return this;
        }

        public Builder autoCommitDisabled() {
            return this.set("autoCommitDelay", 0);
        }

        public Builder autoCommitBufferSize(int kb) {
            return this.set("autoCommitBufferSize", kb);
        }

        public Builder autoCompactFillRate(int percent) {
            return this.set("autoCompactFillRate", percent);
        }

        public Builder fileName(String fileName) {
            return this.set("fileName", fileName);
        }

        public Builder encryptionKey(char[] password) {
            return this.set("encryptionKey", password);
        }

        public Builder readOnly() {
            return this.set("readOnly", 1);
        }

        public Builder recoveryMode() {
            return this.set("recoveryMode", 1);
        }

        public Builder cacheSize(int mb) {
            return this.set("cacheSize", mb);
        }

        public Builder cacheConcurrency(int concurrency) {
            return this.set("cacheConcurrency", concurrency);
        }

        public Builder compress() {
            return this.set("compress", 1);
        }

        public Builder compressHigh() {
            return this.set("compress", 2);
        }

        public Builder pageSplitSize(int pageSplitSize) {
            return this.set("pageSplitSize", pageSplitSize);
        }

        public Builder backgroundExceptionHandler(Thread.UncaughtExceptionHandler exceptionHandler) {
            return this.set("backgroundExceptionHandler", exceptionHandler);
        }

        public Builder fileStore(FileStore store) {
            return this.set("fileStore", store);
        }

        public MVStore open() {
            return new MVStore(this.config);
        }

        public String toString() {
            return DataUtils.appendMap(new StringBuilder(), this.config).toString();
        }

        public static Builder fromString(String s) {
            return new Builder(DataUtils.parseMap(s));
        }
    }

    private static class RemovedPageInfo
    implements Comparable<RemovedPageInfo> {
        final long version;
        final int removedPageInfo;

        RemovedPageInfo(long pagePos, boolean pinned, long version) {
            this.removedPageInfo = RemovedPageInfo.createRemovedPageInfo(pagePos, pinned);
            this.version = version;
        }

        @Override
        public int compareTo(RemovedPageInfo other) {
            return Long.compare(this.version, other.version);
        }

        int getPageChunkId() {
            return this.removedPageInfo >>> 6;
        }

        int getPageLength() {
            return DataUtils.decodePageLength(this.removedPageInfo >> 1 & 0x1F);
        }

        boolean isPinned() {
            return (this.removedPageInfo & 1) == 1;
        }

        private static int createRemovedPageInfo(long pagePos, boolean isPinned) {
            int result = (int)(pagePos >>> 32) & 0xFFFFFFC0 | (int)pagePos & 0x3E;
            if (isPinned) {
                result |= 1;
            }
            return result;
        }

        public String toString() {
            return "RemovedPageInfo{version=" + this.version + ", chunk=" + this.getPageChunkId() + ", len=" + this.getPageLength() + (this.isPinned() ? ", pinned" : "") + "}";
        }
    }

    private static class BackgroundWriterThread
    extends Thread {
        public final Object sync = new Object();
        private final MVStore store;
        private final int sleep;

        BackgroundWriterThread(MVStore store, int sleep, String fileStoreName) {
            super("MVStore background writer " + fileStoreName);
            this.store = store;
            this.sleep = sleep;
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.store.isBackgroundThread()) {
                Object object = this.sync;
                synchronized (object) {
                    try {
                        this.sync.wait(this.sleep);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (!this.store.isBackgroundThread()) break;
                this.store.writeInBackground();
            }
        }
    }

    public static final class TxCounter {
        public final long version;
        private volatile int counter;
        private static final AtomicIntegerFieldUpdater<TxCounter> counterUpdater = AtomicIntegerFieldUpdater.newUpdater(TxCounter.class, "counter");

        TxCounter(long version) {
            this.version = version;
        }

        int get() {
            return this.counter;
        }

        int incrementAndGet() {
            return counterUpdater.incrementAndGet(this);
        }

        int decrementAndGet() {
            return counterUpdater.decrementAndGet(this);
        }

        public String toString() {
            return "v=" + this.version + " / cnt=" + this.counter;
        }
    }
}

