/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.mvstore.compat.v1.mvstore;

import org.dizitart.no2.mvstore.compat.v1.mvstore.Page;

public final class RootReference {
    public final Page root;
    public final long version;
    private final byte holdCount;
    private final long ownerId;
    volatile RootReference previous;
    final long updateCounter;
    final long updateAttemptCounter;
    private final byte appendCounter;

    RootReference(Page root, long version) {
        this.root = root;
        this.version = version;
        this.previous = null;
        this.updateCounter = 1L;
        this.updateAttemptCounter = 1L;
        this.holdCount = 0;
        this.ownerId = 0L;
        this.appendCounter = 0;
    }

    private RootReference(RootReference r, Page root, long updateAttemptCounter) {
        this.root = root;
        this.version = r.version;
        this.previous = r.previous;
        this.updateCounter = r.updateCounter + 1L;
        this.updateAttemptCounter = r.updateAttemptCounter + updateAttemptCounter;
        this.holdCount = 0;
        this.ownerId = 0L;
        this.appendCounter = r.appendCounter;
    }

    private RootReference(RootReference r, int attempt) {
        this.root = r.root;
        this.version = r.version;
        this.previous = r.previous;
        this.updateCounter = r.updateCounter + 1L;
        this.updateAttemptCounter = r.updateAttemptCounter + (long)attempt;
        assert (r.holdCount == 0 || r.ownerId == Thread.currentThread().getId()) : Thread.currentThread().getId() + " " + r;
        this.holdCount = (byte)(r.holdCount + 1);
        this.ownerId = Thread.currentThread().getId();
        this.appendCounter = r.appendCounter;
    }

    private RootReference(RootReference r, Page root, boolean keepLocked, int appendCounter) {
        this.root = root;
        this.version = r.version;
        this.previous = r.previous;
        this.updateCounter = r.updateCounter;
        this.updateAttemptCounter = r.updateAttemptCounter;
        assert (r.holdCount > 0 && r.ownerId == Thread.currentThread().getId()) : Thread.currentThread().getId() + " " + r;
        this.holdCount = (byte)(r.holdCount - (keepLocked ? (byte)0 : 1));
        this.ownerId = this.holdCount == 0 ? 0L : Thread.currentThread().getId();
        this.appendCounter = (byte)appendCounter;
    }

    private RootReference(RootReference r, long version, int attempt) {
        RootReference tmp;
        RootReference previous = r;
        while ((tmp = previous.previous) != null && tmp.root == r.root) {
            previous = tmp;
        }
        this.root = r.root;
        this.version = version;
        this.previous = previous;
        this.updateCounter = r.updateCounter + 1L;
        this.updateAttemptCounter = r.updateAttemptCounter + (long)attempt;
        this.holdCount = r.holdCount == 0 ? (byte)0 : (byte)(r.holdCount - 1);
        long l = this.ownerId = this.holdCount == 0 ? 0L : r.ownerId;
        assert (r.appendCounter == 0);
        this.appendCounter = 0;
    }

    RootReference updateRootPage(Page newRootPage, long attemptCounter) {
        RootReference updatedRootReference;
        if (this.holdCount == 0 && this.root.map.compareAndSetRoot(this, updatedRootReference = new RootReference(this, newRootPage, attemptCounter))) {
            return updatedRootReference;
        }
        return null;
    }

    RootReference tryLock(int attemptCounter) {
        RootReference lockedRootReference;
        if ((this.holdCount == 0 || this.ownerId == Thread.currentThread().getId()) && this.root.map.compareAndSetRoot(this, lockedRootReference = new RootReference(this, attemptCounter))) {
            return lockedRootReference;
        }
        return null;
    }

    RootReference tryUnlockAndUpdateVersion(long version, int attempt) {
        RootReference updatedRootReference;
        if ((this.holdCount == 0 || this.ownerId == Thread.currentThread().getId()) && this.root.map.compareAndSetRoot(this, updatedRootReference = new RootReference(this, version, attempt))) {
            return updatedRootReference;
        }
        return null;
    }

    RootReference updatePageAndLockedStatus(Page page, boolean keepLocked, int appendCounter) {
        assert (this.isLockedByCurrentThread()) : this;
        RootReference updatedRootReference = new RootReference(this, page, keepLocked, appendCounter);
        if (this.root.map.compareAndSetRoot(this, updatedRootReference)) {
            return updatedRootReference;
        }
        return null;
    }

    void removeUnusedOldVersions(long oldestVersionToKeep) {
        RootReference rootRef = this;
        while (rootRef != null) {
            if (rootRef.version < oldestVersionToKeep) {
                RootReference previous;
                assert ((previous = rootRef.previous) == null || previous.getAppendCounter() == 0) : oldestVersionToKeep + " " + rootRef.previous;
                rootRef.previous = null;
            }
            rootRef = rootRef.previous;
        }
    }

    boolean isLocked() {
        return this.holdCount != 0;
    }

    public boolean isLockedByCurrentThread() {
        return this.holdCount != 0 && this.ownerId == Thread.currentThread().getId();
    }

    long getVersion() {
        RootReference prev = this.previous;
        return prev == null || prev.root != this.root || prev.appendCounter != this.appendCounter ? this.version : prev.version;
    }

    boolean hasChangesSince(long version) {
        return (!this.root.isSaved() ? this.getTotalCount() > 0L : this.getAppendCounter() > 0) || this.getVersion() > version;
    }

    int getAppendCounter() {
        return this.appendCounter & 0xFF;
    }

    public boolean needFlush() {
        return this.appendCounter != 0;
    }

    public long getTotalCount() {
        return this.root.getTotalCount() + (long)this.getAppendCounter();
    }

    public String toString() {
        return "RootReference(" + System.identityHashCode(this.root) + ", v=" + this.version + ", owner=" + this.ownerId + (this.ownerId == Thread.currentThread().getId() ? "(current)" : "") + ", holdCnt=" + this.holdCount + ", keys=" + this.root.getTotalCount() + ", append=" + this.getAppendCounter() + ")";
    }
}

