/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.mvstore.compat.v1.mvstore.type;

import java.nio.ByteBuffer;
import org.dizitart.no2.mvstore.compat.v1.mvstore.DataUtils;
import org.dizitart.no2.mvstore.compat.v1.mvstore.WriteBuffer;
import org.dizitart.no2.mvstore.compat.v1.mvstore.type.DataType;

public class StringDataType
implements DataType {
    public static final StringDataType INSTANCE = new StringDataType();

    @Override
    public int compare(Object a, Object b) {
        return a.toString().compareTo(b.toString());
    }

    @Override
    public int getMemory(Object obj) {
        return 24 + 2 * obj.toString().length();
    }

    @Override
    public void read(ByteBuffer buff, Object[] obj, int len, boolean key) {
        for (int i = 0; i < len; ++i) {
            obj[i] = this.read(buff);
        }
    }

    @Override
    public void write(WriteBuffer buff, Object[] obj, int len, boolean key) {
        for (int i = 0; i < len; ++i) {
            this.write(buff, obj[i]);
        }
    }

    @Override
    public String read(ByteBuffer buff) {
        return DataUtils.readString(buff);
    }

    @Override
    public void write(WriteBuffer buff, Object obj) {
        String s = obj.toString();
        int len = s.length();
        buff.putVarInt(len).putStringData(s, len);
    }
}

