/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.objects.filters;

import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.dizitart.no2.Document;
import org.dizitart.no2.NitriteId;
import org.dizitart.no2.exceptions.ErrorMessage;
import org.dizitart.no2.exceptions.FilterException;
import org.dizitart.no2.objects.ObjectFilter;
import org.dizitart.no2.objects.filters.AndObjectFilter;
import org.dizitart.no2.objects.filters.BaseObjectFilter;
import org.dizitart.no2.objects.filters.EqualsObjectFilter;
import org.dizitart.no2.objects.filters.GreaterEqualObjectFilter;
import org.dizitart.no2.objects.filters.GreaterObjectFilter;
import org.dizitart.no2.objects.filters.InObjectFilter;
import org.dizitart.no2.objects.filters.LessThanObjectFilter;
import org.dizitart.no2.objects.filters.LesserEqualObjectFilter;
import org.dizitart.no2.objects.filters.NotInObjectFilter;
import org.dizitart.no2.objects.filters.NotObjectFilter;
import org.dizitart.no2.objects.filters.OrObjectFilter;
import org.dizitart.no2.objects.filters.RegexObjectFilter;
import org.dizitart.no2.objects.filters.TextObjectFilter;
import org.dizitart.no2.store.NitriteMap;
import org.dizitart.no2.util.DocumentUtils;
import org.dizitart.no2.util.EqualsUtils;
import org.dizitart.no2.util.NumberUtils;

class ElemMatchObjectFilter
extends BaseObjectFilter {
    private String field;
    private ObjectFilter elementFilter;

    ElemMatchObjectFilter(String field, ObjectFilter elementFilter) {
        this.field = field;
        this.elementFilter = elementFilter;
    }

    @Override
    public Set<NitriteId> apply(NitriteMap<NitriteId, Document> documentMap) {
        if (this.elementFilter instanceof ElemMatchObjectFilter) {
            throw new FilterException(ErrorMessage.NESTED_OBJ_ELEM_MATCH_NOT_SUPPORTED);
        }
        if (this.elementFilter instanceof TextObjectFilter) {
            throw new FilterException(ErrorMessage.FULL_TEXT_OBJ_ELEM_MATCH_NOT_SUPPORTED);
        }
        this.elementFilter.setNitriteService(this.nitriteService);
        this.elementFilter.setNitriteMapper(this.nitriteMapper);
        LinkedHashSet<NitriteId> nitriteIdSet = new LinkedHashSet<NitriteId>();
        for (Map.Entry<NitriteId, Document> entry : documentMap.entrySet()) {
            Document document = entry.getValue();
            Object fieldValue = DocumentUtils.getFieldValue(document, this.field);
            if (fieldValue == null) continue;
            if (fieldValue instanceof Iterable) {
                if (!this.matches((Iterable)fieldValue, this.elementFilter)) continue;
                nitriteIdSet.add(entry.getKey());
                continue;
            }
            throw new FilterException(ErrorMessage.OBJ_ELEM_MATCH_SUPPORTED_ON_ARRAY_ONLY);
        }
        return nitriteIdSet;
    }

    private boolean matches(Iterable iterable, ObjectFilter filter) {
        for (Object item : iterable) {
            if (!this.matchElement(item, filter)) continue;
            return true;
        }
        return false;
    }

    private boolean matchElement(Object item, ObjectFilter filter) {
        if (filter instanceof AndObjectFilter) {
            ObjectFilter[] filters;
            for (ObjectFilter f : filters = ((AndObjectFilter)filter).getFilters()) {
                if (this.matchElement(item, f)) continue;
                return false;
            }
            return true;
        }
        if (filter instanceof OrObjectFilter) {
            ObjectFilter[] filters;
            for (ObjectFilter f : filters = ((OrObjectFilter)filter).getFilters()) {
                if (!this.matchElement(item, f)) continue;
                return true;
            }
            return false;
        }
        if (filter instanceof NotObjectFilter) {
            ObjectFilter not = ((NotObjectFilter)filter).getFilter();
            return !this.matchElement(item, not);
        }
        if (filter instanceof EqualsObjectFilter) {
            return this.matchEqual(item, filter);
        }
        if (filter instanceof GreaterEqualObjectFilter) {
            return this.matchGreaterEqual(item, filter);
        }
        if (filter instanceof GreaterObjectFilter) {
            return this.matchGreater(item, filter);
        }
        if (filter instanceof LesserEqualObjectFilter) {
            return this.matchLesserEqual(item, filter);
        }
        if (filter instanceof LessThanObjectFilter) {
            return this.matchLesser(item, filter);
        }
        if (filter instanceof InObjectFilter) {
            return this.matchIn(item, filter);
        }
        if (filter instanceof NotInObjectFilter) {
            return this.matchNotIn(item, filter);
        }
        if (filter instanceof RegexObjectFilter) {
            return this.matchRegex(item, filter);
        }
        throw new FilterException(ErrorMessage.errorMessage("filter " + filter.getClass().getName() + " is not a supported in elemMatch", 4029));
    }

    private boolean matchEqual(Object item, ObjectFilter filter) {
        Object value = ((EqualsObjectFilter)filter).getValue();
        if (item instanceof Document) {
            Document document = (Document)item;
            Object docValue = DocumentUtils.getFieldValue(document, ((EqualsObjectFilter)filter).getField());
            return EqualsUtils.deepEquals(value, docValue);
        }
        return EqualsUtils.deepEquals(item, value);
    }

    private boolean matchGreater(Object item, ObjectFilter filter) {
        Object value = ((GreaterObjectFilter)filter).getValue();
        Comparable comparable = this.nitriteMapper.isValueType(value) ? (Comparable)this.nitriteMapper.asValue(value) : (Comparable)value;
        if (item instanceof Number && comparable instanceof Number) {
            return NumberUtils.compare((Number)item, (Number)((Object)comparable)) > 0;
        }
        if (item instanceof Comparable) {
            Comparable arg = (Comparable)item;
            return arg.compareTo(comparable) > 0;
        }
        if (item instanceof Document) {
            Document document = (Document)item;
            Object docValue = DocumentUtils.getFieldValue(document, ((GreaterObjectFilter)filter).getField());
            if (docValue instanceof Comparable) {
                Comparable arg = (Comparable)docValue;
                return arg.compareTo(comparable) > 0;
            }
            throw new FilterException(ErrorMessage.errorMessage(((GreaterObjectFilter)filter).getField() + " is not comparable", 4030));
        }
        throw new FilterException(ErrorMessage.errorMessage(item + " is not comparable", 4031));
    }

    private boolean matchGreaterEqual(Object item, ObjectFilter filter) {
        Object value = ((GreaterEqualObjectFilter)filter).getValue();
        Comparable comparable = this.nitriteMapper.isValueType(value) ? (Comparable)this.nitriteMapper.asValue(value) : (Comparable)value;
        if (item instanceof Number && comparable instanceof Number) {
            return NumberUtils.compare((Number)item, (Number)((Object)comparable)) >= 0;
        }
        if (item instanceof Comparable) {
            Comparable arg = (Comparable)item;
            return arg.compareTo(comparable) >= 0;
        }
        if (item instanceof Document) {
            Document document = (Document)item;
            Object docValue = DocumentUtils.getFieldValue(document, ((GreaterEqualObjectFilter)filter).getField());
            if (docValue instanceof Comparable) {
                Comparable arg = (Comparable)docValue;
                return arg.compareTo(comparable) >= 0;
            }
            throw new FilterException(ErrorMessage.errorMessage(((GreaterEqualObjectFilter)filter).getField() + " is not comparable", 4032));
        }
        throw new FilterException(ErrorMessage.errorMessage(item + " is not comparable", 4033));
    }

    private boolean matchLesserEqual(Object item, ObjectFilter filter) {
        Object value = ((LesserEqualObjectFilter)filter).getValue();
        Comparable comparable = this.nitriteMapper.isValueType(value) ? (Comparable)this.nitriteMapper.asValue(value) : (Comparable)value;
        if (item instanceof Number && comparable instanceof Number) {
            return NumberUtils.compare((Number)item, (Number)((Object)comparable)) <= 0;
        }
        if (item instanceof Comparable) {
            Comparable arg = (Comparable)item;
            return arg.compareTo(comparable) <= 0;
        }
        if (item instanceof Document) {
            Document document = (Document)item;
            Object docValue = DocumentUtils.getFieldValue(document, ((LesserEqualObjectFilter)filter).getField());
            if (docValue instanceof Comparable) {
                Comparable arg = (Comparable)docValue;
                return arg.compareTo(comparable) <= 0;
            }
            throw new FilterException(ErrorMessage.errorMessage(((LesserEqualObjectFilter)filter).getField() + " is not comparable", 4036));
        }
        throw new FilterException(ErrorMessage.errorMessage(item + " is not comparable", 4037));
    }

    private boolean matchLesser(Object item, ObjectFilter filter) {
        Object value = ((LessThanObjectFilter)filter).getValue();
        Comparable comparable = this.nitriteMapper.isValueType(value) ? (Comparable)this.nitriteMapper.asValue(value) : (Comparable)value;
        if (item instanceof Number && comparable instanceof Number) {
            return NumberUtils.compare((Number)item, (Number)((Object)comparable)) < 0;
        }
        if (item instanceof Comparable) {
            Comparable arg = (Comparable)item;
            return arg.compareTo(comparable) < 0;
        }
        if (item instanceof Document) {
            Document document = (Document)item;
            Object docValue = DocumentUtils.getFieldValue(document, ((LessThanObjectFilter)filter).getField());
            if (docValue instanceof Comparable) {
                Comparable arg = (Comparable)docValue;
                return arg.compareTo(comparable) < 0;
            }
            throw new FilterException(ErrorMessage.errorMessage(((LessThanObjectFilter)filter).getField() + " is not comparable", 4034));
        }
        throw new FilterException(ErrorMessage.errorMessage(item + " is not comparable", 4035));
    }

    private boolean matchIn(Object item, ObjectFilter filter) {
        HashSet values = new HashSet();
        Collections.addAll(values, ((InObjectFilter)filter).getValues());
        if (!values.isEmpty()) {
            if (item instanceof Document) {
                Document document = (Document)item;
                Object docValue = DocumentUtils.getFieldValue(document, ((InObjectFilter)filter).getField());
                return values.contains(docValue);
            }
            return values.contains(item);
        }
        return false;
    }

    private boolean matchNotIn(Object item, ObjectFilter filter) {
        HashSet values = new HashSet();
        Collections.addAll(values, ((NotInObjectFilter)filter).getValues());
        if (!values.isEmpty()) {
            if (item instanceof Document) {
                Document document = (Document)item;
                Object docValue = DocumentUtils.getFieldValue(document, ((NotInObjectFilter)filter).getField());
                return !values.contains(docValue);
            }
            return !values.contains(item);
        }
        return false;
    }

    private boolean matchRegex(Object item, ObjectFilter filter) {
        String value = ((RegexObjectFilter)filter).getValue();
        if (item instanceof String) {
            Pattern pattern = Pattern.compile(value);
            Matcher matcher = pattern.matcher((String)item);
            return matcher.find();
        }
        if (item instanceof Document) {
            Document document = (Document)item;
            Object docValue = DocumentUtils.getFieldValue(document, ((RegexObjectFilter)filter).getField());
            if (docValue instanceof String) {
                Pattern pattern = Pattern.compile(value);
                Matcher matcher = pattern.matcher((String)docValue);
                return matcher.find();
            }
            throw new FilterException(ErrorMessage.errorMessage(((RegexObjectFilter)filter).getField() + " is not a string", 4038));
        }
        throw new FilterException(ErrorMessage.errorMessage(item + " is not comparable", 4039));
    }

    public String toString() {
        return "ElemMatchObjectFilter(field=" + this.field + ", elementFilter=" + this.elementFilter + ")";
    }
}

