/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.objects.filters;

import org.dizitart.no2.exceptions.ErrorMessage;
import org.dizitart.no2.objects.ObjectFilter;
import org.dizitart.no2.objects.filters.AndObjectFilter;
import org.dizitart.no2.objects.filters.ElemMatchObjectFilter;
import org.dizitart.no2.objects.filters.EqualsObjectFilter;
import org.dizitart.no2.objects.filters.GreaterEqualObjectFilter;
import org.dizitart.no2.objects.filters.GreaterObjectFilter;
import org.dizitart.no2.objects.filters.InObjectFilter;
import org.dizitart.no2.objects.filters.LessThanObjectFilter;
import org.dizitart.no2.objects.filters.LesserEqualObjectFilter;
import org.dizitart.no2.objects.filters.NotInObjectFilter;
import org.dizitart.no2.objects.filters.NotObjectFilter;
import org.dizitart.no2.objects.filters.OrObjectFilter;
import org.dizitart.no2.objects.filters.RegexObjectFilter;
import org.dizitart.no2.objects.filters.TextObjectFilter;
import org.dizitart.no2.util.ValidationUtils;

public final class ObjectFilters {
    public static final ObjectFilter ALL = null;

    public static ObjectFilter and(ObjectFilter ... filters) {
        ValidationUtils.notNull(filters, ErrorMessage.errorMessage("filters can not be null", 1032));
        return new AndObjectFilter(filters);
    }

    public static ObjectFilter or(ObjectFilter ... filters) {
        ValidationUtils.notNull(filters, ErrorMessage.errorMessage("filters can not be null", 1033));
        return new OrObjectFilter(filters);
    }

    public static ObjectFilter not(ObjectFilter filter) {
        ValidationUtils.notNull(filter, ErrorMessage.errorMessage("filter can not be null", 1034));
        return new NotObjectFilter(filter);
    }

    public static ObjectFilter eq(String field, Object value) {
        return new EqualsObjectFilter(field, value);
    }

    public static ObjectFilter gt(String field, Object value) {
        return new GreaterObjectFilter(field, value);
    }

    public static ObjectFilter gte(String field, Object value) {
        return new GreaterEqualObjectFilter(field, value);
    }

    public static ObjectFilter lt(String field, Object value) {
        return new LessThanObjectFilter(field, value);
    }

    public static ObjectFilter lte(String field, Object value) {
        return new LesserEqualObjectFilter(field, value);
    }

    public static ObjectFilter text(String field, String value) {
        return new TextObjectFilter(field, value);
    }

    public static ObjectFilter regex(String field, String value) {
        return new RegexObjectFilter(field, value);
    }

    public static ObjectFilter in(String field, Object ... values) {
        return new InObjectFilter(field, values);
    }

    public static ObjectFilter notIn(String field, Object ... values) {
        return new NotInObjectFilter(field, values);
    }

    public static ObjectFilter elemMatch(String field, ObjectFilter filter) {
        return new ElemMatchObjectFilter(field, filter);
    }

    private ObjectFilters() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

