/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.sync;

import org.dizitart.no2.sync.ReplicationType;
import org.dizitart.no2.sync.SyncService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CollectionReplicator
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(CollectionReplicator.class);
    private boolean running;
    private boolean paused;
    private boolean stopped;
    private ReplicationType replicationType;
    private SyncService syncService;

    CollectionReplicator() {
    }

    @Override
    public void run() {
        try {
            if (this.stopped) {
                return;
            }
            String localName = this.syncService.getLocalCollection().getName();
            String remoteName = this.syncService.getSyncConfig().getSyncTemplate().getCollectionName();
            log.debug("Initiating synchronization sequence for [" + localName + " <-> " + remoteName + "]");
            if (this.running) {
                log.warn("Previous replicator is still running, aborting the recent run");
                return;
            }
            if (this.paused) {
                log.warn("Sync is currently paused");
                return;
            }
            this.running = true;
            switch (this.replicationType) {
                case PULL: {
                    this.syncService.pullChanges();
                    break;
                }
                case PUSH: {
                    this.syncService.pushChanges();
                    break;
                }
                case BOTH_WAY: {
                    this.syncService.mergeChanges();
                }
            }
            this.running = false;
        }
        catch (Throwable error) {
            log.error("Synchronization error", error);
        }
    }

    void pause() {
        this.paused = true;
    }

    void resume() {
        this.paused = false;
    }

    void stop() {
        this.stopped = true;
    }

    void setSyncService(SyncService syncService) {
        this.syncService = syncService;
    }

    void setReplicationType(ReplicationType replicationType) {
        this.replicationType = replicationType;
    }
}

