/*
 *
 * Copyright 2017-2018 Nitrite author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *        http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 */

package org.dizitart.no2.fulltext.languages;

import org.dizitart.no2.fulltext.Language;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

/**
 * Finnish stop words
 *
 * @since 2.1.0
 * @author Anindya Chatterjee
 */
public class Finnish implements Language {
    @Override
    public Set<String> stopWords() {
        return new HashSet<>(Arrays.asList(
                "aiemmin",
                "aika",
                "aikaa",
                "aikaan",
                "aikaisemmin",
                "aikaisin",
                "aikajen",
                "aikana",
                "aikoina",
                "aikoo",
                "aikovat",
                "aina",
                "ainakaan",
                "ainakin",
                "ainoa",
                "ainoat",
                "aiomme",
                "aion",
                "aiotte",
                "aist",
                "aivan",
                "ajan",
                "alas",
                "alemmas",
                "alkuisin",
                "alkuun",
                "alla",
                "alle",
                "aloitamme",
                "aloitan",
                "aloitat",
                "aloitatte",
                "aloitattivat",
                "aloitettava",
                "aloitettevaksi",
                "aloitettu",
                "aloitimme",
                "aloitin",
                "aloitit",
                "aloititte",
                "aloittaa",
                "aloittamatta",
                "aloitti",
                "aloittivat",
                "alta",
                "aluksi",
                "alussa",
                "alusta",
                "annettavaksi",
                "annetteva",
                "annettu",
                "ansiosta",
                "antaa",
                "antamatta",
                "antoi",
                "aoua",
                "apu",
                "asia",
                "asiaa",
                "asian",
                "asiasta",
                "asiat",
                "asioiden",
                "asioihin",
                "asioita",
                "asti",
                "avuksi",
                "avulla",
                "avun",
                "avutta",
                "edelle",
                "edelleen",
                "edellä",
                "edeltä",
                "edemmäs",
                "edes",
                "edessä",
                "edestä",
                "ehkä",
                "ei",
                "eikä",
                "eilen",
                "eivät",
                "eli",
                "ellei",
                "elleivät",
                "ellemme",
                "ellen",
                "ellet",
                "ellette",
                "emme",
                "en",
                "enemmän",
                "eniten",
                "ennen",
                "ensi",
                "ensimmäinen",
                "ensimmäiseksi",
                "ensimmäisen",
                "ensimmäisenä",
                "ensimmäiset",
                "ensimmäisiksi",
                "ensimmäisinä",
                "ensimmäisiä",
                "ensimmäistä",
                "ensin",
                "entinen",
                "entisen",
                "entisiä",
                "entisten",
                "entistä",
                "enää",
                "eri",
                "erittäin",
                "erityisesti",
                "eräiden",
                "eräs",
                "eräät",
                "esi",
                "esiin",
                "esillä",
                "esimerkiksi",
                "et",
                "eteen",
                "etenkin",
                "etessa",
                "ette",
                "ettei",
                "että",
                "haikki",
                "halua",
                "haluaa",
                "haluamatta",
                "haluamme",
                "haluan",
                "haluat",
                "haluatte",
                "haluavat",
                "halunnut",
                "halusi",
                "halusimme",
                "halusin",
                "halusit",
                "halusitte",
                "halusivat",
                "halutessa",
                "haluton",
                "he",
                "hei",
                "heidän",
                "heidät",
                "heihin",
                "heille",
                "heillä",
                "heiltä",
                "heissä",
                "heistä",
                "heitä",
                "helposti",
                "heti",
                "hetkellä",
                "hieman",
                "hitaasti",
                "hoikein",
                "huolimatta",
                "huomenna",
                "hyvien",
                "hyviin",
                "hyviksi",
                "hyville",
                "hyviltä",
                "hyvin",
                "hyvinä",
                "hyvissä",
                "hyvistä",
                "hyviä",
                "hyvä",
                "hyvät",
                "hyvää",
                "hän",
                "häneen",
                "hänelle",
                "hänellä",
                "häneltä",
                "hänen",
                "hänessä",
                "hänestä",
                "hänet",
                "häntä",
                "ihan",
                "ilman",
                "ilmeisesti",
                "itse",
                "itsensä",
                "itseään",
                "ja",
                "jo",
                "johon",
                "joiden",
                "joihin",
                "joiksi",
                "joilla",
                "joille",
                "joilta",
                "joina",
                "joissa",
                "joista",
                "joita",
                "joka",
                "jokainen",
                "jokin",
                "joko",
                "joksi",
                "joku",
                "jolla",
                "jolle",
                "jolloin",
                "jolta",
                "jompikumpi",
                "jona",
                "jonka",
                "jonkin",
                "jonne",
                "joo",
                "jopa",
                "jos",
                "joskus",
                "jossa",
                "josta",
                "jota",
                "jotain",
                "joten",
                "jotenkin",
                "jotenkuten",
                "jotka",
                "jotta",
                "jouduimme",
                "jouduin",
                "jouduit",
                "jouduitte",
                "joudumme",
                "joudun",
                "joudutte",
                "joukkoon",
                "joukossa",
                "joukosta",
                "joutua",
                "joutui",
                "joutuivat",
                "joutumaan",
                "joutuu",
                "joutuvat",
                "juuri",
                "jälkeen",
                "jälleen",
                "jää",
                "kahdeksan",
                "kahdeksannen",
                "kahdella",
                "kahdelle",
                "kahdelta",
                "kahden",
                "kahdessa",
                "kahdesta",
                "kahta",
                "kahteen",
                "kai",
                "kaiken",
                "kaikille",
                "kaikilta",
                "kaikkea",
                "kaikki",
                "kaikkia",
                "kaikkiaan",
                "kaikkialla",
                "kaikkialle",
                "kaikkialta",
                "kaikkien",
                "kaikkin",
                "kaksi",
                "kannalta",
                "kannattaa",
                "kanssa",
                "kanssaan",
                "kanssamme",
                "kanssani",
                "kanssanne",
                "kanssasi",
                "kauan",
                "kauemmas",
                "kaukana",
                "kautta",
                "kehen",
                "keiden",
                "keihin",
                "keiksi",
                "keille",
                "keillä",
                "keiltä",
                "keinä",
                "keissä",
                "keistä",
                "keitten",
                "keittä",
                "keitä",
                "keneen",
                "keneksi",
                "kenelle",
                "kenellä",
                "keneltä",
                "kenen",
                "kenenä",
                "kenessä",
                "kenestä",
                "kenet",
                "kenettä",
                "kennessästä",
                "kenties",
                "kerran",
                "kerta",
                "kertaa",
                "keskellä",
                "kesken",
                "keskimäärin",
                "ketkä",
                "ketä",
                "kiitos",
                "kohti",
                "koko",
                "kokonaan",
                "kolmas",
                "kolme",
                "kolmen",
                "kolmesti",
                "koska",
                "koskaan",
                "kovin",
                "kuin",
                "kuinka",
                "kuinkan",
                "kuitenkaan",
                "kuitenkin",
                "kuka",
                "kukaan",
                "kukin",
                "kukka",
                "kumpainen",
                "kumpainenkaan",
                "kumpi",
                "kumpikaan",
                "kumpikin",
                "kun",
                "kuten",
                "kuuden",
                "kuusi",
                "kuutta",
                "kylliksi",
                "kyllä",
                "kymmenen",
                "kyse",
                "liian",
                "liki",
                "lisäksi",
                "lisää",
                "lla",
                "luo",
                "luona",
                "lähekkäin",
                "lähelle",
                "lähellä",
                "läheltä",
                "lähemmäs",
                "lähes",
                "lähinnä",
                "lähtien",
                "läpi",
                "mahdollisimman",
                "mahdollista",
                "me",
                "meidän",
                "meidät",
                "meihin",
                "meille",
                "meillä",
                "meiltä",
                "meissä",
                "meistä",
                "meitä",
                "melkein",
                "melko",
                "menee",
                "meneet",
                "menemme",
                "menen",
                "menet",
                "menette",
                "menevät",
                "meni",
                "menimme",
                "menin",
                "menit",
                "menivät",
                "mennessä",
                "mennyt",
                "menossa",
                "mihin",
                "mikin",
                "miksi",
                "mikä",
                "mikäli",
                "mikään",
                "mille",
                "milloin",
                "milloinkan",
                "millä",
                "miltä",
                "minkä",
                "minne",
                "minua",
                "minulla",
                "minulle",
                "minulta",
                "minun",
                "minussa",
                "minusta",
                "minut",
                "minuun",
                "minä",
                "missä",
                "mistä",
                "miten",
                "mitkä",
                "mitä",
                "mitään",
                "moi",
                "molemmat",
                "mones",
                "monesti",
                "monet",
                "moni",
                "moniaalla",
                "moniaalle",
                "moniaalta",
                "monta",
                "muassa",
                "muiden",
                "muita",
                "muka",
                "mukaan",
                "mukaansa",
                "mukana",
                "mutta",
                "muu",
                "muualla",
                "muualle",
                "muualta",
                "muuanne",
                "muulloin",
                "muun",
                "muut",
                "muuta",
                "muutama",
                "muutaman",
                "muuten",
                "myöhemmin",
                "myös",
                "myöskin",
                "myöskään",
                "myötä",
                "ne",
                "neljä",
                "neljän",
                "neljää",
                "niiden",
                "niihin",
                "niiksi",
                "niille",
                "niillä",
                "niiltä",
                "niin",
                "niinä",
                "niissä",
                "niistä",
                "niitä",
                "noiden",
                "noihin",
                "noiksi",
                "noilla",
                "noille",
                "noilta",
                "noin",
                "noina",
                "noissa",
                "noista",
                "noita",
                "nopeammin",
                "nopeasti",
                "nopeiten",
                "nro",
                "nuo",
                "nyt",
                "näiden",
                "näihin",
                "näiksi",
                "näille",
                "näillä",
                "näiltä",
                "näin",
                "näinä",
                "näissä",
                "näissähin",
                "näissälle",
                "näissältä",
                "näissästä",
                "näistä",
                "näitä",
                "nämä",
                "ohi",
                "oikea",
                "oikealla",
                "oikein",
                "ole",
                "olemme",
                "olen",
                "olet",
                "olette",
                "oleva",
                "olevan",
                "olevat",
                "oli",
                "olimme",
                "olin",
                "olisi",
                "olisimme",
                "olisin",
                "olisit",
                "olisitte",
                "olisivat",
                "olit",
                "olitte",
                "olivat",
                "olla",
                "olleet",
                "olli",
                "ollut",
                "oma",
                "omaa",
                "omaan",
                "omaksi",
                "omalle",
                "omalta",
                "oman",
                "omassa",
                "omat",
                "omia",
                "omien",
                "omiin",
                "omiksi",
                "omille",
                "omilta",
                "omissa",
                "omista",
                "on",
                "onkin",
                "onko",
                "ovat",
                "paikoittain",
                "paitsi",
                "pakosti",
                "paljon",
                "paremmin",
                "parempi",
                "parhaillaan",
                "parhaiten",
                "perusteella",
                "peräti",
                "pian",
                "pieneen",
                "pieneksi",
                "pienelle",
                "pienellä",
                "pieneltä",
                "pienempi",
                "pienestä",
                "pieni",
                "pienin",
                "poikki",
                "puolesta",
                "puolestaan",
                "päälle",
                "runsaasti",
                "saakka",
                "sadam",
                "sama",
                "samaa",
                "samaan",
                "samalla",
                "samallalta",
                "samallassa",
                "samallasta",
                "saman",
                "samat",
                "samoin",
                "sata",
                "sataa",
                "satojen",
                "se",
                "seitsemän",
                "sekä",
                "sen",
                "seuraavat",
                "siellä",
                "sieltä",
                "siihen",
                "siinä",
                "siis",
                "siitä",
                "sijaan",
                "siksi",
                "sille",
                "silloin",
                "sillä",
                "silti",
                "siltä",
                "sinne",
                "sinua",
                "sinulla",
                "sinulle",
                "sinulta",
                "sinun",
                "sinussa",
                "sinusta",
                "sinut",
                "sinuun",
                "sinä",
                "sisäkkäin",
                "sisällä",
                "siten",
                "sitten",
                "sitä",
                "ssa",
                "sta",
                "suoraan",
                "suuntaan",
                "suuren",
                "suuret",
                "suuri",
                "suuria",
                "suurin",
                "suurten",
                "taa",
                "taas",
                "taemmas",
                "tahansa",
                "tai",
                "takaa",
                "takaisin",
                "takana",
                "takia",
                "tallä",
                "tapauksessa",
                "tarpeeksi",
                "tavalla",
                "tavoitteena",
                "te",
                "teidän",
                "teidät",
                "teihin",
                "teille",
                "teillä",
                "teiltä",
                "teissä",
                "teistä",
                "teitä",
                "tietysti",
                "todella",
                "toinen",
                "toisaalla",
                "toisaalle",
                "toisaalta",
                "toiseen",
                "toiseksi",
                "toisella",
                "toiselle",
                "toiselta",
                "toisemme",
                "toisen",
                "toisensa",
                "toisessa",
                "toisesta",
                "toista",
                "toistaiseksi",
                "toki",
                "tosin",
                "tuhannen",
                "tuhat",
                "tule",
                "tulee",
                "tulemme",
                "tulen",
                "tulet",
                "tulette",
                "tulevat",
                "tulimme",
                "tulin",
                "tulisi",
                "tulisimme",
                "tulisin",
                "tulisit",
                "tulisitte",
                "tulisivat",
                "tulit",
                "tulitte",
                "tulivat",
                "tulla",
                "tulleet",
                "tullut",
                "tuntuu",
                "tuo",
                "tuohon",
                "tuoksi",
                "tuolla",
                "tuolle",
                "tuolloin",
                "tuolta",
                "tuon",
                "tuona",
                "tuonne",
                "tuossa",
                "tuosta",
                "tuota",
                "tuotä",
                "tuskin",
                "tykö",
                "tähän",
                "täksi",
                "tälle",
                "tällä",
                "tällöin",
                "tältä",
                "tämä",
                "tämän",
                "tänne",
                "tänä",
                "tänään",
                "tässä",
                "tästä",
                "täten",
                "tätä",
                "täysin",
                "täytyvät",
                "täytyy",
                "täällä",
                "täältä",
                "ulkopuolella",
                "usea",
                "useasti",
                "useimmiten",
                "usein",
                "useita",
                "uudeksi",
                "uudelleen",
                "uuden",
                "uudet",
                "uusi",
                "uusia",
                "uusien",
                "uusinta",
                "uuteen",
                "uutta",
                "vaan",
                "vahemmän",
                "vai",
                "vaiheessa",
                "vaikea",
                "vaikean",
                "vaikeat",
                "vaikeilla",
                "vaikeille",
                "vaikeilta",
                "vaikeissa",
                "vaikeista",
                "vaikka",
                "vain",
                "varmasti",
                "varsin",
                "varsinkin",
                "varten",
                "vasen",
                "vasenmalla",
                "vasta",
                "vastaan",
                "vastakkain",
                "vastan",
                "verran",
                "vielä",
                "vierekkäin",
                "vieressä",
                "vieri",
                "viiden",
                "viime",
                "viimeinen",
                "viimeisen",
                "viimeksi",
                "viisi",
                "voi",
                "voidaan",
                "voimme",
                "voin",
                "voisi",
                "voit",
                "voitte",
                "voivat",
                "vuoden",
                "vuoksi",
                "vuosi",
                "vuosien",
                "vuosina",
                "vuotta",
                "vähemmän",
                "vähintään",
                "vähiten",
                "vähän",
                "välillä",
                "yhdeksän",
                "yhden",
                "yhdessä",
                "yhteen",
                "yhteensä",
                "yhteydessä",
                "yhteyteen",
                "yhtä",
                "yhtäälle",
                "yhtäällä",
                "yhtäältä",
                "yhtään",
                "yhä",
                "yksi",
                "yksin",
                "yksittäin",
                "yleensä",
                "ylemmäs",
                "yli",
                "ylös",
                "ympäri",
                "älköön",
                "älä"
        ));
    }
}
