/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.filters;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import org.dizitart.no2.Document;
import org.dizitart.no2.Filter;
import org.dizitart.no2.NitriteId;
import org.dizitart.no2.internals.NitriteService;
import org.dizitart.no2.store.NitriteMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(BaseFilter.class);
    protected NitriteService nitriteService;

    @Override
    public void setNitriteService(NitriteService nitriteService) {
        this.nitriteService = nitriteService;
    }

    List<Callable<Set<NitriteId>>> createTasks(Filter[] filters, final NitriteMap<NitriteId, Document> documentMap) {
        ArrayList<Callable<Set<NitriteId>>> tasks = new ArrayList<Callable<Set<NitriteId>>>();
        for (final Filter filter : filters) {
            filter.setNitriteService(this.nitriteService);
            tasks.add(new Callable<Set<NitriteId>>(){

                @Override
                public Set<NitriteId> call() throws Exception {
                    try {
                        return filter.apply(documentMap);
                    }
                    catch (Exception e) {
                        log.error("Error while executing filter " + filter.toString(), (Throwable)e);
                        throw e;
                    }
                }
            });
        }
        return tasks;
    }
}

