/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.sync.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dizitart.no2.Document;
import org.dizitart.no2.event.ChangeType;

public class ChangeFeed
implements Serializable {
    private static final long serialVersionUID = 1486043678L;
    private String originator;
    private Long sequenceNumber;
    private Map<ChangeType, List<Document>> changeBucket = new HashMap<ChangeType, List<Document>>();

    public List<Document> getModifiedDocuments() {
        return this.changeBucket.get((Object)ChangeType.UPDATE);
    }

    public List<Document> getRemovedDocuments() {
        return this.changeBucket.get((Object)ChangeType.REMOVE);
    }

    public void setModifiedDocuments(List<Document> documents) {
        List<Document> documentList = this.changeBucket.get((Object)ChangeType.UPDATE);
        if (documentList == null) {
            documentList = new ArrayList<Document>();
        }
        if (documents != null) {
            documentList.addAll(documents);
        }
        this.changeBucket.put(ChangeType.UPDATE, documentList);
    }

    public void setRemovedDocuments(List<Document> documents) {
        List<Document> documentList = this.changeBucket.get((Object)ChangeType.REMOVE);
        if (documentList == null) {
            documentList = new ArrayList<Document>();
        }
        if (documents != null) {
            documentList.addAll(documents);
        }
        this.changeBucket.put(ChangeType.REMOVE, documentList);
    }

    public String toString() {
        return "ChangeFeed(originator=" + this.getOriginator() + ", sequenceNumber=" + this.getSequenceNumber() + ", changeBucket=" + this.changeBucket + ")";
    }

    public String getOriginator() {
        return this.originator;
    }

    public void setOriginator(String originator) {
        this.originator = originator;
    }

    public Long getSequenceNumber() {
        return this.sequenceNumber;
    }

    public void setSequenceNumber(Long sequenceNumber) {
        this.sequenceNumber = sequenceNumber;
    }
}

