/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.tool;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Map;
import org.dizitart.no2.Document;
import org.dizitart.no2.Index;
import org.dizitart.no2.IndexOptions;
import org.dizitart.no2.Nitrite;
import org.dizitart.no2.NitriteCollection;
import org.dizitart.no2.PersistentCollection;
import org.dizitart.no2.objects.ObjectRepository;

class NitriteJsonImporter {
    private JsonParser parser;
    private Nitrite db;

    public NitriteJsonImporter(Nitrite db) {
        this.db = db;
    }

    public void setParser(JsonParser parser) {
        this.parser = parser;
    }

    public void importData() throws IOException, ClassNotFoundException {
        while (this.parser.nextToken() != JsonToken.END_OBJECT) {
            String fieldName = this.parser.getCurrentName();
            if ("collections".equals(fieldName)) {
                this.readCollection();
            }
            if (!"repositories".equals(fieldName)) continue;
            this.readRepository();
        }
    }

    private void readRepository() throws IOException, ClassNotFoundException {
        ObjectRepository<?> repository = null;
        this.parser.nextToken();
        while (this.parser.nextToken() != JsonToken.END_ARRAY) {
            while (this.parser.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = this.parser.getCurrentName();
                if ("type".equals(fieldName)) {
                    this.parser.nextToken();
                    String typeId = this.parser.getText();
                    Class<?> type = Class.forName(typeId);
                    repository = this.db.getRepository(type);
                }
                if ("indices".equals(fieldName)) {
                    this.readIndices(repository);
                }
                if (!"data".equals(fieldName) || repository == null) continue;
                this.readCollectionData(repository.getDocumentCollection());
            }
        }
    }

    private void readCollection() throws IOException {
        NitriteCollection collection = null;
        this.parser.nextToken();
        while (this.parser.nextToken() != JsonToken.END_ARRAY) {
            while (this.parser.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = this.parser.getCurrentName();
                if ("name".equals(fieldName)) {
                    this.parser.nextToken();
                    String collectionName = this.parser.getText();
                    collection = this.db.getCollection(collectionName);
                }
                if ("indices".equals(fieldName)) {
                    this.readIndices(collection);
                }
                if (!"data".equals(fieldName)) continue;
                this.readCollectionData(collection);
            }
        }
    }

    private void readIndices(PersistentCollection<?> collection) throws IOException {
        this.parser.nextToken();
        while (this.parser.nextToken() != JsonToken.END_ARRAY) {
            while (this.parser.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = this.parser.getCurrentName();
                if (!"index".equals(fieldName)) continue;
                this.parser.nextToken();
                Index index = (Index)this.parser.readValueAs(Index.class);
                if (collection == null || index == null || index.getField() == null || collection.hasIndex(index.getField())) continue;
                collection.createIndex(index.getField(), IndexOptions.indexOptions(index.getIndexType()));
            }
        }
    }

    private void readCollectionData(NitriteCollection collection) throws IOException {
        this.parser.nextToken();
        while (this.parser.nextToken() != JsonToken.END_ARRAY) {
            Long id = null;
            Map objectMap = null;
            while (this.parser.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = this.parser.getCurrentName();
                if ("key".equals(fieldName)) {
                    this.parser.nextToken();
                    id = (Long)this.parser.readValueAs(Long.class);
                }
                if ("value".equals(fieldName)) {
                    this.parser.nextToken();
                    objectMap = (Map)this.parser.readValueAs(Map.class);
                    objectMap.put("_id", id);
                }
                if (objectMap == null) continue;
                Document document = new Document(objectMap);
                if (collection == null) continue;
                collection.insert(document, new Document[0]);
            }
        }
    }
}

