/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2;

import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.dizitart.no2.Nitrite;
import org.dizitart.no2.NitriteConfig;
import org.dizitart.no2.collection.CollectionFactory;
import org.dizitart.no2.collection.Document;
import org.dizitart.no2.collection.NitriteCollection;
import org.dizitart.no2.common.Constants;
import org.dizitart.no2.common.concurrent.LockService;
import org.dizitart.no2.common.util.ObjectUtils;
import org.dizitart.no2.common.util.StringUtils;
import org.dizitart.no2.exceptions.NitriteException;
import org.dizitart.no2.exceptions.NitriteIOException;
import org.dizitart.no2.exceptions.NitriteSecurityException;
import org.dizitart.no2.migration.MigrationManager;
import org.dizitart.no2.repository.EntityDecorator;
import org.dizitart.no2.repository.ObjectRepository;
import org.dizitart.no2.repository.RepositoryFactory;
import org.dizitart.no2.store.NitriteMap;
import org.dizitart.no2.store.NitriteStore;
import org.dizitart.no2.store.StoreMetaData;
import org.dizitart.no2.store.UserAuthenticationService;
import org.dizitart.no2.transaction.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NitriteDatabase
implements Nitrite {
    @Generated
    private static final Logger log = LoggerFactory.getLogger((String)"nitrite");
    private final CollectionFactory collectionFactory;
    private final RepositoryFactory repositoryFactory;
    private final NitriteConfig nitriteConfig;
    private final LockService lockService;
    private NitriteMap<String, Document> storeInfo;
    private NitriteStore<?> store;

    NitriteDatabase(NitriteConfig config) {
        this.nitriteConfig = config;
        this.lockService = new LockService();
        this.collectionFactory = new CollectionFactory(this.lockService);
        this.repositoryFactory = new RepositoryFactory(this.collectionFactory);
    }

    @Override
    public NitriteCollection getCollection(String name) {
        this.validateCollectionName(name);
        this.checkOpened();
        return this.collectionFactory.getCollection(name, this.nitriteConfig, true);
    }

    @Override
    public <T> ObjectRepository<T> getRepository(Class<T> type) {
        this.checkOpened();
        return this.repositoryFactory.getRepository(this.nitriteConfig, type);
    }

    @Override
    public <T> ObjectRepository<T> getRepository(Class<T> type, String key) {
        this.checkOpened();
        return this.repositoryFactory.getRepository(this.nitriteConfig, type, key);
    }

    @Override
    public <T> ObjectRepository<T> getRepository(EntityDecorator<T> entityDecorator) {
        this.checkOpened();
        return this.repositoryFactory.getRepository(this.nitriteConfig, entityDecorator);
    }

    @Override
    public <T> ObjectRepository<T> getRepository(EntityDecorator<T> entityDecorator, String key) {
        this.checkOpened();
        return this.repositoryFactory.getRepository(this.nitriteConfig, entityDecorator, key);
    }

    @Override
    public void destroyCollection(String name) {
        this.checkOpened();
        this.store.removeMap(name);
    }

    @Override
    public <T> void destroyRepository(Class<T> type) {
        this.checkOpened();
        String mapName = ObjectUtils.findRepositoryName(type, null);
        this.store.removeMap(mapName);
    }

    @Override
    public <T> void destroyRepository(Class<T> type, String key) {
        this.checkOpened();
        String mapName = ObjectUtils.findRepositoryName(type, key);
        this.store.removeMap(mapName);
    }

    @Override
    public <T> void destroyRepository(EntityDecorator<T> type) {
        this.checkOpened();
        String mapName = ObjectUtils.findRepositoryNameByDecorator(type, null);
        this.store.removeMap(mapName);
    }

    @Override
    public <T> void destroyRepository(EntityDecorator<T> type, String key) {
        this.checkOpened();
        String mapName = ObjectUtils.findRepositoryNameByDecorator(type, key);
        this.store.removeMap(mapName);
    }

    @Override
    public Set<String> listCollectionNames() {
        this.checkOpened();
        return this.store.getCollectionNames();
    }

    @Override
    public Set<String> listRepositories() {
        this.checkOpened();
        return this.store.getRepositoryRegistry();
    }

    @Override
    public Map<String, Set<String>> listKeyedRepositories() {
        this.checkOpened();
        return this.store.getKeyedRepositoryRegistry();
    }

    @Override
    public boolean hasUnsavedChanges() {
        this.checkOpened();
        return this.store != null && this.store.hasUnsavedChanges();
    }

    @Override
    public boolean isClosed() {
        return this.store == null || this.store.isClosed();
    }

    @Override
    public NitriteStore<?> getStore() {
        return this.store;
    }

    @Override
    public NitriteConfig getConfig() {
        return this.nitriteConfig;
    }

    @Override
    public synchronized void close() {
        this.checkOpened();
        try {
            this.store.beforeClose();
            if (this.hasUnsavedChanges()) {
                log.debug("Unsaved changes detected, committing the changes.");
                this.commit();
            }
            this.repositoryFactory.clear();
            this.collectionFactory.clear();
            this.storeInfo.close();
            if (this.nitriteConfig != null) {
                this.nitriteConfig.close();
            }
            log.info("Nitrite database has been closed successfully.");
        }
        catch (NitriteIOException e) {
            throw e;
        }
        catch (Throwable error) {
            throw new NitriteIOException("Error occurred while closing the database", error);
        }
    }

    @Override
    public void commit() {
        this.checkOpened();
        if (this.store != null) {
            try {
                this.store.commit();
            }
            catch (Exception e) {
                throw new NitriteIOException("Error occurred while committing the database", e);
            }
            log.debug("Unsaved changes has been committed successfully.");
        }
    }

    @Override
    public StoreMetaData getDatabaseMetaData() {
        Document document = this.storeInfo.get("$nitrite_store_info");
        if (document == null) {
            this.prepareDatabaseMetaData();
            document = this.storeInfo.get("$nitrite_store_info");
        }
        return new StoreMetaData(document);
    }

    @Override
    public Session createSession() {
        return new Session(this, this.lockService);
    }

    public void initialize(String username, String password) {
        this.validateUserCredentials(username, password);
        try {
            this.nitriteConfig.initialize();
            this.store = this.nitriteConfig.getNitriteStore();
            this.store.openOrCreate();
            this.prepareDatabaseMetaData();
            MigrationManager migrationManager = new MigrationManager(this);
            migrationManager.doMigrate();
            UserAuthenticationService userAuthenticationService = new UserAuthenticationService(this.store);
            userAuthenticationService.authenticate(username, password);
        }
        catch (Exception e) {
            log.error("Error occurred while initializing the database", (Throwable)e);
            if (this.store != null && !this.store.isClosed()) {
                try {
                    this.store.close();
                }
                catch (Exception ex) {
                    log.error("Error occurred while closing the database");
                    throw new NitriteIOException("Failed to close database", ex);
                }
            }
            if (e instanceof NitriteException) {
                throw e;
            }
            throw new NitriteIOException("Failed to initialize database", e);
        }
    }

    private void validateUserCredentials(String username, String password) {
        if (StringUtils.isNullOrEmpty(username) && StringUtils.isNullOrEmpty(password)) {
            return;
        }
        if (StringUtils.isNullOrEmpty(username)) {
            throw new NitriteSecurityException("Username is required");
        }
        if (StringUtils.isNullOrEmpty(password)) {
            throw new NitriteSecurityException("Password is required");
        }
    }

    private void prepareDatabaseMetaData() {
        this.storeInfo = this.store.openMap("$nitrite_store_info", String.class, Document.class);
        if (this.storeInfo.isEmpty()) {
            StoreMetaData storeMetadata = new StoreMetaData();
            storeMetadata.setCreateTime(System.currentTimeMillis());
            storeMetadata.setStoreVersion(this.store.getStoreVersion());
            storeMetadata.setNitriteVersion(Constants.NITRITE_VERSION);
            storeMetadata.setSchemaVersion(this.nitriteConfig.getSchemaVersion());
            this.storeInfo.put("$nitrite_store_info", storeMetadata.getInfo());
        }
    }
}

