/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.collection;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import org.dizitart.no2.NitriteConfig;
import org.dizitart.no2.collection.DefaultNitriteCollection;
import org.dizitart.no2.collection.Document;
import org.dizitart.no2.collection.NitriteCollection;
import org.dizitart.no2.collection.NitriteId;
import org.dizitart.no2.common.concurrent.LockService;
import org.dizitart.no2.common.util.ValidationUtils;
import org.dizitart.no2.exceptions.NitriteIOException;
import org.dizitart.no2.exceptions.ValidationException;
import org.dizitart.no2.store.NitriteMap;
import org.dizitart.no2.store.NitriteStore;
import org.dizitart.no2.store.StoreCatalog;

public class CollectionFactory {
    private final Map<String, NitriteCollection> collectionMap = new HashMap<String, NitriteCollection>();
    private final LockService lockService;

    public CollectionFactory(LockService lockService) {
        this.lockService = lockService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NitriteCollection getCollection(String name, NitriteConfig nitriteConfig, boolean writeCatalogue) {
        ValidationUtils.notNull(nitriteConfig, "Configuration is null while creating collection");
        ValidationUtils.notEmpty(name, "Collection name is null or empty");
        Lock lock = this.lockService.getWriteLock(this.getClass().getName());
        try {
            lock.lock();
            if (this.collectionMap.containsKey(name)) {
                NitriteCollection collection = this.collectionMap.get(name);
                if (collection.isDropped() || !collection.isOpen()) {
                    this.collectionMap.remove(name);
                    NitriteCollection nitriteCollection = this.createCollection(name, nitriteConfig, writeCatalogue);
                    return nitriteCollection;
                }
                NitriteCollection nitriteCollection = this.collectionMap.get(name);
                return nitriteCollection;
            }
            NitriteCollection nitriteCollection = this.createCollection(name, nitriteConfig, writeCatalogue);
            return nitriteCollection;
        }
        finally {
            lock.unlock();
        }
    }

    private NitriteCollection createCollection(String name, NitriteConfig nitriteConfig, boolean writeCatalog) {
        NitriteStore<Document> store = nitriteConfig.getNitriteStore();
        if (writeCatalog) {
            if (store.getRepositoryRegistry().contains(name)) {
                throw new ValidationException("A repository with same name already exists");
            }
            for (Set<String> set : store.getKeyedRepositoryRegistry().values()) {
                if (!set.contains(name)) continue;
                throw new ValidationException("A keyed repository with same name already exists");
            }
        }
        NitriteMap<NitriteId, Document> nitriteMap = store.openMap(name, NitriteId.class, Document.class);
        DefaultNitriteCollection collection = new DefaultNitriteCollection(name, nitriteMap, nitriteConfig, this.lockService);
        if (writeCatalog) {
            this.collectionMap.put(name, collection);
            StoreCatalog storeCatalog = store.getCatalog();
            if (!storeCatalog.hasEntry(name)) {
                storeCatalog.writeCollectionEntry(name);
            }
        }
        return collection;
    }

    public void clear() {
        Lock lock = this.lockService.getWriteLock(this.getClass().getName());
        try {
            lock.lock();
            for (NitriteCollection collection : this.collectionMap.values()) {
                if (!collection.isOpen()) continue;
                collection.close();
            }
            this.collectionMap.clear();
        }
        catch (Exception e) {
            throw new NitriteIOException("Failed to close a collection", e);
        }
        finally {
            lock.unlock();
        }
    }
}

