/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.collection;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import lombok.Generated;
import org.dizitart.no2.collection.SnowflakeIdGenerator;
import org.dizitart.no2.exceptions.InvalidIdException;

public final class NitriteId
implements Comparable<NitriteId>,
Serializable {
    private static final long serialVersionUID = 1477462375L;
    private static final SnowflakeIdGenerator generator = new SnowflakeIdGenerator();
    private String idValue;

    private NitriteId() {
        this.idValue = Long.toString(generator.getId());
    }

    private NitriteId(String value) {
        this.idValue = value;
    }

    public static NitriteId newId() {
        return new NitriteId();
    }

    public static NitriteId createId(String value) {
        NitriteId.validId(value);
        return new NitriteId(value);
    }

    public static boolean validId(Object value) {
        if (value == null) {
            throw new InvalidIdException("id cannot be null");
        }
        try {
            Long.parseLong(value.toString());
            return true;
        }
        catch (Exception e) {
            throw new InvalidIdException("id must be a string representation of 64bit integer number " + value);
        }
    }

    @Override
    public int compareTo(NitriteId other) {
        if (other.idValue == null) {
            throw new InvalidIdException("Cannot compare with null id");
        }
        return Long.compare(Long.parseLong(this.idValue), Long.parseLong(other.idValue));
    }

    public String toString() {
        if (this.idValue != null) {
            return "[" + this.idValue + "]NO\u2082";
        }
        return "";
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeUTF(this.idValue);
    }

    private void readObject(ObjectInputStream stream) throws IOException {
        this.idValue = stream.readUTF();
    }

    @Generated
    public String getIdValue() {
        return this.idValue;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NitriteId)) {
            return false;
        }
        NitriteId other = (NitriteId)o;
        String this$idValue = this.getIdValue();
        String other$idValue = other.getIdValue();
        return !(this$idValue == null ? other$idValue != null : !this$idValue.equals(other$idValue));
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $idValue = this.getIdValue();
        result = result * 59 + ($idValue == null ? 43 : $idValue.hashCode());
        return result;
    }
}

