/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.collection.operation;

import java.util.Collection;
import org.dizitart.no2.NitriteConfig;
import org.dizitart.no2.collection.Document;
import org.dizitart.no2.collection.DocumentCursor;
import org.dizitart.no2.collection.FindOptions;
import org.dizitart.no2.collection.NitriteId;
import org.dizitart.no2.collection.UpdateOptions;
import org.dizitart.no2.collection.events.CollectionEventInfo;
import org.dizitart.no2.collection.events.CollectionEventListener;
import org.dizitart.no2.collection.operation.DocumentIndexWriter;
import org.dizitart.no2.collection.operation.IndexOperations;
import org.dizitart.no2.collection.operation.ReadOperations;
import org.dizitart.no2.collection.operation.WriteOperations;
import org.dizitart.no2.common.Fields;
import org.dizitart.no2.common.WriteResult;
import org.dizitart.no2.common.event.EventBus;
import org.dizitart.no2.common.meta.Attributes;
import org.dizitart.no2.common.processors.Processor;
import org.dizitart.no2.common.processors.ProcessorChain;
import org.dizitart.no2.filters.Filter;
import org.dizitart.no2.index.IndexDescriptor;
import org.dizitart.no2.store.NitriteMap;
import org.dizitart.no2.store.StoreCatalog;

public class CollectionOperations
implements AutoCloseable {
    private final String collectionName;
    private final NitriteConfig nitriteConfig;
    private final NitriteMap<NitriteId, Document> nitriteMap;
    private final EventBus<CollectionEventInfo<?>, CollectionEventListener> eventBus;
    private ProcessorChain processorChain;
    private IndexOperations indexOperations;
    private WriteOperations writeOperations;
    private ReadOperations readOperations;

    public CollectionOperations(String collectionName, NitriteMap<NitriteId, Document> nitriteMap, NitriteConfig nitriteConfig, EventBus<CollectionEventInfo<?>, CollectionEventListener> eventBus) {
        this.collectionName = collectionName;
        this.nitriteMap = nitriteMap;
        this.nitriteConfig = nitriteConfig;
        this.eventBus = eventBus;
        this.initialize();
    }

    public void addProcessor(Processor processor) {
        this.processorChain.add(processor);
    }

    public void createIndex(Fields fields, String indexType) {
        this.indexOperations.createIndex(fields, indexType);
    }

    public IndexDescriptor findIndex(Fields fields) {
        return this.indexOperations.findIndexDescriptor(fields);
    }

    public void rebuildIndex(IndexDescriptor indexDescriptor) {
        this.indexOperations.buildIndex(indexDescriptor, true);
    }

    public Collection<IndexDescriptor> listIndexes() {
        return this.indexOperations.listIndexes();
    }

    public boolean hasIndex(Fields fields) {
        return this.indexOperations.hasIndexEntry(fields);
    }

    public boolean isIndexing(Fields fields) {
        return this.indexOperations.isIndexing(fields);
    }

    public void dropIndex(Fields fields) {
        this.indexOperations.dropIndex(fields);
    }

    public void dropAllIndices() {
        this.indexOperations.dropAllIndices();
    }

    public WriteResult insert(Document[] documents) {
        return this.writeOperations.insert(documents);
    }

    public WriteResult update(Filter filter, Document update, UpdateOptions updateOptions) {
        return this.writeOperations.update(filter, update, updateOptions);
    }

    public WriteResult remove(Document document) {
        return this.writeOperations.remove(document);
    }

    public WriteResult remove(Filter filter, boolean justOnce) {
        return this.writeOperations.remove(filter, justOnce);
    }

    public DocumentCursor find(Filter filter, FindOptions findOptions) {
        return this.readOperations.find(filter, findOptions);
    }

    public Document getById(NitriteId nitriteId) {
        return this.readOperations.getById(nitriteId);
    }

    public void dropCollection() {
        this.indexOperations.dropAllIndices();
        this.dropNitriteMap();
    }

    public long getSize() {
        return this.nitriteMap.size();
    }

    public Attributes getAttributes() {
        return this.nitriteMap != null ? this.nitriteMap.getAttributes() : null;
    }

    public void setAttributes(Attributes attributes) {
        this.nitriteMap.setAttributes(attributes);
    }

    @Override
    public void close() {
        if (this.indexOperations != null) {
            this.indexOperations.close();
        }
        this.nitriteMap.close();
    }

    public void clear() {
        this.nitriteMap.clear();
        this.indexOperations.clear();
    }

    public void initialize() {
        this.processorChain = new ProcessorChain();
        this.indexOperations = new IndexOperations(this.collectionName, this.nitriteConfig, this.nitriteMap, this.eventBus);
        this.readOperations = new ReadOperations(this.collectionName, this.indexOperations, this.nitriteConfig, this.nitriteMap, this.processorChain);
        DocumentIndexWriter indexWriter = new DocumentIndexWriter(this.nitriteConfig, this.indexOperations);
        this.writeOperations = new WriteOperations(indexWriter, this.readOperations, this.nitriteMap, this.eventBus, this.processorChain);
    }

    private void dropNitriteMap() {
        StoreCatalog catalog = this.nitriteMap.getStore().getCatalog();
        catalog.remove(this.nitriteMap.getName());
        this.nitriteMap.drop();
    }
}

