/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.collection.operation;

import java.util.Collection;
import org.dizitart.no2.NitriteConfig;
import org.dizitart.no2.collection.Document;
import org.dizitart.no2.collection.operation.IndexOperations;
import org.dizitart.no2.common.FieldValues;
import org.dizitart.no2.common.Fields;
import org.dizitart.no2.common.util.DocumentUtils;
import org.dizitart.no2.index.IndexDescriptor;
import org.dizitart.no2.index.NitriteIndexer;

class DocumentIndexWriter {
    private final NitriteConfig nitriteConfig;
    private final IndexOperations indexOperations;

    DocumentIndexWriter(NitriteConfig nitriteConfig, IndexOperations indexOperations) {
        this.nitriteConfig = nitriteConfig;
        this.indexOperations = indexOperations;
    }

    void writeIndexEntry(Document document) {
        Collection<IndexDescriptor> indexEntries = this.indexOperations.listIndexes();
        if (indexEntries != null) {
            for (IndexDescriptor indexDescriptor : indexEntries) {
                String indexType = indexDescriptor.getIndexType();
                NitriteIndexer nitriteIndexer = this.nitriteConfig.findIndexer(indexType);
                this.writeIndexEntryInternal(indexDescriptor, document, nitriteIndexer);
            }
        }
    }

    void removeIndexEntry(Document document) {
        Collection<IndexDescriptor> indexEntries = this.indexOperations.listIndexes();
        if (indexEntries != null) {
            for (IndexDescriptor indexDescriptor : indexEntries) {
                String indexType = indexDescriptor.getIndexType();
                NitriteIndexer nitriteIndexer = this.nitriteConfig.findIndexer(indexType);
                this.removeIndexEntryInternal(indexDescriptor, document, nitriteIndexer);
            }
        }
    }

    void updateIndexEntry(Document oldDocument, Document newDocument, Document updatedFields) {
        Collection<IndexDescriptor> indexEntries = this.indexOperations.listIndexes();
        if (indexEntries != null) {
            for (IndexDescriptor indexDescriptor : indexEntries) {
                Fields fields = indexDescriptor.getFields();
                if (!DocumentUtils.isAffectedByUpdate(fields, updatedFields)) continue;
                String indexType = indexDescriptor.getIndexType();
                NitriteIndexer nitriteIndexer = this.nitriteConfig.findIndexer(indexType);
                this.removeIndexEntryInternal(indexDescriptor, oldDocument, nitriteIndexer);
                this.writeIndexEntryInternal(indexDescriptor, newDocument, nitriteIndexer);
            }
        }
    }

    private void writeIndexEntryInternal(IndexDescriptor indexDescriptor, Document document, NitriteIndexer nitriteIndexer) {
        if (indexDescriptor != null) {
            Fields fields = indexDescriptor.getFields();
            FieldValues fieldValues = DocumentUtils.getValues(document, fields);
            if (this.indexOperations.shouldRebuildIndex(fields)) {
                this.indexOperations.buildIndex(indexDescriptor, true);
            } else if (nitriteIndexer != null) {
                nitriteIndexer.writeIndexEntry(fieldValues, indexDescriptor, this.nitriteConfig);
            }
        }
    }

    private void removeIndexEntryInternal(IndexDescriptor indexDescriptor, Document document, NitriteIndexer nitriteIndexer) {
        if (indexDescriptor != null) {
            Fields fields = indexDescriptor.getFields();
            FieldValues fieldValues = DocumentUtils.getValues(document, fields);
            if (this.indexOperations.shouldRebuildIndex(fields)) {
                this.indexOperations.buildIndex(indexDescriptor, true);
            } else if (nitriteIndexer != null) {
                nitriteIndexer.removeIndexEntry(fieldValues, indexDescriptor, this.nitriteConfig);
            }
        }
    }
}

