/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.collection.operation;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.concurrent.atomic.AtomicBoolean;
import org.dizitart.no2.NitriteConfig;
import org.dizitart.no2.common.Fields;
import org.dizitart.no2.common.util.IndexUtils;
import org.dizitart.no2.index.IndexDescriptor;
import org.dizitart.no2.index.IndexMeta;
import org.dizitart.no2.index.NitriteIndexer;
import org.dizitart.no2.store.NitriteMap;
import org.dizitart.no2.store.NitriteStore;

public class IndexManager
implements AutoCloseable {
    private final NitriteConfig nitriteConfig;
    private final NitriteStore<?> nitriteStore;
    private final String collectionName;
    private final NitriteMap<Fields, IndexMeta> indexMetaMap;
    private Collection<IndexDescriptor> indexDescriptorCache;

    public IndexManager(String collectionName, NitriteConfig nitriteConfig) {
        this.collectionName = collectionName;
        this.nitriteConfig = nitriteConfig;
        this.nitriteStore = nitriteConfig.getNitriteStore();
        this.indexMetaMap = this.getIndexMetaMap();
        this.initialize();
    }

    public boolean hasIndexDescriptor(Fields fields) {
        return !this.findMatchingIndexDescriptors(fields).isEmpty();
    }

    public Collection<IndexDescriptor> getIndexDescriptors() {
        if (this.indexDescriptorCache == null) {
            this.indexDescriptorCache = this.listIndexDescriptors();
        }
        return this.indexDescriptorCache;
    }

    public Collection<IndexDescriptor> findMatchingIndexDescriptors(Fields fields) {
        ArrayList<IndexDescriptor> indexDescriptors = new ArrayList<IndexDescriptor>();
        for (IndexDescriptor indexDescriptor : this.getIndexDescriptors()) {
            if (!indexDescriptor.getFields().startsWith(fields)) continue;
            indexDescriptors.add(indexDescriptor);
        }
        return indexDescriptors;
    }

    public IndexDescriptor findExactIndexDescriptor(Fields fields) {
        IndexMeta meta = this.indexMetaMap.get(fields);
        if (meta != null) {
            return meta.getIndexDescriptor();
        }
        return null;
    }

    public void markIndexDirty(IndexDescriptor indexDescriptor) {
        Fields fields = indexDescriptor.getFields();
        this.markDirty(fields, true);
    }

    @Override
    public void close() {
        if (!this.indexMetaMap.isClosed() && !this.indexMetaMap.isDropped()) {
            Iterable<IndexMeta> indexMetas = this.indexMetaMap.values();
            for (IndexMeta indexMeta : indexMetas) {
                if (indexMeta == null || indexMeta.getIndexDescriptor() == null) continue;
                String indexMapName = indexMeta.getIndexMap();
                NitriteMap indexMap = this.nitriteStore.openMap(indexMapName, Object.class, Object.class);
                indexMap.close();
            }
            this.indexMetaMap.close();
        }
    }

    public void clearAll() {
        if (!this.indexMetaMap.isClosed() && !this.indexMetaMap.isDropped()) {
            Iterable<IndexMeta> indexMetas = this.indexMetaMap.values();
            for (IndexMeta indexMeta : indexMetas) {
                if (indexMeta == null || indexMeta.getIndexDescriptor() == null) continue;
                String indexMapName = indexMeta.getIndexMap();
                NitriteMap indexMap = this.nitriteStore.openMap(indexMapName, Object.class, Object.class);
                indexMap.clear();
            }
        }
    }

    boolean isDirtyIndex(Fields fields) {
        IndexMeta meta = this.indexMetaMap.get(fields);
        return meta != null && meta.getIsDirty().get();
    }

    Collection<IndexDescriptor> listIndexDescriptors() {
        LinkedHashSet<IndexDescriptor> indexSet = new LinkedHashSet<IndexDescriptor>();
        Iterable<IndexMeta> iterable = this.indexMetaMap.values();
        for (IndexMeta indexMeta : iterable) {
            indexSet.add(indexMeta.getIndexDescriptor());
        }
        return Collections.unmodifiableSet(indexSet);
    }

    IndexDescriptor createIndexDescriptor(Fields fields, String indexType) {
        this.validateIndexRequest(fields, indexType);
        IndexDescriptor index = new IndexDescriptor(indexType, fields, this.collectionName);
        IndexMeta indexMeta = new IndexMeta();
        indexMeta.setIndexDescriptor(index);
        indexMeta.setIsDirty(new AtomicBoolean(false));
        indexMeta.setIndexMap(IndexUtils.deriveIndexMapName(index));
        this.indexMetaMap.put(fields, indexMeta);
        this.updateIndexDescriptorCache();
        return index;
    }

    void dropIndexDescriptor(Fields fields) {
        IndexMeta meta = this.indexMetaMap.get(fields);
        if (meta != null && meta.getIndexDescriptor() != null) {
            String indexMapName = meta.getIndexMap();
            NitriteMap indexMap = this.nitriteStore.openMap(indexMapName, Object.class, Object.class);
            indexMap.drop();
        }
        this.indexMetaMap.remove(fields);
        this.updateIndexDescriptorCache();
    }

    void dropIndexMeta() {
        this.indexMetaMap.drop();
    }

    void beginIndexing(Fields fields) {
        this.markDirty(fields, true);
    }

    void endIndexing(Fields fields) {
        this.markDirty(fields, false);
    }

    private void initialize() {
        this.updateIndexDescriptorCache();
    }

    private void markDirty(Fields fields, boolean dirty) {
        IndexMeta meta = this.indexMetaMap.get(fields);
        if (meta != null && meta.getIndexDescriptor() != null) {
            meta.getIsDirty().set(dirty);
        }
    }

    private NitriteMap<Fields, IndexMeta> getIndexMetaMap() {
        String mapName = IndexUtils.deriveIndexMetaMapName(this.collectionName);
        return this.nitriteStore.openMap(mapName, Fields.class, IndexMeta.class);
    }

    private void updateIndexDescriptorCache() {
        this.indexDescriptorCache = this.listIndexDescriptors();
    }

    private void validateIndexRequest(Fields fields, String indexType) {
        NitriteIndexer indexer = this.nitriteConfig.findIndexer(indexType);
        indexer.validateIndex(fields);
    }
}

