/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.common.concurrent;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class LockService {
    private final Map<String, ReentrantReadWriteLock> lockRegistry = new HashMap<String, ReentrantReadWriteLock>();

    public synchronized Lock getReadLock(String name) {
        if (this.lockRegistry.containsKey(name)) {
            ReentrantReadWriteLock rwLock = this.lockRegistry.get(name);
            return rwLock.readLock();
        }
        ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();
        this.lockRegistry.put(name, rwLock);
        return rwLock.readLock();
    }

    public synchronized Lock getWriteLock(String name) {
        if (this.lockRegistry.containsKey(name)) {
            ReentrantReadWriteLock rwLock = this.lockRegistry.get(name);
            return rwLock.writeLock();
        }
        ReentrantReadWriteLock rwLock = new ReentrantReadWriteLock();
        this.lockRegistry.put(name, rwLock);
        return rwLock.writeLock();
    }
}

