/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.common.mapper;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dizitart.no2.NitriteConfig;
import org.dizitart.no2.collection.Document;
import org.dizitart.no2.collection.NitriteId;
import org.dizitart.no2.common.mapper.EntityConverter;
import org.dizitart.no2.common.mapper.NitriteMapper;
import org.dizitart.no2.common.util.Iterables;
import org.dizitart.no2.common.util.ObjectUtils;
import org.dizitart.no2.common.util.ValidationUtils;
import org.dizitart.no2.exceptions.ObjectMappingException;

public class SimpleNitriteMapper
implements NitriteMapper {
    private final Set<Class<?>> valueTypes = new HashSet();
    private final Map<Class<?>, EntityConverter<?>> converterRegistry = new HashMap();

    public SimpleNitriteMapper(Class<?> ... valueTypes) {
        this.init(Iterables.listOf(valueTypes));
    }

    @Override
    public <Source, Target> Object tryConvert(Source source, Class<Target> type) {
        if (source == null) {
            return null;
        }
        if (this.isValue(source)) {
            return source;
        }
        if (Document.class.isAssignableFrom(type)) {
            if (source instanceof Document) {
                return source;
            }
            return this.convertToDocument(source);
        }
        if (source instanceof Document) {
            return this.convertFromDocument((Document)source, type);
        }
        if (source.getClass().isAssignableFrom(type) || type.isAssignableFrom(source.getClass())) {
            return source;
        }
        throw new ObjectMappingException("Can't convert object to type " + type + ", try registering a EntityConverter for it.");
    }

    public void registerEntityConverter(EntityConverter<?> entityConverter) {
        ValidationUtils.notNull(entityConverter, "entityConverter cannot be null");
        this.converterRegistry.put(entityConverter.getEntityType(), entityConverter);
    }

    @Override
    public void initialize(NitriteConfig nitriteConfig) {
    }

    protected <Target> Target convertFromDocument(Document source, Class<Target> type) {
        if (source == null) {
            return null;
        }
        try (EntityConverter<?> converter = this.findConverter(type);){
            if (converter != null) {
                Object obj = converter.fromDocument(source, this);
                return (Target)obj;
            }
        }
        throw new ObjectMappingException("Can't convert Document to type " + type + ", try registering a EntityConverter for it.");
    }

    protected <Source> Document convertToDocument(Source source) {
        try (EntityConverter<?> converter = this.findConverter(source.getClass());){
            if (converter != null) {
                Document document = converter.toDocument(source, this);
                return document;
            }
        }
        throw new ObjectMappingException("Can't convert object of type " + source.getClass().getName() + " to Document, try registering a EntityConverter for it.");
    }

    private EntityConverter<?> findConverter(Class<?> type) {
        if (this.converterRegistry.containsKey(type)) {
            return this.converterRegistry.get(type);
        }
        for (EntityConverter<?> value : this.converterRegistry.values()) {
            if (!value.getEntityType().isAssignableFrom(type)) continue;
            return value;
        }
        return null;
    }

    private boolean isValueType(Class<?> type) {
        if (type.isPrimitive() && type != Void.TYPE) {
            return true;
        }
        if (this.valueTypes.contains(type)) {
            return true;
        }
        for (Class<?> valueType : this.valueTypes) {
            if (!valueType.isAssignableFrom(type)) continue;
            return true;
        }
        return false;
    }

    private boolean isValue(Object object) {
        return this.isValueType(object.getClass());
    }

    private void init(List<Class<?>> valueTypes) {
        this.valueTypes.addAll(ObjectUtils.builtInTypes());
        this.valueTypes.add(Enum.class);
        this.valueTypes.add(NitriteId.class);
        if (valueTypes != null && !valueTypes.isEmpty()) {
            this.valueTypes.addAll(valueTypes);
        }
    }
}

