/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.common.module;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.dizitart.no2.NitriteConfig;
import org.dizitart.no2.common.mapper.EntityConverter;
import org.dizitart.no2.common.mapper.NitriteMapper;
import org.dizitart.no2.common.mapper.SimpleNitriteMapper;
import org.dizitart.no2.common.module.NitriteModule;
import org.dizitart.no2.common.module.NitritePlugin;
import org.dizitart.no2.exceptions.NitriteIOException;
import org.dizitart.no2.exceptions.PluginException;
import org.dizitart.no2.index.NitriteIndexer;
import org.dizitart.no2.index.NitriteTextIndexer;
import org.dizitart.no2.index.NonUniqueIndexer;
import org.dizitart.no2.index.UniqueIndexer;
import org.dizitart.no2.store.NitriteStore;
import org.dizitart.no2.store.memory.InMemoryStoreModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginManager
implements AutoCloseable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger((String)"nitrite");
    private final List<EntityConverter<?>> entityConverters;
    private final Map<String, NitriteIndexer> indexerMap = new HashMap<String, NitriteIndexer>();
    private final NitriteConfig nitriteConfig;
    private NitriteMapper nitriteMapper;
    private NitriteStore<?> nitriteStore;

    public PluginManager(NitriteConfig nitriteConfig) {
        this.nitriteConfig = nitriteConfig;
        this.entityConverters = new ArrayList();
    }

    public void loadModule(NitriteModule module) {
        if (module != null && module.plugins() != null) {
            for (NitritePlugin plugin : module.plugins()) {
                this.loadPlugin(plugin);
            }
        }
    }

    public void findAndLoadPlugins() {
        try {
            this.loadInternalPlugins();
        }
        catch (Exception e) {
            log.error("Error while loading internal plugins", (Throwable)e);
            throw new PluginException("Error while loading internal plugins", e);
        }
    }

    public void initializePlugins() {
        if (this.nitriteStore == null) {
            log.error("No storage engine found. Please ensure that a storage module has been loaded properly");
            throw new NitriteIOException("No nitrite storage engine found");
        }
        this.initializePlugin(this.nitriteStore);
        if (this.nitriteMapper != null) {
            this.initializePlugin(this.nitriteMapper);
        }
        if (!this.indexerMap.isEmpty()) {
            for (NitriteIndexer nitriteIndexer : this.indexerMap.values()) {
                this.initializePlugin(nitriteIndexer);
            }
        }
    }

    @Override
    public void close() {
        for (NitriteIndexer nitriteIndexer : this.indexerMap.values()) {
            nitriteIndexer.close();
        }
        if (this.nitriteMapper != null) {
            this.nitriteMapper.close();
        }
        if (this.nitriteStore != null) {
            this.nitriteStore.close();
        }
    }

    private void loadPlugin(NitritePlugin plugin) {
        this.populatePlugins(plugin);
    }

    private void initializePlugin(NitritePlugin plugin) {
        plugin.initialize(this.nitriteConfig);
    }

    private void populatePlugins(NitritePlugin plugin) {
        if (plugin != null) {
            if (plugin instanceof NitriteIndexer) {
                this.loadIndexer((NitriteIndexer)plugin);
            } else if (plugin instanceof NitriteMapper) {
                this.loadNitriteMapper((NitriteMapper)plugin);
            } else if (plugin instanceof NitriteStore) {
                this.loadNitriteStore((NitriteStore)plugin);
            } else if (plugin instanceof EntityConverter) {
                this.loadEntityConverter((EntityConverter)plugin);
            } else {
                plugin.close();
                throw new PluginException("Unknown plugin type: " + plugin.getClass().getName());
            }
        }
    }

    private void loadNitriteStore(NitriteStore<?> nitriteStore) {
        if (this.nitriteStore != null) {
            nitriteStore.close();
            throw new PluginException("Multiple nitrite store plugins found");
        }
        this.nitriteStore = nitriteStore;
    }

    private void loadNitriteMapper(NitriteMapper nitriteMapper) {
        if (this.nitriteMapper != null) {
            nitriteMapper.close();
            throw new PluginException("Multiple nitrite mapper plugins found");
        }
        this.nitriteMapper = nitriteMapper;
    }

    private void loadEntityConverter(EntityConverter<?> entityConverter) {
        if (entityConverter != null) {
            this.entityConverters.add(entityConverter);
        }
    }

    private synchronized void loadIndexer(NitriteIndexer nitriteIndexer) {
        if (this.indexerMap.containsKey(nitriteIndexer.getIndexType())) {
            nitriteIndexer.close();
            throw new PluginException("Multiple indexer plugins found for type: " + nitriteIndexer.getIndexType());
        }
        this.indexerMap.put(nitriteIndexer.getIndexType(), nitriteIndexer);
    }

    protected void loadInternalPlugins() {
        NitritePlugin plugin;
        if (!this.indexerMap.containsKey("Unique")) {
            log.debug("Loading default unique indexer");
            plugin = new UniqueIndexer();
            this.loadPlugin(plugin);
        }
        if (!this.indexerMap.containsKey("NonUnique")) {
            log.debug("Loading default non-unique indexer");
            plugin = new NonUniqueIndexer();
            this.loadPlugin(plugin);
        }
        if (!this.indexerMap.containsKey("Fulltext")) {
            log.debug("Loading nitrite text indexer");
            plugin = new NitriteTextIndexer();
            this.loadPlugin(plugin);
        }
        if (this.nitriteMapper == null) {
            log.debug("Loading mappable mapper");
            plugin = new SimpleNitriteMapper(new Class[0]);
            this.loadPlugin(plugin);
        }
        if (this.nitriteMapper != null && this.nitriteMapper instanceof SimpleNitriteMapper) {
            SimpleNitriteMapper mapper = (SimpleNitriteMapper)this.nitriteMapper;
            log.debug("Loading entity converters");
            if (!this.nitriteConfig.getEntityConverters().isEmpty()) {
                for (EntityConverter<?> entityConverter : this.nitriteConfig.getEntityConverters()) {
                    mapper.registerEntityConverter(entityConverter);
                }
            }
            for (EntityConverter<?> entityConverter : this.entityConverters) {
                mapper.registerEntityConverter(entityConverter);
            }
        }
        if (this.nitriteStore == null) {
            this.loadModule(new InMemoryStoreModule());
            log.warn("No persistent storage module found, creating an in-memory database");
        }
    }

    @Generated
    public List<EntityConverter<?>> getEntityConverters() {
        return this.entityConverters;
    }

    @Generated
    public Map<String, NitriteIndexer> getIndexerMap() {
        return this.indexerMap;
    }

    @Generated
    public NitriteConfig getNitriteConfig() {
        return this.nitriteConfig;
    }

    @Generated
    public NitriteMapper getNitriteMapper() {
        return this.nitriteMapper;
    }

    @Generated
    public NitriteStore<?> getNitriteStore() {
        return this.nitriteStore;
    }
}

