/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.common.processors;

import org.dizitart.no2.collection.Document;
import org.dizitart.no2.collection.NitriteCollection;
import org.dizitart.no2.collection.UpdateOptions;
import org.dizitart.no2.common.PersistentCollection;
import org.dizitart.no2.common.util.DocumentUtils;
import org.dizitart.no2.repository.ObjectRepository;

public interface Processor {
    default public Document processBeforeWrite(Document document) {
        return document;
    }

    default public Document processAfterRead(Document document) {
        return document;
    }

    default public void process(PersistentCollection<?> collection) {
        NitriteCollection nitriteCollection = null;
        if (collection instanceof NitriteCollection) {
            nitriteCollection = (NitriteCollection)collection;
        } else if (collection instanceof ObjectRepository) {
            ObjectRepository repository = (ObjectRepository)collection;
            nitriteCollection = repository.getDocumentCollection();
        }
        if (nitriteCollection != null) {
            for (Document document : nitriteCollection.find()) {
                Document processed = this.processBeforeWrite(document);
                nitriteCollection.update(DocumentUtils.createUniqueFilter(document), processed, UpdateOptions.updateOptions(false));
            }
        }
    }
}

