/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.common.streams;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import org.dizitart.no2.collection.Document;
import org.dizitart.no2.collection.NitriteId;
import org.dizitart.no2.common.RecordStream;
import org.dizitart.no2.common.tuples.Pair;

public class DistinctStream
implements RecordStream<Pair<NitriteId, Document>> {
    private final RecordStream<Pair<NitriteId, Document>> rawStream;

    public DistinctStream(RecordStream<Pair<NitriteId, Document>> rawStream) {
        this.rawStream = rawStream;
    }

    @Override
    public Iterator<Pair<NitriteId, Document>> iterator() {
        Iterator<Pair<NitriteId, Document>> iterator = this.rawStream == null ? Collections.emptyIterator() : this.rawStream.iterator();
        return new DistinctStreamIterator(iterator);
    }

    private static class DistinctStreamIterator
    implements Iterator<Pair<NitriteId, Document>> {
        private final Iterator<Pair<NitriteId, Document>> iterator;
        private final Set<NitriteId> scannedIds;
        private Pair<NitriteId, Document> nextPair;
        private boolean nextPairSet = false;

        public DistinctStreamIterator(Iterator<Pair<NitriteId, Document>> iterator) {
            this.iterator = iterator;
            this.scannedIds = new HashSet<NitriteId>();
        }

        @Override
        public boolean hasNext() {
            return this.nextPairSet || this.setNextId();
        }

        @Override
        public Pair<NitriteId, Document> next() {
            if (!this.nextPairSet && !this.setNextId()) {
                throw new NoSuchElementException();
            }
            this.nextPairSet = false;
            return this.nextPair;
        }

        private boolean setNextId() {
            while (this.iterator.hasNext()) {
                Pair<NitriteId, Document> pair = this.iterator.next();
                if (this.scannedIds.contains(pair.getFirst())) continue;
                this.scannedIds.add(pair.getFirst());
                this.nextPair = pair;
                this.nextPairSet = true;
                return true;
            }
            return false;
        }
    }
}

