/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.common.streams;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import org.dizitart.no2.collection.Document;
import org.dizitart.no2.collection.DocumentCursor;
import org.dizitart.no2.collection.NitriteId;
import org.dizitart.no2.common.Lookup;
import org.dizitart.no2.common.RecordStream;
import org.dizitart.no2.common.processors.ProcessorChain;
import org.dizitart.no2.common.tuples.Pair;
import org.dizitart.no2.common.util.ObjectUtils;
import org.dizitart.no2.exceptions.InvalidOperationException;

public class JoinedDocumentStream
implements RecordStream<Document> {
    private final RecordStream<Pair<NitriteId, Document>> recordStream;
    private final DocumentCursor foreignCursor;
    private final Lookup lookup;
    private final ProcessorChain processorChain;

    JoinedDocumentStream(RecordStream<Pair<NitriteId, Document>> recordStream, DocumentCursor foreignCursor, Lookup lookup, ProcessorChain processorChain) {
        this.recordStream = recordStream;
        this.foreignCursor = foreignCursor;
        this.lookup = lookup;
        this.processorChain = processorChain;
    }

    @Override
    public Iterator<Document> iterator() {
        Iterator<Pair<NitriteId, Document>> iterator = this.recordStream == null ? Collections.emptyIterator() : this.recordStream.iterator();
        return new JoinedDocumentIterator(iterator, this.processorChain, this.foreignCursor, this.lookup);
    }

    public String toString() {
        return this.toList().toString();
    }

    private static class JoinedDocumentIterator
    implements Iterator<Document> {
        private final Iterator<Pair<NitriteId, Document>> iterator;
        private final ProcessorChain processorChain;
        private final DocumentCursor foreignCursor;
        private final Lookup lookup;

        public JoinedDocumentIterator(Iterator<Pair<NitriteId, Document>> iterator, ProcessorChain processorChain, DocumentCursor foreignCursor, Lookup lookup) {
            this.iterator = iterator;
            this.processorChain = processorChain;
            this.foreignCursor = foreignCursor;
            this.lookup = lookup;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Document next() {
            Pair<NitriteId, Document> next = this.iterator.next();
            Document document = next.getSecond();
            if (document != null) {
                Document unprocessed = document.clone();
                Document processed = this.processorChain.processAfterRead(unprocessed);
                return this.join(processed, this.foreignCursor, this.lookup);
            }
            return null;
        }

        @Override
        public void remove() {
            throw new InvalidOperationException("Remove on a cursor is not supported");
        }

        private Document join(Document localDocument, DocumentCursor foreignCursor, Lookup lookup) {
            Object localObject = localDocument.get(lookup.getLocalField());
            if (localObject == null) {
                return localDocument;
            }
            HashSet<Document> target = new HashSet<Document>();
            for (Document foreignDocument : foreignCursor) {
                Object foreignObject = foreignDocument.get(lookup.getForeignField());
                if (foreignObject == null || !ObjectUtils.deepEquals(foreignObject, localObject)) continue;
                target.add(foreignDocument);
            }
            if (!target.isEmpty()) {
                localDocument.put(lookup.getTargetField(), target);
            }
            return localDocument;
        }
    }
}

