/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.common.streams;

import java.util.Collections;
import java.util.Iterator;
import org.dizitart.no2.collection.Document;
import org.dizitart.no2.collection.NitriteId;
import org.dizitart.no2.common.RecordStream;
import org.dizitart.no2.common.processors.ProcessorChain;
import org.dizitart.no2.common.tuples.Pair;
import org.dizitart.no2.exceptions.InvalidOperationException;

public class ProjectedDocumentStream
implements RecordStream<Document> {
    private final RecordStream<Pair<NitriteId, Document>> recordStream;
    private final Document projection;
    private final ProcessorChain processorChain;

    public ProjectedDocumentStream(RecordStream<Pair<NitriteId, Document>> recordStream, Document projection, ProcessorChain processorChain) {
        this.recordStream = recordStream;
        this.projection = projection;
        this.processorChain = processorChain;
    }

    @Override
    public Iterator<Document> iterator() {
        Iterator<Pair<NitriteId, Document>> iterator = this.recordStream == null ? Collections.emptyIterator() : this.recordStream.iterator();
        return new ProjectedDocumentIterator(iterator, this.processorChain, this.projection);
    }

    public String toString() {
        return this.toList().toString();
    }

    private static class ProjectedDocumentIterator
    implements Iterator<Document> {
        private final Iterator<Pair<NitriteId, Document>> iterator;
        private final ProcessorChain processorChain;
        private Document nextElement = null;
        private final Document projection;

        ProjectedDocumentIterator(Iterator<Pair<NitriteId, Document>> iterator, ProcessorChain processorChain, Document projection) {
            this.iterator = iterator;
            this.processorChain = processorChain;
            this.projection = projection;
            this.nextMatch();
        }

        @Override
        public boolean hasNext() {
            return this.nextElement != null;
        }

        @Override
        public Document next() {
            Document returnValue = this.nextElement.clone();
            this.nextMatch();
            return returnValue;
        }

        private void nextMatch() {
            while (this.iterator.hasNext()) {
                Document projected;
                Pair<NitriteId, Document> next = this.iterator.next();
                Document document = next.getSecond();
                if (document == null || (projected = this.project(document.clone())) == null) continue;
                this.nextElement = projected;
                return;
            }
            this.nextElement = null;
        }

        @Override
        public void remove() {
            throw new InvalidOperationException("Remove on a cursor is not supported");
        }

        private Document project(Document original) {
            if (this.projection == null) {
                return original;
            }
            Document newDoc = Document.createDocument();
            for (String field : this.projection.getFields()) {
                if (!original.containsField(field)) continue;
                Object value = original.get(field);
                newDoc.put(field, value);
            }
            newDoc = this.processorChain.processAfterRead(newDoc);
            return newDoc;
        }
    }
}

