/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.common.streams;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.dizitart.no2.collection.Document;
import org.dizitart.no2.collection.FindPlan;
import org.dizitart.no2.collection.NitriteId;
import org.dizitart.no2.common.RecordStream;
import org.dizitart.no2.common.streams.DocumentSorter;
import org.dizitart.no2.common.tuples.Pair;
import org.dizitart.no2.common.util.Iterables;

public class SortedDocumentStream
implements RecordStream<Pair<NitriteId, Document>> {
    private final FindPlan findPlan;
    private final RecordStream<Pair<NitriteId, Document>> recordStream;

    public SortedDocumentStream(FindPlan findPlan, RecordStream<Pair<NitriteId, Document>> recordStream) {
        this.findPlan = findPlan;
        this.recordStream = recordStream;
    }

    @Override
    public Iterator<Pair<NitriteId, Document>> iterator() {
        if (this.recordStream == null) {
            return Collections.emptyIterator();
        }
        DocumentSorter documentSorter = new DocumentSorter(this.findPlan.getCollator(), this.findPlan.getBlockingSortOrder());
        List<Pair<NitriteId, Document>> recordList = Iterables.toList(this.recordStream);
        Collections.sort(recordList, documentSorter);
        return recordList.iterator();
    }
}

