/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.filters;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.dizitart.no2.collection.Document;
import org.dizitart.no2.collection.NitriteId;
import org.dizitart.no2.common.tuples.Pair;
import org.dizitart.no2.filters.ComparableArrayFilter;
import org.dizitart.no2.index.IndexMap;

class NotInFilter
extends ComparableArrayFilter {
    private final Set<Comparable<?>> comparableSet = new HashSet();

    NotInFilter(String field, Comparable<?> ... values) {
        super(field, values);
        Collections.addAll(this.comparableSet, values);
    }

    @Override
    public boolean apply(Pair<NitriteId, Document> element) {
        Document document = element.getSecond();
        Object fieldValue = document.get(this.getField());
        if (fieldValue instanceof Comparable) {
            Comparable comparable = (Comparable)fieldValue;
            return !this.comparableSet.contains(comparable);
        }
        return true;
    }

    public List<?> applyOnIndex(IndexMap indexMap) {
        ArrayList subMap = new ArrayList();
        ArrayList<NitriteId> nitriteIds = new ArrayList<NitriteId>();
        for (Pair<Comparable<?>, ?> entry : indexMap.entries()) {
            if (this.comparableSet.contains(entry.getFirst())) continue;
            this.processIndexValue(entry.getSecond(), subMap, nitriteIds);
        }
        if (!subMap.isEmpty()) {
            return subMap;
        }
        return nitriteIds;
    }

    @Override
    public String toString() {
        return "(" + this.getField() + " not in " + Arrays.toString((Comparable[])this.getValue()) + ")";
    }

    @Generated
    public Set<Comparable<?>> getComparableSet() {
        return this.comparableSet;
    }
}

