/*
 * Decompiled with CFR 0.152.
 */
package org.dizitart.no2.index;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import lombok.Generated;
import org.dizitart.no2.common.Fields;
import org.dizitart.no2.common.util.ValidationUtils;

public class IndexDescriptor
implements Comparable<IndexDescriptor>,
Serializable {
    private static final long serialVersionUID = 1576690829L;
    private String indexType;
    private Fields fields;
    private String collectionName;

    public IndexDescriptor(String indexType, Fields fields, String collectionName) {
        ValidationUtils.notNull(indexType, "indexType cannot be null");
        ValidationUtils.notNull(fields, "fields cannot be null");
        ValidationUtils.notNull(collectionName, "collectionName cannot be null");
        ValidationUtils.notEmpty(collectionName, "collectionName cannot be empty");
        this.indexType = indexType;
        this.fields = fields;
        this.collectionName = collectionName;
    }

    @Override
    public int compareTo(IndexDescriptor other) {
        if (other == null) {
            return 1;
        }
        if (this.isCompoundIndex() && !other.isCompoundIndex()) {
            return 1;
        }
        if (this.isUniqueIndex() && !other.isUniqueIndex()) {
            return 1;
        }
        if (this.isUniqueIndex()) {
            return this.fields.compareTo(other.fields);
        }
        if (!other.isUniqueIndex()) {
            return this.fields.compareTo(other.fields);
        }
        return -1;
    }

    public boolean isCompoundIndex() {
        return this.fields.getFieldNames().size() > 1;
    }

    private boolean isUniqueIndex() {
        return this.indexType.equals("Unique");
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeUTF(this.indexType);
        stream.writeObject(this.fields);
        stream.writeUTF(this.collectionName);
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        this.indexType = stream.readUTF();
        this.fields = (Fields)stream.readObject();
        this.collectionName = stream.readUTF();
    }

    @Generated
    public void setIndexType(String indexType) {
        this.indexType = indexType;
    }

    @Generated
    public void setFields(Fields fields) {
        this.fields = fields;
    }

    @Generated
    public void setCollectionName(String collectionName) {
        this.collectionName = collectionName;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IndexDescriptor)) {
            return false;
        }
        IndexDescriptor other = (IndexDescriptor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$indexType = this.getIndexType();
        String other$indexType = other.getIndexType();
        if (this$indexType == null ? other$indexType != null : !this$indexType.equals(other$indexType)) {
            return false;
        }
        Fields this$fields = this.getFields();
        Fields other$fields = other.getFields();
        if (this$fields == null ? other$fields != null : !((Object)this$fields).equals(other$fields)) {
            return false;
        }
        String this$collectionName = this.getCollectionName();
        String other$collectionName = other.getCollectionName();
        return !(this$collectionName == null ? other$collectionName != null : !this$collectionName.equals(other$collectionName));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof IndexDescriptor;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $indexType = this.getIndexType();
        result = result * 59 + ($indexType == null ? 43 : $indexType.hashCode());
        Fields $fields = this.getFields();
        result = result * 59 + ($fields == null ? 43 : ((Object)$fields).hashCode());
        String $collectionName = this.getCollectionName();
        result = result * 59 + ($collectionName == null ? 43 : $collectionName.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "IndexDescriptor(indexType=" + this.getIndexType() + ", fields=" + this.getFields() + ", collectionName=" + this.getCollectionName() + ")";
    }

    @Generated
    private IndexDescriptor() {
    }

    @Generated
    public String getIndexType() {
        return this.indexType;
    }

    @Generated
    public Fields getFields() {
        return this.fields;
    }

    @Generated
    public String getCollectionName() {
        return this.collectionName;
    }
}

